/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tls;

import cats.Applicative$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.io.CollectionCompat$;
import fs2.io.CollectionCompat$JIterableOps$;
import fs2.io.Network;
import fs2.io.tcp.Socket;
import fs2.io.tls.DTLSSocket;
import fs2.io.tls.DTLSSocket$;
import fs2.io.tls.TLSContext;
import fs2.io.tls.TLSContext$;
import fs2.io.tls.TLSEngine;
import fs2.io.tls.TLSEngine$;
import fs2.io.tls.TLSParameters;
import fs2.io.tls.TLSSocket;
import fs2.io.tls.TLSSocket$;
import fs2.io.udp.Packet;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class TLSContext$ {
    public static TLSContext$ MODULE$;

    static {
        new TLSContext$();
    }

    public TLSContext fromSSLContext(SSLContext ctx) {
        return new TLSContext(ctx){
            private final SSLContext ctx$1;

            public <F> TLSParameters client$default$2() {
                return TLSContext.client$default$2$(this);
            }

            public <F> None$ client$default$3() {
                return TLSContext.client$default$3$(this);
            }

            public <F> TLSParameters server$default$2() {
                return TLSContext.server$default$2$(this);
            }

            public <F> None$ server$default$3() {
                return TLSContext.server$default$3$(this);
            }

            public <F> TLSParameters dtlsClient$default$3() {
                return TLSContext.dtlsClient$default$3$(this);
            }

            public <F> None$ dtlsClient$default$4() {
                return TLSContext.dtlsClient$default$4$(this);
            }

            public <F> TLSParameters dtlsServer$default$3() {
                return TLSContext.dtlsServer$default$3$(this);
            }

            public <F> None$ dtlsServer$default$4() {
                return TLSContext.dtlsServer$default$4$(this);
            }

            public <F> Resource<F, TLSSocket<F>> client(Socket<F> socket, TLSParameters params, Option<Function1<String, F>> logger, Network<F> F) {
                return this.mkSocket(socket, true, params, logger, F);
            }

            public <F> Resource<F, TLSSocket<F>> server(Socket<F> socket, TLSParameters params, Option<Function1<String, F>> logger, Network<F> F) {
                return this.mkSocket(socket, false, params, logger, F);
            }

            private <F> Resource<F, TLSSocket<F>> mkSocket(Socket<F> socket, boolean clientMode, TLSParameters params, Option<Function1<String, F>> logger, Network<F> F) {
                return Resource$.MODULE$.liftF(this.engine(new TLSEngine.Binding<F>(null, socket){
                    private final Socket socket$1;

                    public F write(Chunk<Object> data, Option<FiniteDuration> timeout) {
                        return this.socket$1.write(data, timeout);
                    }

                    public F read(int maxBytes, Option<FiniteDuration> timeout) {
                        return this.socket$1.read(maxBytes, timeout);
                    }
                    {
                        this.socket$1 = socket$1;
                    }
                }, clientMode, params, logger, F)).flatMap((Function1 & Serializable & scala.Serializable)engine -> TLSSocket$.MODULE$.apply(socket, engine, F.async()));
            }

            public <F> Resource<F, DTLSSocket<F>> dtlsClient(fs2.io.udp.Socket<F> socket, InetSocketAddress remoteAddress, TLSParameters params, Option<Function1<String, F>> logger, Network<F> F) {
                return this.mkDtlsSocket(socket, remoteAddress, true, params, logger, F);
            }

            public <F> Resource<F, DTLSSocket<F>> dtlsServer(fs2.io.udp.Socket<F> socket, InetSocketAddress remoteAddress, TLSParameters params, Option<Function1<String, F>> logger, Network<F> F) {
                return this.mkDtlsSocket(socket, remoteAddress, false, params, logger, F);
            }

            private <F> Resource<F, DTLSSocket<F>> mkDtlsSocket(fs2.io.udp.Socket<F> socket, InetSocketAddress remoteAddress, boolean clientMode, TLSParameters params, Option<Function1<String, F>> logger, Network<F> F) {
                return Resource$.MODULE$.liftF(this.engine(new TLSEngine.Binding<F>(null, F, socket, remoteAddress){
                    private final Network F$2;
                    private final fs2.io.udp.Socket socket$2;
                    private final InetSocketAddress remoteAddress$1;

                    public F write(Chunk<Object> data, Option<FiniteDuration> timeout) {
                        return (F)(data.isEmpty() ? Applicative$.MODULE$.apply(this.F$2.async()).unit() : this.socket$2.write(new Packet(this.remoteAddress$1, data), timeout));
                    }

                    public F read(int maxBytes, Option<FiniteDuration> timeout) {
                        return (F)package.all$.MODULE$.toFunctorOps(this.socket$2.read(timeout), this.F$2.async()).map((Function1 & Serializable & scala.Serializable)p -> new Some(p.bytes()));
                    }
                    {
                        this.F$2 = F$2;
                        this.socket$2 = socket$2;
                        this.remoteAddress$1 = remoteAddress$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1(fs2.io.udp.Packet )}, serializedLambda);
                    }
                }, clientMode, params, logger, F)).flatMap((Function1 & Serializable & scala.Serializable)engine -> DTLSSocket$.MODULE$.apply(socket, remoteAddress, engine, F.async()));
            }

            private <F> F engine(TLSEngine.Binding<F> binding, boolean clientMode, TLSParameters params, Option<Function1<String, F>> logger, Network<F> F) {
                Object sslEngine = F.async().blocking((Function0 & Serializable & scala.Serializable)() -> {
                    void var3_3;
                    SSLEngine engine = $this.ctx$1.createSSLEngine();
                    engine.setUseClientMode(clientMode);
                    engine.setSSLParameters(params.toSSLParameters());
                    params.handshakeApplicationProtocolSelector().foreach((Function1 & Serializable & scala.Serializable)f -> {
                        anon.1.$anonfun$engine$2(engine, f);
                        return BoxedUnit.UNIT;
                    });
                    return var3_3;
                });
                return (F)package.all$.MODULE$.toFlatMapOps(sslEngine, F.async()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> TLSEngine$.MODULE$.apply((SSLEngine)x$1, binding, logger, F.async()));
            }

            public static final /* synthetic */ void $anonfun$engine$2(SSLEngine engine$1, Function2 f) {
                engine$1.setHandshakeApplicationProtocolSelector(new BiFunction<SSLEngine, List<String>, String>(null, f){
                    private final Function2 f$1;

                    public <V> BiFunction<SSLEngine, List<String>, V> andThen(Function<? super String, ? extends V> x$1) {
                        return BiFunction.super.andThen(x$1);
                    }

                    public String apply(SSLEngine engine, List<String> protocols) {
                        return (String)this.f$1.apply((Object)engine, (Object)CollectionCompat$JIterableOps$.MODULE$.asScala$extension(CollectionCompat$.MODULE$.JIterableOps(protocols)).toList());
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
            }
            {
                this.ctx$1 = ctx$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$mkSocket$1(fs2.io.tcp.Socket fs2.io.Network fs2.io.tls.TLSEngine ), $anonfun$mkDtlsSocket$1(fs2.io.udp.Socket java.net.InetSocketAddress fs2.io.Network fs2.io.tls.TLSEngine ), $anonfun$engine$1(fs2.io.tls.TLSContext$$anon$1 boolean fs2.io.tls.TLSParameters ), $anonfun$engine$3(fs2.io.tls.TLSEngine$Binding scala.Option fs2.io.Network javax.net.ssl.SSLEngine ), $anonfun$engine$2$adapted(javax.net.ssl.SSLEngine scala.Function2 )}, serializedLambda);
            }
        };
    }

    public <F> F insecure(Network<F> F) {
        return (F)package.all$.MODULE$.toFunctorOps(F.async().blocking((Function0 & Serializable & scala.Serializable)() -> {
            void var0;
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] x, String y) {
                }

                public void checkServerTrusted(X509Certificate[] x, String y) {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return (X509Certificate[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(X509Certificate.class));
                }
            };
            ctx.init(null, (TrustManager[])((Object[])new TrustManager[]{tm}), null);
            return var0;
        }), F.async()).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.fromSSLContext((SSLContext)x$2));
    }

    public <F> F system(Network<F> F) {
        return (F)package.all$.MODULE$.toFunctorOps(F.async().blocking((Function0 & Serializable & scala.Serializable)() -> SSLContext.getDefault()), F.async()).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.fromSSLContext((SSLContext)x$3));
    }

    public <F> F fromKeyStoreFile(Path file, char[] storePassword, char[] keyPassword, Network<F> F) {
        Object load = F.async().blocking((Function0 & Serializable & scala.Serializable)() -> new FileInputStream(file.toFile()));
        Resource stream = Resource$.MODULE$.make(load, (Function1 & Serializable & scala.Serializable)s -> F.async().blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> s.close()), F.async());
        return this.fromKeyStoreStream(stream, storePassword, keyPassword, F);
    }

    public <F> F fromKeyStoreResource(String resource, char[] storePassword, char[] keyPassword, Network<F> F) {
        Object load = F.async().blocking((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader().getResourceAsStream(resource));
        Resource stream = Resource$.MODULE$.make(load, (Function1 & Serializable & scala.Serializable)s -> F.async().blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> s.close()), F.async());
        return this.fromKeyStoreStream(stream, storePassword, keyPassword, F);
    }

    private <F> F fromKeyStoreStream(Resource<F, InputStream> stream, char[] storePassword, char[] keyPassword, Network<F> F) {
        return (F)stream.use((Function1 & Serializable & scala.Serializable)s -> package.all$.MODULE$.toFlatMapOps(F.async().blocking((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load((InputStream)s, storePassword);
            return var2_2;
        }), F.async()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.fromKeyStore((KeyStore)x$4, keyPassword, F)), F.async());
    }

    public <F> F fromKeyStore(KeyStore keyStore, char[] keyPassword, Network<F> F) {
        return (F)package.all$.MODULE$.toFunctorOps(F.async().blocking((Function0 & Serializable & scala.Serializable)() -> {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyPassword);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sslContext;
        }), F.async()).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.fromSSLContext((SSLContext)x$5));
    }

    private TLSContext$() {
        MODULE$ = this;
    }
}

