/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.net;

import cats.effect.kernel.Async;
import cats.effect.std.Semaphore;
import cats.syntax.FlattenOps$;
import cats.syntax.package;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JFunction0;
import scala.runtime.function.JFunction1;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.NotGiven$;

public interface Socket<F> {
    public F read(int var1);

    public F readN(int var1);

    public Stream<F, Object> reads();

    public F endOfInput();

    public F endOfOutput();

    public F isOpen();

    public F remoteAddress();

    public F localAddress();

    public F write(Chunk<Object> var1);

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> writes();

    private static final class AsyncSocket<F>
    implements Socket<F> {
        private final AsynchronousSocketChannel ch;
        private final Semaphore<F> readSemaphore;
        private final Semaphore<F> writeSemaphore;
        private final Async<F> F;
        private ByteBuffer readBuffer;

        public <F> AsyncSocket(AsynchronousSocketChannel ch, Semaphore<F> readSemaphore, Semaphore<F> writeSemaphore, Async<F> F) {
            this.ch = ch;
            this.readSemaphore = readSemaphore;
            this.writeSemaphore = writeSemaphore;
            this.F = F;
            int defaultReadSize = 8192;
            this.readBuffer = ByteBuffer.allocateDirect(8192);
        }

        private <A> F withReadBuffer(int size, Function1<ByteBuffer, F> f) {
            return (F)this.readSemaphore.permit().use((Function1)(JFunction1 & Serializable)_$5 -> {
                Object object = package.all$.MODULE$.catsSyntaxFlatten(this.F.delay(() -> this.withReadBuffer$$anonfun$2$$anonfun$1(size, f)), this.F);
                return FlattenOps$.MODULE$.flatten$extension(object, this.F);
            }, this.F);
        }

        private F readChunk(ByteBuffer buffer) {
            return (F)this.F.async_((Function1)(JProcedure1 & Serializable)cb -> this.ch.read(buffer, null, new IntCallbackHandler((Function1<Either<Throwable, Object>, BoxedUnit>)cb)));
        }

        private F releaseBuffer(ByteBuffer buffer) {
            return (F)this.F.delay(() -> this.releaseBuffer$$anonfun$1(buffer));
        }

        @Override
        public F read(int max) {
            return this.withReadBuffer(max, (Function1<ByteBuffer, F>)(JFunction1 & Serializable)buffer -> package.all$.MODULE$.toFlatMapOps(this.readChunk((ByteBuffer)buffer), this.F).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> this.read$$anonfun$4$$anonfun$adapted$1(buffer, arg_0))));
        }

        @Override
        public F readN(int max) {
            return this.withReadBuffer(max, (Function1<ByteBuffer, F>)(JFunction1 & Serializable)buffer -> this.go$2(max, (ByteBuffer)buffer));
        }

        @Override
        public Stream<F, Object> reads() {
            Stream stream = Stream$.MODULE$.OptionStreamOps(Stream$.MODULE$.repeatEval(this.read(8192)));
            return Stream.OptionStreamOps$.MODULE$.unNoneTerminate$extension(stream).flatMap((Function1)(JFunction1 & Serializable)os -> Stream$.MODULE$.chunk(os), NotGiven$.MODULE$.value());
        }

        @Override
        public F write(Chunk<Object> bytes) {
            return (F)this.writeSemaphore.permit().use((Function1)(JFunction1 & Serializable)_$7 -> this.go$6(bytes.toByteBuffer($less$colon$less$.MODULE$.refl())), this.F);
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, Nothing$>> writes() {
            return (JFunction1 & Serializable)_$8 -> _$8.chunks().foreach((Function1)(JFunction1 & Serializable)bytes -> this.write((Chunk<Object>)bytes));
        }

        @Override
        public F localAddress() {
            return (F)this.F.delay(this::localAddress$$anonfun$1);
        }

        @Override
        public F remoteAddress() {
            return (F)this.F.delay(this::remoteAddress$$anonfun$1);
        }

        @Override
        public F isOpen() {
            return (F)this.F.delay((Function0)((JFunction0.mcZ.sp & Serializable)this::isOpen$$anonfun$1));
        }

        @Override
        public F endOfOutput() {
            return (F)this.F.delay((Function0)((JFunction0.mcV.sp & Serializable)this::endOfOutput$$anonfun$1));
        }

        @Override
        public F endOfInput() {
            return (F)this.F.delay((Function0)((JFunction0.mcV.sp & Serializable)this::endOfInput$$anonfun$1));
        }

        private final Object withReadBuffer$$anonfun$2$$anonfun$1(int size$2, Function1 f$2) {
            Buffer buffer;
            if (this.readBuffer.capacity() < size$2) {
                this.readBuffer = ByteBuffer.allocateDirect(size$2);
                buffer = BoxedUnit.UNIT;
            } else {
                buffer = ((Buffer)this.readBuffer).limit(size$2);
            }
            return f$2.apply((Object)this.readBuffer);
        }

        /*
         * WARNING - void declaration
         */
        private final Chunk releaseBuffer$$anonfun$1(ByteBuffer buffer$2) {
            void var3_4;
            Chunk chunk;
            int read = buffer$2.position();
            if (read == 0) {
                chunk = Chunk$.MODULE$.empty();
            } else {
                ByteBuffer dest = ByteBuffer.allocateDirect(read);
                ((Buffer)buffer$2).flip();
                dest.put(buffer$2);
                ((Buffer)dest).flip();
                chunk = Chunk$.MODULE$.byteBuffer(dest);
            }
            Chunk result = chunk;
            ((Buffer)buffer$2).clear();
            return var3_4;
        }

        private final /* synthetic */ Object read$$anonfun$3$$anonfun$2(ByteBuffer buffer$3, int read) {
            return read < 0 ? this.F.pure((Object)None$.MODULE$) : package.all$.MODULE$.toFunctorOps(this.releaseBuffer(buffer$3), this.F).map((Function1)(JFunction1 & Serializable)_$6 -> Some$.MODULE$.apply(_$6));
        }

        private final Object read$$anonfun$4$$anonfun$adapted$1(ByteBuffer buffer$6, Object read) {
            return this.read$$anonfun$3$$anonfun$2(buffer$6, BoxesRunTime.unboxToInt((Object)read));
        }

        private final /* synthetic */ Object go$1$$anonfun$1(int max$2, ByteBuffer buffer$5, int readBytes) {
            return readBytes < 0 || buffer$5.position() >= max$2 ? this.releaseBuffer(buffer$5) : this.go$2(max$2, buffer$5);
        }

        private final Object go$3$$anonfun$adapted$1(int max$4, ByteBuffer buffer$7, Object readBytes) {
            return this.go$1$$anonfun$1(max$4, buffer$7, BoxesRunTime.unboxToInt((Object)readBytes));
        }

        private final Object go$2(int max$1, ByteBuffer buffer$4) {
            return package.all$.MODULE$.toFlatMapOps(this.readChunk(buffer$4), this.F).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> this.go$3$$anonfun$adapted$1(max$1, buffer$4, arg_0)));
        }

        private final /* synthetic */ Object go$5$$anonfun$2(ByteBuffer buff$2, int written) {
            return written >= 0 && buff$2.remaining() > 0 ? this.go$6(buff$2) : this.F.unit();
        }

        private final Object go$7$$anonfun$adapted$1(ByteBuffer buff$3, Object written) {
            return this.go$5$$anonfun$2(buff$3, BoxesRunTime.unboxToInt((Object)written));
        }

        private final Object go$6(ByteBuffer buff) {
            return package.all$.MODULE$.toFlatMapOps(this.F.async_((Function1)(JProcedure1 & Serializable)cb -> this.ch.write(buff, null, new IntCallbackHandler((Function1<Either<Throwable, Object>, BoxedUnit>)cb))), this.F).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> this.go$7$$anonfun$adapted$1(buff, arg_0)));
        }

        private final SocketAddress localAddress$$anonfun$1() {
            return SocketAddress$.MODULE$.fromInetSocketAddress((InetSocketAddress)this.ch.getLocalAddress());
        }

        private final SocketAddress remoteAddress$$anonfun$1() {
            return SocketAddress$.MODULE$.fromInetSocketAddress((InetSocketAddress)this.ch.getRemoteAddress());
        }

        private final boolean isOpen$$anonfun$1() {
            return this.ch.isOpen();
        }

        private final void endOfOutput$$anonfun$1() {
            this.ch.shutdownOutput();
        }

        private final void endOfInput$$anonfun$1() {
            this.ch.shutdownInput();
        }
    }

    private static final class IntCallbackHandler<A>
    implements CompletionHandler<Integer, Object> {
        private final Function1<Either<Throwable, Object>, BoxedUnit> cb;

        public <A> IntCallbackHandler(Function1<Either<Throwable, Object>, BoxedUnit> cb) {
            this.cb = cb;
        }

        @Override
        public void completed(Integer result, Object attachment) {
            this.cb.apply((Object)package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(result))));
        }

        @Override
        public void failed(Throwable err, Object attachment) {
            this.cb.apply((Object)package$.MODULE$.Left().apply((Object)err));
        }
    }
}

