/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.net;

import cats.UnorderedFoldable$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Async$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import com.comcast.ip4s.Dns$;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.net.Socket;
import fs2.io.net.Socket$;
import fs2.io.net.SocketOption;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.spi.AsynchronousChannelProvider;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JFunction0;
import scala.runtime.function.JFunction1;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;

public interface SocketGroup<F> {
    public Resource<F, Socket<F>> client(SocketAddress<Host> var1, List<SocketOption> var2);

    public static List client$default$2$(SocketGroup $this) {
        return $this.client$default$2();
    }

    default public List<SocketOption> client$default$2() {
        return package$.MODULE$.List().empty();
    }

    public Stream<F, Socket<F>> server(Option<Host> var1, Option<Port> var2, List<SocketOption> var3);

    public static None$ server$default$1$(SocketGroup $this) {
        return $this.server$default$1();
    }

    default public None$ server$default$1() {
        return None$.MODULE$;
    }

    public static None$ server$default$2$(SocketGroup $this) {
        return $this.server$default$2();
    }

    default public None$ server$default$2() {
        return None$.MODULE$;
    }

    public static List server$default$3$(SocketGroup $this) {
        return $this.server$default$3();
    }

    default public List<SocketOption> server$default$3() {
        return package$.MODULE$.List().empty();
    }

    public Resource<F, Tuple2<SocketAddress<IpAddress>, Stream<F, Socket<F>>>> serverResource(Option<Host> var1, Option<Port> var2, List<SocketOption> var3);

    public static None$ serverResource$default$1$(SocketGroup $this) {
        return $this.serverResource$default$1();
    }

    default public None$ serverResource$default$1() {
        return None$.MODULE$;
    }

    public static None$ serverResource$default$2$(SocketGroup $this) {
        return $this.serverResource$default$2();
    }

    default public None$ serverResource$default$2() {
        return None$.MODULE$;
    }

    public static List serverResource$default$3$(SocketGroup $this) {
        return $this.serverResource$default$3();
    }

    default public List<SocketOption> serverResource$default$3() {
        return package$.MODULE$.List().empty();
    }

    private static final class AsyncSocketGroup<F>
    implements SocketGroup<F> {
        private final AsynchronousChannelGroup channelGroup;
        private final Async<F> evidence$2;

        public <F> AsyncSocketGroup(AsynchronousChannelGroup channelGroup, Async<F> evidence$2) {
            this.channelGroup = channelGroup;
            this.evidence$2 = evidence$2;
        }

        @Override
        public Resource<F, Socket<F>> client(SocketAddress<Host> to, List<SocketOption> options) {
            return Resource$.MODULE$.eval(package.all$.MODULE$.toFlatMapOps(this.setup$1(options), this.evidence$2).flatMap((Function1)(JFunction1 & Serializable)ch -> this.connect$3((SocketAddress)to, (AsynchronousSocketChannel)ch))).flatMap((Function1)(JFunction1 & Serializable)_$4 -> Socket$.MODULE$.forAsync((AsynchronousSocketChannel)_$4, this.evidence$2));
        }

        @Override
        public Stream<F, Socket<F>> server(Option<Host> address, Option<Port> port, List<SocketOption> options) {
            return Stream$.MODULE$.resource(this.serverResource(address, port, options), this.evidence$2).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Stream clients = (Stream)tuple2._2();
                return clients;
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Resource<F, Tuple2<SocketAddress<IpAddress>, Stream<F, Socket<F>>>> serverResource(Option<Host> address, Option<Port> port, List<SocketOption> options) {
            Object setup = package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toTraverseOps(address, UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse((Function1)(JFunction1 & Serializable)_$5 -> _$5.resolve(Dns$.MODULE$.forSync(this.evidence$2), this.evidence$2), this.evidence$2), this.evidence$2).flatMap((Function1)(JFunction1 & Serializable)addr -> Async$.MODULE$.apply(this.evidence$2).delay(() -> this.$anonfun$7$$anonfun$5(port, options, addr)));
            return Resource$.MODULE$.make(setup, (Function1)(JFunction1 & Serializable)sch -> this.cleanup$2((AsynchronousServerSocketChannel)sch), this.evidence$2).map((Function1)(JFunction1 & Serializable)sch -> {
                InetSocketAddress jLocalAddress = (InetSocketAddress)sch.getLocalAddress();
                SocketAddress localAddress = SocketAddress$.MODULE$.fromInetSocketAddress(jLocalAddress);
                return Tuple2$.MODULE$.apply((Object)localAddress, (Object)this.acceptIncoming$5((AsynchronousServerSocketChannel)sch));
            });
        }

        /*
         * WARNING - void declaration
         */
        private final AsynchronousSocketChannel setup$3$$anonfun$2(List options$2) {
            void var2_2;
            AsynchronousSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousSocketChannel(this.channelGroup);
            options$2.foreach((Function1)(JFunction1 & Serializable)opt -> ch.setOption((java.net.SocketOption)opt.key(), opt.value()));
            return var2_2;
        }

        private final Object setup$1(List options$1) {
            return Async$.MODULE$.apply(this.evidence$2).delay(() -> this.setup$3$$anonfun$2(options$1));
        }

        private final Object connect$3(SocketAddress to$1, AsynchronousSocketChannel ch) {
            return package.all$.MODULE$.toFlatMapOps(SocketAddress$.MODULE$.ResolveOps(to$1).resolve(Dns$.MODULE$.forSync(this.evidence$2), this.evidence$2), this.evidence$2).flatMap((Function1)(JFunction1 & Serializable)ip -> Async$.MODULE$.apply(this.evidence$2).async_((Function1)(JProcedure1 & Serializable)cb -> ch.connect(ip.toInetSocketAddress((.less.colon.less)$less$colon$less$.MODULE$.refl()), null, new CompletionHandler(ch, (Function1)cb){
                private final AsynchronousSocketChannel ch$1;
                private final Function1 cb$1;
                {
                    this.ch$1 = ch$6;
                    this.cb$1 = cb$3;
                }

                public void completed(Void result, Void attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)this.ch$1));
                }

                public void failed(Throwable rsn, Void attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)rsn));
                }
            })));
        }

        private final int $anonfun$6$$anonfun$4$$anonfun$4() {
            return 0;
        }

        private final AsynchronousServerSocketChannel $anonfun$7$$anonfun$5(Option port$2, List options$4, Option addr$1) {
            AsynchronousServerSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousServerSocketChannel(this.channelGroup);
            options$4.foreach((Function1)(JFunction1 & Serializable)opt -> ch.setOption((java.net.SocketOption)opt.key(), opt.value()));
            ch.bind(new InetSocketAddress((InetAddress)addr$1.map((Function1)(JFunction1 & Serializable)_$6 -> _$6.toInetAddress()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), BoxesRunTime.unboxToInt((Object)port$2.map((Function1)(JFunction1 & Serializable)_$7 -> _$7.value()).getOrElse((Function0)((JFunction0.mcI.sp & Serializable)this::$anonfun$6$$anonfun$4$$anonfun$4)))));
            return ch;
        }

        private final void cleanup$1$$anonfun$1(AsynchronousServerSocketChannel sch$1) {
            if (sch$1.isOpen()) {
                sch$1.close();
            }
        }

        private final Object cleanup$2(AsynchronousServerSocketChannel sch) {
            return Async$.MODULE$.apply(this.evidence$2).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.cleanup$1$$anonfun$1(sch)));
        }

        private final Object acceptChannel$2(AsynchronousServerSocketChannel sch$3) {
            return Async$.MODULE$.apply(this.evidence$2).async_((Function1)(JProcedure1 & Serializable)cb -> sch$3.accept(null, new CompletionHandler((Function1)cb){
                private final Function1 cb$1;
                {
                    this.cb$1 = cb$4;
                }

                public void completed(AsynchronousSocketChannel ch, Void attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)ch));
                }

                public void failed(Throwable rsn, Void attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)rsn));
                }
            }));
        }

        private final Stream go$2$$anonfun$2(AsynchronousServerSocketChannel sch$7) {
            return this.go$3(sch$7);
        }

        private final Stream go$3(AsynchronousServerSocketChannel sch$2) {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.acceptChannel$2(sch$2), this.evidence$2);
            return Stream$.MODULE$.eval(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.evidence$2)).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
                Stream stream;
                Either either = x$1;
                if (either instanceof Left) {
                    Stream stream2 = Stream$.MODULE$.PureOps(Stream$.MODULE$.empty());
                    stream = Stream.PureOps$.MODULE$.apply$extension(stream2);
                } else if (either instanceof Right) {
                    AsynchronousSocketChannel accepted = (AsynchronousSocketChannel)((Right)either).value();
                    stream = Stream$.MODULE$.resource(Socket$.MODULE$.forAsync(accepted, this.evidence$2), this.evidence$2);
                } else {
                    throw new MatchError((Object)either);
                }
                return stream;
            }, NotGiven$.MODULE$.value()).$plus$plus(() -> this.go$2$$anonfun$2(sch$2));
        }

        private final boolean acceptIncoming$1$$anonfun$1$$anonfun$1(AsynchronousServerSocketChannel sch$6) {
            return sch$6.isOpen();
        }

        private final /* synthetic */ Stream acceptIncoming$2$$anonfun$2$$anonfun$2(AsynchronousCloseException err$1, boolean isOpen) {
            return isOpen ? Stream$.MODULE$.raiseError((Throwable)err$1, RaiseThrowable$.MODULE$.fromApplicativeError(this.evidence$2)) : Stream$.MODULE$.empty();
        }

        private final Stream acceptIncoming$3$$anonfun$3$$anonfun$adapted$1(AsynchronousCloseException err$2, Object isOpen) {
            return this.acceptIncoming$2$$anonfun$2$$anonfun$2(err$2, BoxesRunTime.unboxToBoolean((Object)isOpen));
        }

        private final Stream acceptIncoming$5(AsynchronousServerSocketChannel sch) {
            return this.go$3(sch).handleErrorWith((Function1)(JFunction1 & Serializable)x$1 -> {
                Stream stream;
                Throwable throwable = x$1;
                if (throwable instanceof AsynchronousCloseException) {
                    AsynchronousCloseException err = (AsynchronousCloseException)throwable;
                    stream = Stream$.MODULE$.eval(Async$.MODULE$.apply(this.evidence$2).delay((Function0)((JFunction0.mcZ.sp & Serializable)() -> this.acceptIncoming$1$$anonfun$1$$anonfun$1(sch)))).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> this.acceptIncoming$3$$anonfun$3$$anonfun$adapted$1(err, arg_0)), NotGiven$.MODULE$.value());
                } else {
                    Throwable err = throwable;
                    stream = Stream$.MODULE$.raiseError(err, RaiseThrowable$.MODULE$.fromApplicativeError(this.evidence$2));
                }
                return stream;
            });
        }
    }
}

