/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.CollectionCompat$;
import fs2.io.CollectionCompat$JIterableOps$;
import fs2.io.CollectionCompat$JIteratorOps$;
import fs2.io.CollectionCompat$JSetOps$;
import fs2.io.CollectionCompat$SetOps$;
import fs2.io.Watcher;
import fs2.io.Watcher$;
import fs2.io.file.FileHandle;
import fs2.io.file.FileHandle$;
import fs2.io.file.ReadCursor;
import fs2.io.file.ReadCursor$;
import fs2.io.file.WriteCursor;
import fs2.io.file.WriteCursor$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;

public interface Files<F> {
    public F copy(Path var1, Path var2, Seq<CopyOption> var3);

    public static Seq copy$default$3$(Files $this) {
        return $this.copy$default$3();
    }

    default public Seq<CopyOption> copy$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public F createDirectory(Path var1, Seq<FileAttribute<?>> var2);

    public static Seq createDirectory$default$2$(Files $this) {
        return $this.createDirectory$default$2();
    }

    default public Seq<FileAttribute<?>> createDirectory$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public F createDirectories(Path var1, Seq<FileAttribute<?>> var2);

    public static Seq createDirectories$default$2$(Files $this) {
        return $this.createDirectories$default$2();
    }

    default public Seq<FileAttribute<?>> createDirectories$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public F delete(Path var1);

    public F deleteIfExists(Path var1);

    public F deleteDirectoryRecursively(Path var1, scala.collection.immutable.Set<FileVisitOption> var2);

    public static scala.collection.immutable.Set deleteDirectoryRecursively$default$2$(Files $this) {
        return $this.deleteDirectoryRecursively$default$2();
    }

    default public scala.collection.immutable.Set<FileVisitOption> deleteDirectoryRecursively$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public Stream<F, Path> directoryStream(Path var1);

    public Stream<F, Path> directoryStream(Path var1, Function1<Path, Object> var2);

    public Stream<F, Path> directoryStream(Path var1, String var2);

    public F exists(Path var1, Seq<LinkOption> var2);

    public static Seq exists$default$2$(Files $this) {
        return $this.exists$default$2();
    }

    default public Seq<LinkOption> exists$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public F isDirectory(Path var1, Seq<LinkOption> var2);

    public static Seq isDirectory$default$2$(Files $this) {
        return $this.isDirectory$default$2();
    }

    default public Seq<LinkOption> isDirectory$default$2() {
        return package$.MODULE$.Nil();
    }

    public F isFile(Path var1, Seq<LinkOption> var2);

    public static Seq isFile$default$2$(Files $this) {
        return $this.isFile$default$2();
    }

    default public Seq<LinkOption> isFile$default$2() {
        return package$.MODULE$.Nil();
    }

    public F move(Path var1, Path var2, Seq<CopyOption> var3);

    public static Seq move$default$3$(Files $this) {
        return $this.move$default$3();
    }

    default public Seq<CopyOption> move$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Resource<F, FileHandle<F>> open(Path var1, Seq<OpenOption> var2);

    public Resource<F, FileHandle<F>> openFileChannel(F var1);

    public F permissions(Path var1, Seq<LinkOption> var2);

    public static Seq permissions$default$2$(Files $this) {
        return $this.permissions$default$2();
    }

    default public Seq<LinkOption> permissions$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Stream<F, Object> readAll(Path var1, int var2);

    public Resource<F, ReadCursor<F>> readCursor(Path var1, Seq<OpenOption> var2);

    public static Seq readCursor$default$2$(Files $this) {
        return $this.readCursor$default$2();
    }

    default public Seq<OpenOption> readCursor$default$2() {
        return package$.MODULE$.Nil();
    }

    public Stream<F, Object> readRange(Path var1, int var2, long var3, long var5);

    public F setPermissions(Path var1, scala.collection.immutable.Set<PosixFilePermission> var2);

    public F size(Path var1);

    public Stream<F, Object> tail(Path var1, int var2, long var3, FiniteDuration var5);

    public static long tail$default$3$(Files $this) {
        return $this.tail$default$3();
    }

    default public long tail$default$3() {
        return 0L;
    }

    public static FiniteDuration tail$default$4$(Files $this) {
        return $this.tail$default$4();
    }

    default public FiniteDuration tail$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public Resource<F, Path> tempFile(Option<Path> var1, String var2, String var3, Seq<FileAttribute<?>> var4);

    public static Option tempFile$default$1$(Files $this) {
        return $this.tempFile$default$1();
    }

    default public Option<Path> tempFile$default$1() {
        return None$.MODULE$;
    }

    public static String tempFile$default$2$(Files $this) {
        return $this.tempFile$default$2();
    }

    default public String tempFile$default$2() {
        return "";
    }

    public static String tempFile$default$3$(Files $this) {
        return $this.tempFile$default$3();
    }

    default public String tempFile$default$3() {
        return ".tmp";
    }

    public static Seq tempFile$default$4$(Files $this) {
        return $this.tempFile$default$4();
    }

    default public Seq<FileAttribute<?>> tempFile$default$4() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Resource<F, Path> tempDirectory(Option<Path> var1, String var2, Seq<FileAttribute<?>> var3);

    public static Option tempDirectory$default$1$(Files $this) {
        return $this.tempDirectory$default$1();
    }

    default public Option<Path> tempDirectory$default$1() {
        return None$.MODULE$;
    }

    public static String tempDirectory$default$2$(Files $this) {
        return $this.tempDirectory$default$2();
    }

    default public String tempDirectory$default$2() {
        return "";
    }

    public static Seq tempDirectory$default$3$(Files $this) {
        return $this.tempDirectory$default$3();
    }

    default public Seq<FileAttribute<?>> tempDirectory$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Stream<F, Path> walk(Path var1);

    public Stream<F, Path> walk(Path var1, Seq<FileVisitOption> var2);

    public Stream<F, Path> walk(Path var1, int var2, Seq<FileVisitOption> var3);

    public static Seq walk$default$3$(Files $this) {
        return $this.walk$default$3();
    }

    default public Seq<FileVisitOption> walk$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Resource<F, Watcher<F>> watcher();

    public Stream<F, Watcher.Event> watch(Path var1, Seq<Watcher.EventType> var2, Seq<WatchEvent.Modifier> var3, FiniteDuration var4);

    public static Seq watch$default$2$(Files $this) {
        return $this.watch$default$2();
    }

    default public Seq<Watcher.EventType> watch$default$2() {
        return package$.MODULE$.Nil();
    }

    public static Seq watch$default$3$(Files $this) {
        return $this.watch$default$3();
    }

    default public Seq<WatchEvent.Modifier> watch$default$3() {
        return package$.MODULE$.Nil();
    }

    public static FiniteDuration watch$default$4$(Files $this) {
        return $this.watch$default$4();
    }

    default public FiniteDuration watch$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeAll(Path var1, Seq<StandardOpenOption> var2);

    public static Seq writeAll$default$2$(Files $this) {
        return $this.writeAll$default$2();
    }

    default public Seq<StandardOpenOption> writeAll$default$2() {
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    public Resource<F, WriteCursor<F>> writeCursor(Path var1, Seq<OpenOption> var2);

    public static Seq writeCursor$default$2$(Files $this) {
        return $this.writeCursor$default$2();
    }

    default public Seq<OpenOption> writeCursor$default$2() {
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    public F writeCursorFromFileHandle(FileHandle<F> var1, boolean var2);

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeRotate(F var1, long var2, Seq<StandardOpenOption> var4);

    public static Seq writeRotate$default$3$(Files $this) {
        return $this.writeRotate$default$3();
    }

    default public Seq<StandardOpenOption> writeRotate$default$3() {
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    private static final class AsyncFiles<F>
    implements Files<F> {
        private final Async<F> evidence$2;

        public <F> AsyncFiles(Async<F> evidence$2) {
            this.evidence$2 = evidence$2;
            int n = 16;
        }

        @Override
        public F copy(Path source, Path target, Seq<CopyOption> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.copy$$anonfun$1(source, target, flags));
        }

        @Override
        public F createDirectory(Path path, Seq<FileAttribute<?>> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.createDirectory$$anonfun$1(path, flags));
        }

        @Override
        public F createDirectories(Path path, Seq<FileAttribute<?>> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.createDirectories$$anonfun$1(path, flags));
        }

        @Override
        public F delete(Path path) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.delete$$anonfun$1(path)));
        }

        @Override
        public F deleteIfExists(Path path) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.deleteIfExists$$anonfun$1(path));
        }

        @Override
        public F deleteDirectoryRecursively(Path path, scala.collection.immutable.Set<FileVisitOption> options) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.deleteDirectoryRecursively$$anonfun$1(path, options)));
        }

        @Override
        public Stream<F, Path> directoryStream(Path path) {
            return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.directoryStream$$anonfun$1(path)), (Function1 & Serializable)_$5 -> {
                Iterable iterable = CollectionCompat$.MODULE$.JIterableOps(_$5);
                return CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).iterator();
            });
        }

        @Override
        public Stream<F, Path> directoryStream(Path path, Function1<Path, Object> filter) {
            return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.directoryStream$$anonfun$3(path, filter)), (Function1 & Serializable)_$6 -> {
                Iterable iterable = CollectionCompat$.MODULE$.JIterableOps(_$6);
                return CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).iterator();
            });
        }

        @Override
        public Stream<F, Path> directoryStream(Path path, String glob) {
            return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.directoryStream$$anonfun$5(path, glob)), (Function1 & Serializable)_$7 -> {
                Iterable iterable = CollectionCompat$.MODULE$.JIterableOps(_$7);
                return CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).iterator();
            });
        }

        private <C extends AutoCloseable> Stream<F, Path> _runJavaCollectionResource(F javaCollection, Function1<C, Iterator<Path>> collectionIterator) {
            return Stream$.MODULE$.resource(Resource$.MODULE$.fromAutoCloseable(javaCollection, this.evidence$2), this.evidence$2).flatMap((Function1 & Serializable)ds -> {
                boolean bl = Stream$.MODULE$.fromBlockingIterator();
                return Stream.PartiallyAppliedFromIterator$.MODULE$.apply$extension(bl, (Iterator)collectionIterator.apply(ds), 16, this.evidence$2);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public F exists(Path path, Seq<LinkOption> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.exists$$anonfun$1(path, flags));
        }

        @Override
        public F isDirectory(Path path, Seq<LinkOption> linkOption) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).delay(() -> this.isDirectory$$anonfun$1(path, linkOption));
        }

        @Override
        public F isFile(Path path, Seq<LinkOption> linkOption) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).delay(() -> this.isFile$$anonfun$1(path, linkOption));
        }

        @Override
        public F move(Path source, Path target, Seq<CopyOption> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.move$$anonfun$1(source, target, flags));
        }

        @Override
        public Resource<F, FileHandle<F>> open(Path path, Seq<OpenOption> flags) {
            return this.openFileChannel(Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.open$$anonfun$1(path, flags)));
        }

        @Override
        public Resource<F, FileHandle<F>> openFileChannel(F channel) {
            return Resource$.MODULE$.make(channel, (Function1 & Serializable)ch -> Sync$.MODULE$.apply(this.evidence$2).blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.openFileChannel$$anonfun$3$$anonfun$1(ch))), this.evidence$2).map((Function1 & Serializable)ch -> FileHandle$.MODULE$.make((FileChannel)ch, this.evidence$2));
        }

        @Override
        public F permissions(Path path, Seq<LinkOption> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.permissions$$anonfun$1(path, flags));
        }

        @Override
        public Stream<F, Object> readAll(Path path, int chunkSize) {
            return Stream$.MODULE$.resource(this.readCursor(path, this.readCursor$default$2()), this.evidence$2).flatMap((Function1 & Serializable)cursor -> {
                Pull pull = Pull$.MODULE$.StreamPullOps(cursor.readAll(chunkSize).void());
                return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Resource<F, ReadCursor<F>> readCursor(Path path, Seq<OpenOption> flags) {
            StandardOpenOption standardOpenOption = StandardOpenOption.READ;
            return this.open(path, (Seq<OpenOption>)flags.toList().$colon$colon((Object)standardOpenOption)).map((Function1 & Serializable)fileHandle -> ReadCursor$.MODULE$.apply(fileHandle, 0L));
        }

        @Override
        public Seq<OpenOption> readCursor$default$2() {
            return package$.MODULE$.Nil();
        }

        @Override
        public Stream<F, Object> readRange(Path path, int chunkSize, long start, long end) {
            return Stream$.MODULE$.resource(this.readCursor(path, this.readCursor$default$2()), this.evidence$2).flatMap((Function1 & Serializable)cursor -> {
                Pull pull = Pull$.MODULE$.StreamPullOps(cursor.seek(start).readUntil(chunkSize, end).void());
                return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public F setPermissions(Path path, scala.collection.immutable.Set<PosixFilePermission> permissions) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.setPermissions$$anonfun$1(path, permissions));
        }

        @Override
        public F size(Path path) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.size$$anonfun$1(path));
        }

        @Override
        public Stream<F, Object> tail(Path path, int chunkSize, long offset, FiniteDuration pollDelay) {
            return Stream$.MODULE$.resource(this.readCursor(path, this.readCursor$default$2()), this.evidence$2).flatMap((Function1 & Serializable)cursor -> {
                Pull pull = Pull$.MODULE$.StreamPullOps(cursor.seek(offset).tail(chunkSize, pollDelay, this.evidence$2).void());
                return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Resource<F, Path> tempFile(Option<Path> dir, String prefix, String suffix, Seq<FileAttribute<?>> attributes) {
            Object object;
            Option<Path> option = dir;
            if (option instanceof Some) {
                Path dir2 = (Path)((Some)option).value();
                object = Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.tempFile$$anonfun$1(prefix, suffix, attributes, dir2));
            } else if (None$.MODULE$.equals(option)) {
                object = Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.tempFile$$anonfun$2(prefix, suffix, attributes));
            } else {
                throw new MatchError(option);
            }
            return Resource$.MODULE$.make(object, (Function1 & Serializable)_$8 -> package.all$.MODULE$.toFunctorOps(this.deleteIfExists((Path)_$8), this.evidence$2).void(), this.evidence$2);
        }

        @Override
        public Resource<F, Path> tempDirectory(Option<Path> dir, String prefix, Seq<FileAttribute<?>> attributes) {
            Object object;
            Option<Path> option = dir;
            if (option instanceof Some) {
                Path dir2 = (Path)((Some)option).value();
                object = Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.tempDirectory$$anonfun$1(prefix, attributes, dir2));
            } else if (None$.MODULE$.equals(option)) {
                object = Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.tempDirectory$$anonfun$2(prefix, attributes));
            } else {
                throw new MatchError(option);
            }
            return Resource$.MODULE$.make(object, (Function1 & Serializable)p -> {
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.deleteDirectoryRecursively((Path)p, (scala.collection.immutable.Set<FileVisitOption>)this.deleteDirectoryRecursively$default$2()), this.evidence$2);
                return ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return throwable instanceof NoSuchFileException;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        return throwable instanceof NoSuchFileException ? BoxedUnit.UNIT : function1.apply((Object)x);
                    }
                }, this.evidence$2);
            }, this.evidence$2);
        }

        @Override
        public Stream<F, Path> walk(Path start) {
            return this.walk(start, (Seq<FileVisitOption>)((Seq)package$.MODULE$.Seq().empty()));
        }

        @Override
        public Stream<F, Path> walk(Path start, Seq<FileVisitOption> options) {
            return this.walk(start, Integer.MAX_VALUE, options);
        }

        @Override
        public Stream<F, Path> walk(Path start, int maxDepth, Seq<FileVisitOption> options) {
            return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.walk$$anonfun$1(start, maxDepth, options)), (Function1 & Serializable)_$9 -> {
                java.util.Iterator iterator = CollectionCompat$.MODULE$.JIteratorOps(_$9.iterator());
                return CollectionCompat$JIteratorOps$.MODULE$.asScala$extension(iterator);
            });
        }

        @Override
        public Resource<F, Watcher<F>> watcher() {
            return Watcher$.MODULE$.default(this.evidence$2);
        }

        @Override
        public Stream<F, Watcher.Event> watch(Path path, Seq<Watcher.EventType> types, Seq<WatchEvent.Modifier> modifiers, FiniteDuration pollTimeout) {
            return Stream$.MODULE$.resource(Watcher$.MODULE$.default(this.evidence$2), this.evidence$2).evalTap((Function1 & Serializable)_$10 -> _$10.watch(path, types, modifiers), this.evidence$2).flatMap((Function1 & Serializable)_$11 -> _$11.events(pollTimeout), NotGiven$.MODULE$.value());
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeAll(Path path, Seq<StandardOpenOption> flags) {
            return (Function1 & Serializable)in -> Stream$.MODULE$.resource(this.writeCursor(path, (Seq<OpenOption>)flags), this.evidence$2).flatMap((Function1 & Serializable)_$12 -> {
                Pull pull = Pull$.MODULE$.StreamPullOps(_$12.writeAll(in).void());
                return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Seq<StandardOpenOption> writeAll$default$2() {
            return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
        }

        @Override
        public Resource<F, WriteCursor<F>> writeCursor(Path path, Seq<OpenOption> flags) {
            StandardOpenOption standardOpenOption = StandardOpenOption.WRITE;
            return this.open(path, (Seq<OpenOption>)flags.toList().$colon$colon((Object)standardOpenOption)).flatMap((Function1 & Serializable)fileHandle -> {
                Object object;
                if (flags.contains((Object)StandardOpenOption.APPEND)) {
                    object = fileHandle.size();
                } else {
                    Long l = (Long)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToLong((long)0L));
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)l, this.evidence$2);
                }
                Object size = object;
                Object cursor = package.all$.MODULE$.toFunctorOps(size, this.evidence$2).map((Function1 & Serializable)s -> this.$anonfun$1((FileHandle)fileHandle, BoxesRunTime.unboxToLong((Object)s)));
                return Resource$.MODULE$.eval(cursor);
            });
        }

        @Override
        public Seq<OpenOption> writeCursor$default$2() {
            return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
        }

        @Override
        public F writeCursorFromFileHandle(FileHandle<F> file, boolean append) {
            Object object;
            if (append) {
                object = package.all$.MODULE$.toFunctorOps(file.size(), this.evidence$2).map((Function1 & Serializable)s -> this.writeCursorFromFileHandle$$anonfun$1(file, BoxesRunTime.unboxToLong((Object)s)));
            } else {
                WriteCursor writeCursor = (WriteCursor)package.all$.MODULE$.catsSyntaxApplicativeId(WriteCursor$.MODULE$.apply(file, 0L));
                object = ApplicativeIdOps$.MODULE$.pure$extension((Object)writeCursor, this.evidence$2);
            }
            return (F)object;
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeRotate(F computePath, long limit, Seq<StandardOpenOption> flags) {
            return (Function1 & Serializable)in -> Stream$.MODULE$.resource(Hotswap$.MODULE$.apply(this.openNewFile$2(computePath, flags), this.evidence$2), this.evidence$2).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Hotswap fileHotswap = (Hotswap)tuple2._1();
                FileHandle fileHandle = (FileHandle)tuple2._2();
                return Stream$.MODULE$.eval(this.newCursor$1(flags, fileHandle)).flatMap((Function1 & Serializable)cursor -> {
                    Pull pull = Pull$.MODULE$.StreamPullOps(this.go$3(computePath, limit, (Seq)flags, fileHotswap, (WriteCursor)cursor, 0L, (Stream)in));
                    return Pull.StreamPullOps$.MODULE$.stream$extension(pull).drain();
                }, NotGiven$.MODULE$.value());
            }, NotGiven$.MODULE$.value());
        }

        private final Path copy$$anonfun$1(Path source$1, Path target$1, Seq flags$1) {
            return java.nio.file.Files.copy(source$1, target$1, (CopyOption[])Arrays$.MODULE$.seqToArray(flags$1, CopyOption.class));
        }

        private final Path createDirectory$$anonfun$1(Path path$1, Seq flags$2) {
            return java.nio.file.Files.createDirectory(path$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(flags$2, FileAttribute.class));
        }

        private final Path createDirectories$$anonfun$1(Path path$2, Seq flags$3) {
            return java.nio.file.Files.createDirectories(path$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(flags$3, FileAttribute.class));
        }

        private final void delete$$anonfun$1(Path path$3) {
            java.nio.file.Files.delete(path$3);
        }

        private final boolean deleteIfExists$$anonfun$1(Path path$4) {
            return java.nio.file.Files.deleteIfExists(path$4);
        }

        private final void deleteDirectoryRecursively$$anonfun$1(Path path$5, scala.collection.immutable.Set options$1) {
            scala.collection.immutable.Set set = CollectionCompat$.MODULE$.SetOps(options$1);
            java.nio.file.Files.walkFileTree(path$5, CollectionCompat$SetOps$.MODULE$.asJava$extension(set), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    java.nio.file.Files.deleteIfExists(path);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path path, IOException e) {
                    java.nio.file.Files.deleteIfExists(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private final DirectoryStream directoryStream$$anonfun$1(Path path$6) {
            return java.nio.file.Files.newDirectoryStream(path$6);
        }

        private final DirectoryStream directoryStream$$anonfun$3(Path path$7, Function1 filter$1) {
            return java.nio.file.Files.newDirectoryStream(path$7, entry -> BoxesRunTime.unboxToBoolean((Object)filter$1.apply(entry)));
        }

        private final DirectoryStream directoryStream$$anonfun$5(Path path$8, String glob$1) {
            return java.nio.file.Files.newDirectoryStream(path$8, glob$1);
        }

        private final boolean exists$$anonfun$1(Path path$9, Seq flags$4) {
            return java.nio.file.Files.exists(path$9, (LinkOption[])Arrays$.MODULE$.seqToArray(flags$4, LinkOption.class));
        }

        private final boolean isDirectory$$anonfun$1(Path path$10, Seq linkOption$1) {
            return java.nio.file.Files.isDirectory(path$10, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOption$1, LinkOption.class));
        }

        private final boolean isFile$$anonfun$1(Path path$11, Seq linkOption$2) {
            return java.nio.file.Files.isRegularFile(path$11, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOption$2, LinkOption.class));
        }

        private final Path move$$anonfun$1(Path source$2, Path target$2, Seq flags$5) {
            return java.nio.file.Files.move(source$2, target$2, (CopyOption[])Arrays$.MODULE$.seqToArray(flags$5, CopyOption.class));
        }

        private final FileChannel open$$anonfun$1(Path path$12, Seq flags$6) {
            return FileChannel.open(path$12, (OpenOption[])Arrays$.MODULE$.seqToArray(flags$6, OpenOption.class));
        }

        private final void openFileChannel$$anonfun$3$$anonfun$1(FileChannel ch$1) {
            ch$1.close();
        }

        private final scala.collection.immutable.Set permissions$$anonfun$1(Path path$13, Seq flags$7) {
            Set set = CollectionCompat$.MODULE$.JSetOps(java.nio.file.Files.getPosixFilePermissions(path$13, (LinkOption[])Arrays$.MODULE$.seqToArray(flags$7, LinkOption.class)));
            return CollectionCompat$JSetOps$.MODULE$.asScala$extension(set);
        }

        private final Path setPermissions$$anonfun$1(Path path$14, scala.collection.immutable.Set permissions$1) {
            scala.collection.immutable.Set set = CollectionCompat$.MODULE$.SetOps(permissions$1);
            return java.nio.file.Files.setPosixFilePermissions(path$14, CollectionCompat$SetOps$.MODULE$.asJava$extension(set));
        }

        private final long size$$anonfun$1(Path path$15) {
            return java.nio.file.Files.size(path$15);
        }

        private final Path tempFile$$anonfun$1(String prefix$1, String suffix$1, Seq attributes$1, Path dir$1) {
            return java.nio.file.Files.createTempFile(dir$1, prefix$1, suffix$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$1, FileAttribute.class));
        }

        private final Path tempFile$$anonfun$2(String prefix$2, String suffix$2, Seq attributes$2) {
            return java.nio.file.Files.createTempFile(prefix$2, suffix$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$2, FileAttribute.class));
        }

        private final Path tempDirectory$$anonfun$1(String prefix$3, Seq attributes$3, Path dir$2) {
            return java.nio.file.Files.createTempDirectory(dir$2, prefix$3, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$3, FileAttribute.class));
        }

        private final Path tempDirectory$$anonfun$2(String prefix$4, Seq attributes$4) {
            return java.nio.file.Files.createTempDirectory(prefix$4, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$4, FileAttribute.class));
        }

        private final java.util.stream.Stream walk$$anonfun$1(Path start$2, int maxDepth$1, Seq options$2) {
            return java.nio.file.Files.walk(start$2, maxDepth$1, (FileVisitOption[])Arrays$.MODULE$.seqToArray(options$2, FileVisitOption.class));
        }

        private final /* synthetic */ WriteCursor $anonfun$1(FileHandle fileHandle$1, long s) {
            return WriteCursor$.MODULE$.apply(fileHandle$1, s);
        }

        private final /* synthetic */ WriteCursor writeCursorFromFileHandle$$anonfun$1(FileHandle file$1, long s) {
            return WriteCursor$.MODULE$.apply(file$1, s);
        }

        private final Resource openNewFile$2(Object computePath$1, Seq flags$10) {
            return Resource$.MODULE$.eval(computePath$1).flatMap((Function1 & Serializable)p -> {
                StandardOpenOption standardOpenOption = StandardOpenOption.WRITE;
                return this.open((Path)p, (Seq<OpenOption>)flags$10.toList().$colon$colon((Object)standardOpenOption));
            });
        }

        private final Object newCursor$1(Seq flags$12, FileHandle file) {
            return this.writeCursorFromFileHandle(file, flags$12.contains((Object)StandardOpenOption.APPEND));
        }

        private final Pull go$3(Object computePath$2, long limit$1, Seq flags$13, Hotswap fileHotswap, WriteCursor cursor, long acc, Stream s) {
            int toWrite = (int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(limit$1 - acc), (long)Integer.MAX_VALUE);
            Stream stream = Stream$.MODULE$.InvariantOps(s);
            Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            return Stream.ToPull$.MODULE$.unconsLimit$extension(stream2, toWrite).flatMap((Function1 & Serializable)x$1 -> {
                Pull pull;
                Tuple2 tuple2;
                Option option = x$1;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Chunk hd = (Chunk)tuple2._1();
                    Stream tl = (Stream)tuple2._2();
                    long newAcc = acc + (long)hd.size();
                    pull = cursor.writePull((Chunk<Object>)hd).flatMap((Function1 & Serializable)nc2 -> newAcc >= limit$1 ? Pull$.MODULE$.eval(package.all$.MODULE$.toFlatMapOps(fileHotswap.swap(this.openNewFile$2(computePath$2, flags$13)), this.evidence$2).flatMap((Function1 & Serializable)file -> this.newCursor$1(flags$13, (FileHandle)file))).flatMap((Function1 & Serializable)nc -> this.go$3(computePath$2, limit$1, flags$13, fileHotswap, (WriteCursor)nc, 0L, tl)) : this.go$3(computePath$2, limit$1, flags$13, fileHotswap, (WriteCursor)nc2, newAcc, tl));
                } else if (None$.MODULE$.equals(option)) {
                    pull = Pull$.MODULE$.done();
                } else {
                    throw new MatchError((Object)option);
                }
                return pull;
            });
        }
    }
}

