/*
 * Decompiled with CFR 0.152.
 */
package fs2.protocols.mpeg.transport;

import fs2.protocols.mpeg.MpegError;
import fs2.protocols.mpeg.MpegError$Decoding$;
import fs2.protocols.mpeg.transport.ContinuityCounter;
import fs2.protocols.mpeg.transport.DemultiplexerError$;
import fs2.protocols.mpeg.transport.DemultiplexerError$Decoding$;
import fs2.protocols.mpeg.transport.DemultiplexerError$Discontinuity$;
import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scodec.Err;
import scodec.bits.BitVector;

public abstract class DemultiplexerError {
    public static int ordinal(DemultiplexerError demultiplexerError) {
        return DemultiplexerError$.MODULE$.ordinal(demultiplexerError);
    }

    public abstract MpegError toMpegError();

    public static class Decoding
    extends DemultiplexerError
    implements Product,
    Serializable {
        private final BitVector data;
        private final Err decodingError;

        public static Decoding apply(BitVector bitVector, Err err) {
            return DemultiplexerError$Decoding$.MODULE$.apply(bitVector, err);
        }

        public static Decoding fromProduct(Product product) {
            return DemultiplexerError$Decoding$.MODULE$.fromProduct(product);
        }

        public static Decoding unapply(Decoding decoding) {
            return DemultiplexerError$Decoding$.MODULE$.unapply(decoding);
        }

        public Decoding(BitVector data, Err decodingError) {
            this.data = data;
            this.decodingError = decodingError;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Decoding)) return false;
            Decoding decoding = (Decoding)object;
            BitVector bitVector = this.data();
            BitVector bitVector2 = decoding.data();
            if (bitVector == null) {
                if (bitVector2 != null) {
                    return false;
                }
            } else if (!bitVector.equals(bitVector2)) return false;
            Err err = this.decodingError();
            Err err2 = decoding.decodingError();
            if (err == null) {
                if (err2 != null) {
                    return false;
                }
            } else if (!err.equals(err2)) return false;
            if (!decoding.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Decoding;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Decoding";
        }

        public Object productElement(int n) {
            BitVector bitVector;
            int n2 = n;
            if (0 == n2) {
                bitVector = this._1();
            } else if (1 == n2) {
                bitVector = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return bitVector;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "data";
            } else if (1 == n2) {
                string = "decodingError";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public BitVector data() {
            return this.data;
        }

        public Err decodingError() {
            return this.decodingError;
        }

        public String message() {
            return new StringBuilder(33).append("decoding error (").append(this.decodingError()).append(") while decoding ").append(this.data().toHex()).toString();
        }

        @Override
        public MpegError toMpegError() {
            return MpegError$Decoding$.MODULE$.apply(this.data(), this.decodingError());
        }

        public Decoding copy(BitVector data, Err decodingError) {
            return new Decoding(data, decodingError);
        }

        public BitVector copy$default$1() {
            return this.data();
        }

        public Err copy$default$2() {
            return this.decodingError();
        }

        public BitVector _1() {
            return this.data();
        }

        public Err _2() {
            return this.decodingError();
        }
    }

    public static class Discontinuity
    extends DemultiplexerError
    implements MpegError,
    Product,
    Serializable {
        private final ContinuityCounter last;
        private final ContinuityCounter current;
        private final int adaptationFieldControl;

        public static Discontinuity apply(ContinuityCounter continuityCounter, ContinuityCounter continuityCounter2, int n) {
            return DemultiplexerError$Discontinuity$.MODULE$.apply(continuityCounter, continuityCounter2, n);
        }

        public static Discontinuity fromProduct(Product product) {
            return DemultiplexerError$Discontinuity$.MODULE$.fromProduct(product);
        }

        public static Discontinuity unapply(Discontinuity discontinuity) {
            return DemultiplexerError$Discontinuity$.MODULE$.unapply(discontinuity);
        }

        public Discontinuity(ContinuityCounter last, ContinuityCounter current, int adaptationFieldControl) {
            this.last = last;
            this.current = current;
            this.adaptationFieldControl = adaptationFieldControl;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.last()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.current()));
            n = Statics.mix((int)n, (int)this.adaptationFieldControl());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Discontinuity)) return false;
            Discontinuity discontinuity = (Discontinuity)object;
            if (this.adaptationFieldControl() != discontinuity.adaptationFieldControl()) return false;
            ContinuityCounter continuityCounter = this.last();
            ContinuityCounter continuityCounter2 = discontinuity.last();
            if (continuityCounter == null) {
                if (continuityCounter2 != null) {
                    return false;
                }
            } else if (!((Object)continuityCounter).equals(continuityCounter2)) return false;
            ContinuityCounter continuityCounter3 = this.current();
            ContinuityCounter continuityCounter4 = discontinuity.current();
            if (continuityCounter3 == null) {
                if (continuityCounter4 != null) {
                    return false;
                }
            } else if (!((Object)continuityCounter3).equals(continuityCounter4)) return false;
            if (!discontinuity.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Discontinuity;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Discontinuity";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = this._1();
                    break;
                }
                case 1: {
                    serializable = this._2();
                    break;
                }
                case 2: {
                    serializable = BoxesRunTime.boxToInteger((int)this._3());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "last";
                    break;
                }
                case 1: {
                    string = "current";
                    break;
                }
                case 2: {
                    string = "adaptationFieldControl";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public ContinuityCounter last() {
            return this.last;
        }

        public ContinuityCounter current() {
            return this.current;
        }

        public int adaptationFieldControl() {
            return this.adaptationFieldControl;
        }

        @Override
        public String message() {
            return new StringBuilder(54).append("pid discontinuity: ").append(this.last()).append(" to ").append(this.current()).append(" with adaptation field control ").append(this.adaptationFieldControl()).toString();
        }

        @Override
        public MpegError toMpegError() {
            return this;
        }

        public Discontinuity copy(ContinuityCounter last, ContinuityCounter current, int adaptationFieldControl) {
            return new Discontinuity(last, current, adaptationFieldControl);
        }

        public ContinuityCounter copy$default$1() {
            return this.last();
        }

        public ContinuityCounter copy$default$2() {
            return this.current();
        }

        public int copy$default$3() {
            return this.adaptationFieldControl();
        }

        public ContinuityCounter _1() {
            return this.last();
        }

        public ContinuityCounter _2() {
            return this.current();
        }

        public int _3() {
            return this.adaptationFieldControl();
        }
    }
}

