/*
 * Decompiled with CFR 0.152.
 */
package fs2.protocols.mpeg.transport;

import fs2.Chunk;
import fs2.Chunk$;
import fs2.Scan;
import fs2.Scan$;
import fs2.protocols.mpeg.PesPacket;
import fs2.protocols.mpeg.PesPacket$;
import fs2.protocols.mpeg.PesPacketHeaderPrefix;
import fs2.protocols.mpeg.PesPacketHeaderPrefix$;
import fs2.protocols.mpeg.transport.ContinuityCounter;
import fs2.protocols.mpeg.transport.Demultiplexer;
import fs2.protocols.mpeg.transport.Demultiplexer$StepResult$;
import fs2.protocols.mpeg.transport.DemultiplexerError;
import fs2.protocols.mpeg.transport.Packet;
import fs2.protocols.mpeg.transport.Packet$;
import fs2.protocols.mpeg.transport.Pid;
import fs2.protocols.mpeg.transport.PidStamped;
import fs2.protocols.mpeg.transport.psi.Section;
import fs2.protocols.mpeg.transport.psi.SectionCodec;
import fs2.protocols.mpeg.transport.psi.SectionHeader;
import fs2.protocols.mpeg.transport.psi.SectionHeader$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.Attempt;
import scodec.Attempt$;
import scodec.Codec;
import scodec.Codec$;
import scodec.DecodeResult;
import scodec.Decoder;
import scodec.Decoder$;
import scodec.Err;
import scodec.bits.BitVector;
import scodec.bits.BitVector$;
import scodec.bits.ByteVector$;
import shapeless.Lazy$;

public final class Demultiplexer$ {
    public static final Demultiplexer$ MODULE$ = new Demultiplexer$();

    public <F> Scan<Tuple2<Map<Pid, ContinuityCounter>, Demultiplexer.State>, Packet, PidStamped<Either<DemultiplexerError, Demultiplexer.Result>>> demultiplex(SectionCodec sectionCodec) {
        return this.demultiplexSectionsAndPesPackets((Function1<SectionHeader, Decoder<Section>>)(Function1 & Serializable)header -> sectionCodec.decoder((SectionHeader)header), (Function1<PesPacketHeaderPrefix, Decoder<PesPacket>>)(Function1 & Serializable)pph -> Decoder$.MODULE$.apply((Function1 & Serializable)b -> Attempt$.MODULE$.successful((Object)new DecodeResult((Object)new PesPacket.WithoutHeader(pph.streamId(), (BitVector)b), BitVector$.MODULE$.empty()))));
    }

    public <F> Scan<Tuple2<Map<Pid, ContinuityCounter>, Demultiplexer.State>, Packet, PidStamped<Either<DemultiplexerError, Demultiplexer.Result>>> demultiplexWithPesHeaders(SectionCodec sectionCodec) {
        return this.demultiplexSectionsAndPesPackets((Function1<SectionHeader, Decoder<Section>>)(Function1 & Serializable)header -> sectionCodec.decoder((SectionHeader)header), (Function1<PesPacketHeaderPrefix, Decoder<PesPacket>>)(Function1 & Serializable)prefix -> PesPacket$.MODULE$.decoder((PesPacketHeaderPrefix)prefix));
    }

    public <F> Scan<Tuple2<Map<Pid, ContinuityCounter>, Demultiplexer.State>, Packet, PidStamped<Either<DemultiplexerError, Demultiplexer.Result>>> demultiplexSectionsAndPesPackets(Function1<SectionHeader, Decoder<Section>> decodeSectionBody, Function1<PesPacketHeaderPrefix, Decoder<PesPacket>> decodePesBody) {
        BitVector stuffingByte = BitVector$.MODULE$.fromValidBin(new StringBuilder().append("11111111").toString(), BitVector$.MODULE$.fromValidBin$default$2());
        return this.demultiplexGeneral((Function2 & Serializable)(data, startedAtOffsetZero) -> Demultiplexer$.decodeHeader$1(data, BoxesRunTime.unboxToBoolean((Object)startedAtOffsetZero), stuffingByte, decodePesBody, decodeSectionBody));
    }

    public <F, Out> Scan<Tuple2<Map<Pid, ContinuityCounter>, Demultiplexer.State>, Packet, PidStamped<Either<DemultiplexerError, Out>>> demultiplexGeneral(Function2<BitVector, Object, Attempt<DecodeResult<Demultiplexer.DecodeBody<Out>>>> decodeHeader) {
        Scan demux = Scan$.MODULE$.stateful((Object)new Demultiplexer.State((Map<Pid, Demultiplexer.DecodeState>)Predef$.MODULE$.Map().empty()), (Function2 & Serializable)(state, event) -> {
            Tuple2 tuple2;
            Either either = event;
            if (either instanceof Right) {
                Right right = (Right)either;
                Packet packet = (Packet)right.value();
                Pid pid = packet.header().pid();
                Option oldStateForPid = state.byPid().get((Object)pid);
                Demultiplexer.StepResult result = Demultiplexer$.handlePacket$1(oldStateForPid, packet, decodeHeader);
                Demultiplexer.State newState = new Demultiplexer.State((Map<Pid, Demultiplexer.DecodeState>)((Map)result.state().map((Function1 & Serializable)s -> (Map)state.byPid().updated((Object)pid, s)).getOrElse((Function0 & Serializable)() -> (Map)state.byPid().$minus((Object)pid))));
                Chunk out = result.output().map((Function1 & Serializable)e -> new PidStamped<Either>(pid, (Either)e));
                tuple2 = new Tuple2((Object)newState, (Object)out);
            } else if (either instanceof Left) {
                Left left = (Left)either;
                PidStamped discontinuity = (PidStamped)left.value();
                Demultiplexer.State newState = new Demultiplexer.State((Map<Pid, Demultiplexer.DecodeState>)((Map)state.byPid().$minus((Object)discontinuity.pid())));
                Chunk out = Chunk$.MODULE$.singleton(new PidStamped<Left>(discontinuity.pid(), package$.MODULE$.Left().apply(discontinuity.value())));
                tuple2 = new Tuple2((Object)newState, (Object)out);
            } else {
                throw new MatchError((Object)either);
            }
            return tuple2;
        });
        return Packet$.MODULE$.validateContinuity().andThen(demux);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Attempt decodeHeader$1(BitVector data, boolean startedAtOffsetZero, BitVector stuffingByte$1, Function1 decodePesBody$1, Function1 decodeSectionBody$1) {
        Attempt attempt;
        if (data.sizeLessThan(16L)) {
            attempt = Attempt$.MODULE$.failure((Err)new Err.InsufficientBits(16L, data.size(), (List)package$.MODULE$.Nil()));
            return attempt;
        }
        if (data.startsWith(stuffingByte$1)) {
            attempt = Attempt$.MODULE$.failure((Err)new Demultiplexer.ResetDecodeState((List<String>)package$.MODULE$.Nil()));
            return attempt;
        }
        if (startedAtOffsetZero) {
            BitVector bitVector = data.take(16L);
            BitVector bitVector2 = ByteVector$.MODULE$.fromValidHex(new StringBuilder().append("0001").toString(), ByteVector$.MODULE$.fromValidHex$default$2()).bits();
            if (!(bitVector != null ? !bitVector.equals(bitVector2) : bitVector2 != null)) {
                if (data.sizeLessThan(40L)) {
                    attempt = Attempt$.MODULE$.failure((Err)new Err.InsufficientBits(40L, data.size(), (List)package$.MODULE$.Nil()));
                    return attempt;
                }
                Codec<PesPacketHeaderPrefix> inst$macro$11 = PesPacketHeaderPrefix$.MODULE$.codec();
                attempt = Codec$.MODULE$.apply(Lazy$.MODULE$.apply((Function0 & Serializable)() -> inst$macro$11)).decode(data.drop(16L)).map((Function1 & Serializable)x$1 -> x$1.map((Function1 & Serializable)header -> {
                    None$ neededBits = header.length() == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((long)header.length() * 8L)));
                    return new Demultiplexer.DecodeBody((Option<Object>)neededBits, ((Decoder)decodePesBody$1.apply(header)).map((Function1 & Serializable)body -> new Demultiplexer.PesPacketResult((PesPacket)body)));
                }));
                return attempt;
            }
        }
        if (data.sizeLessThan(24L)) {
            attempt = Attempt$.MODULE$.failure((Err)new Err.InsufficientBits(24L, data.size(), (List)package$.MODULE$.Nil()));
            return attempt;
        }
        Codec<SectionHeader> inst$macro$26 = SectionHeader$.MODULE$.codec();
        attempt = Codec$.MODULE$.apply(Lazy$.MODULE$.apply((Function0 & Serializable)() -> inst$macro$26)).decode(data).map((Function1 & Serializable)x$2 -> x$2.map((Function1 & Serializable)header -> new Demultiplexer.DecodeBody((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((long)header.length() * 8L))), ((Decoder)decodeSectionBody$1.apply(header)).map((Function1 & Serializable)section -> new Demultiplexer.SectionResult((Section)section)))));
        return attempt;
    }

    public static final /* synthetic */ BitVector $anonfun$demultiplexGeneral$1(Demultiplexer.DecodeState.AwaitingBody awaitingBody$1, long n) {
        return awaitingBody$1.bitsPostHeader().take(n);
    }

    private static final Demultiplexer.StepResult processBody$1(Demultiplexer.DecodeState.AwaitingBody awaitingBody, boolean payloadUnitStartAfterData, Function2 decodeHeader$2) {
        Demultiplexer.StepResult<Object> stepResult;
        boolean bl;
        Option<Object> option = awaitingBody.neededBits();
        if (None$.MODULE$.equals(option)) {
            bl = payloadUnitStartAfterData;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long needed = BoxesRunTime.unboxToLong((Object)some.value());
            bl = awaitingBody.bitsPostHeader().size() >= needed;
        } else {
            throw new MatchError(option);
        }
        boolean haveFullBody = bl;
        if (haveFullBody) {
            Demultiplexer.StepResult<Object> stepResult2;
            Attempt.Successful successful;
            DecodeResult decodeResult;
            Attempt attempt = awaitingBody.decode();
            if (attempt instanceof Attempt.Successful && (decodeResult = (DecodeResult)(successful = (Attempt.Successful)attempt).value()) != null) {
                Object body = decodeResult.value();
                BitVector remainder = decodeResult.remainder();
                Demultiplexer.StepResult<Object> decoded = Demultiplexer$StepResult$.MODULE$.oneResult((Option<Demultiplexer.DecodeState>)None$.MODULE$, body);
                stepResult2 = decoded.$plus$plus(Demultiplexer$.processHeader$1(remainder, false, payloadUnitStartAfterData, decodeHeader$2));
            } else if (attempt instanceof Attempt.Failure) {
                Demultiplexer.StepResult<Object> stepResult3;
                Attempt.Failure failure = (Attempt.Failure)attempt;
                Err err = failure.cause();
                Chunk out = err instanceof Demultiplexer.ResetDecodeState ? Chunk$.MODULE$.empty() : Chunk$.MODULE$.singleton((Object)package$.MODULE$.Left().apply((Object)new DemultiplexerError.Decoding(awaitingBody.headerBits().$plus$plus((BitVector)awaitingBody.neededBits().map((Function1 & Serializable)n -> Demultiplexer$.$anonfun$demultiplexGeneral$1(awaitingBody, BoxesRunTime.unboxToLong((Object)n))).getOrElse((Function0 & Serializable)() -> awaitingBody.bitsPostHeader())), err)));
                Demultiplexer.StepResult failure2 = new Demultiplexer.StepResult((Option<Demultiplexer.DecodeState>)None$.MODULE$, out);
                Option<Object> option2 = awaitingBody.neededBits();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    long n2 = BoxesRunTime.unboxToLong((Object)some.value());
                    BitVector remainder = awaitingBody.bitsPostHeader().drop(n2);
                    stepResult3 = failure2.$plus$plus(Demultiplexer$.processHeader$1(remainder, false, payloadUnitStartAfterData, decodeHeader$2));
                } else if (None$.MODULE$.equals(option2)) {
                    stepResult3 = failure2;
                } else {
                    throw new MatchError(option2);
                }
                stepResult2 = stepResult3;
            } else {
                throw new MatchError(attempt);
            }
            stepResult = stepResult2;
        } else {
            stepResult = Demultiplexer$StepResult$.MODULE$.state(awaitingBody);
        }
        return stepResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Demultiplexer.StepResult processHeader$1(BitVector acc, boolean startedAtOffsetZero, boolean payloadUnitStartAfterData, Function2 decodeHeader$2) {
        Codec codec2;
        boolean bl = false;
        Attempt.Failure failure = null;
        Attempt attempt = (Attempt)decodeHeader$2.apply((Object)acc, (Object)BoxesRunTime.boxToBoolean((boolean)startedAtOffsetZero));
        if (attempt instanceof Attempt.Failure) {
            bl = true;
            failure = (Attempt.Failure)attempt;
            if (failure.cause() instanceof Err.InsufficientBits) {
                return Demultiplexer$StepResult$.MODULE$.state(new Demultiplexer.DecodeState.AwaitingHeader(acc, startedAtOffsetZero));
            }
        }
        if (bl && failure.cause() instanceof Demultiplexer.ResetDecodeState) {
            return Demultiplexer$StepResult$.MODULE$.noOutput((Option<Demultiplexer.DecodeState>)None$.MODULE$);
        }
        if (bl) {
            Err e = failure.cause();
            return Demultiplexer$StepResult$.MODULE$.oneError((Option<Demultiplexer.DecodeState>)None$.MODULE$, new DemultiplexerError.Decoding(acc, e));
        }
        if (!(attempt instanceof Attempt.Successful)) throw new MatchError((Object)attempt);
        Attempt.Successful successful = (Attempt.Successful)attempt;
        DecodeResult decodeResult = (DecodeResult)successful.value();
        if (decodeResult == null) throw new MatchError((Object)attempt);
        Demultiplexer.DecodeBody decodeBody = (Demultiplexer.DecodeBody)decodeResult.value();
        BitVector bitsPostHeader = decodeResult.remainder();
        if (decodeBody == null) throw new MatchError((Object)attempt);
        Option<Object> neededBits = decodeBody.neededBits();
        Codec decoder = decodeBody.decoder();
        Option<Object> option = neededBits;
        if (None$.MODULE$.equals(option)) {
            codec2 = decoder;
        } else {
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            long n = BoxesRunTime.unboxToLong((Object)some.value());
            codec2 = scodec.codecs.package$.MODULE$.fixedSizeBits(n, decoder.decodeOnly());
        }
        Codec guardedDecoder = codec2;
        return Demultiplexer$.processBody$1(new Demultiplexer.DecodeState.AwaitingBody(acc.take(24L), neededBits, bitsPostHeader, guardedDecoder), payloadUnitStartAfterData, decodeHeader$2);
    }

    private static final Demultiplexer.StepResult resume$1(Demultiplexer.DecodeState state, BitVector newData, boolean payloadUnitStartAfterData, Function2 decodeHeader$2) {
        Demultiplexer.StepResult stepResult;
        Demultiplexer.DecodeState decodeState = state;
        if (decodeState instanceof Demultiplexer.DecodeState.AwaitingHeader) {
            Demultiplexer.DecodeState.AwaitingHeader awaitingHeader = (Demultiplexer.DecodeState.AwaitingHeader)decodeState;
            stepResult = Demultiplexer$.processHeader$1(awaitingHeader.acc().$plus$plus(newData), awaitingHeader.startedAtOffsetZero(), payloadUnitStartAfterData, decodeHeader$2);
        } else if (decodeState instanceof Demultiplexer.DecodeState.AwaitingBody) {
            Demultiplexer.DecodeState.AwaitingBody awaitingBody = (Demultiplexer.DecodeState.AwaitingBody)decodeState;
            stepResult = Demultiplexer$.processBody$1(awaitingBody.accumulate(newData), payloadUnitStartAfterData, decodeHeader$2);
        } else {
            throw new MatchError((Object)decodeState);
        }
        return stepResult;
    }

    private static final Demultiplexer.StepResult handlePacket$1(Option state, Packet packet, Function2 decodeHeader$2) {
        Demultiplexer.StepResult<Nothing$> stepResult;
        Option<BitVector> option = packet.payload();
        if (None$.MODULE$.equals(option)) {
            stepResult = Demultiplexer$StepResult$.MODULE$.noOutput((Option<Demultiplexer.DecodeState>)state);
        } else if (option instanceof Some) {
            Demultiplexer.StepResult stepResult2;
            Demultiplexer.StepResult stepResult3;
            Some some = (Some)option;
            BitVector payload = (BitVector)some.value();
            Option option2 = state;
            if (None$.MODULE$.equals(option2)) {
                stepResult3 = Demultiplexer$StepResult$.MODULE$.noOutput((Option<Demultiplexer.DecodeState>)state);
            } else if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Demultiplexer.DecodeState state2 = (Demultiplexer.DecodeState)some2.value();
                BitVector currentData = (BitVector)packet.payloadUnitStart().map((Function1 & Serializable)start -> payload.take((long)BoxesRunTime.unboxToInt((Object)start) * 8L)).getOrElse((Function0 & Serializable)() -> payload);
                stepResult3 = Demultiplexer$.resume$1(state2, currentData, packet.payloadUnitStart().isDefined(), decodeHeader$2);
            } else {
                throw new MatchError((Object)option2);
            }
            Demultiplexer.StepResult currentResult = stepResult3;
            Option<Object> option3 = packet.payloadUnitStart();
            if (None$.MODULE$.equals(option3)) {
                stepResult2 = currentResult;
            } else if (option3 instanceof Some) {
                Some some3 = (Some)option3;
                int start2 = BoxesRunTime.unboxToInt((Object)some3.value());
                Demultiplexer.StepResult nextResult = Demultiplexer$.processHeader$1(payload.drop((long)start2 * 8L), start2 == 0, false, decodeHeader$2);
                stepResult2 = currentResult.$plus$plus(nextResult);
            } else {
                throw new MatchError(option3);
            }
            stepResult = stepResult2;
        } else {
            throw new MatchError(option);
        }
        return stepResult;
    }

    private Demultiplexer$() {
    }
}

