/*
 * Decompiled with CFR 0.152.
 */
package fs2.protocols.mpeg.transport.psi;

import cats.data.Chain;
import cats.data.Chain$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Scan;
import fs2.Scan$;
import fs2.protocols.mpeg.MpegError;
import fs2.protocols.mpeg.MpegError$;
import fs2.protocols.mpeg.PesPacket;
import fs2.protocols.mpeg.transport.ContinuityCounter;
import fs2.protocols.mpeg.transport.Demultiplexer;
import fs2.protocols.mpeg.transport.Demultiplexer$;
import fs2.protocols.mpeg.transport.DemultiplexerError;
import fs2.protocols.mpeg.transport.Packet;
import fs2.protocols.mpeg.transport.Pid;
import fs2.protocols.mpeg.transport.PidStamped;
import fs2.protocols.mpeg.transport.PidStamped$;
import fs2.protocols.mpeg.transport.TransportStreamHeader;
import fs2.protocols.mpeg.transport.psi.GroupedSections;
import fs2.protocols.mpeg.transport.psi.GroupingError;
import fs2.protocols.mpeg.transport.psi.Section;
import fs2.protocols.mpeg.transport.psi.SectionCodec;
import fs2.protocols.mpeg.transport.psi.Table;
import fs2.protocols.mpeg.transport.psi.TableBuilder;
import fs2.protocols.mpeg.transport.psi.TableBuildingError;
import fs2.protocols.mpeg.transport.psi.TransportStreamEvent;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.BitVector;

public final class TransportStreamEvent$ {
    public static final TransportStreamEvent$ MODULE$ = new TransportStreamEvent$();

    public TransportStreamEvent pes(Pid pid, PesPacket pes) {
        return new TransportStreamEvent.Pes(pid, pes);
    }

    public TransportStreamEvent table(Pid pid, Table table) {
        return new TransportStreamEvent.Table(pid, table);
    }

    public TransportStreamEvent scrambledPayload(Pid pid, BitVector content) {
        return new TransportStreamEvent.ScrambledPayload(pid, content);
    }

    public <A> TransportStreamEvent metadata(A md) {
        return new TransportStreamEvent.Metadata<A>((Option<Pid>)None$.MODULE$, md);
    }

    public <A> TransportStreamEvent metadata(Pid pid, A md) {
        return new TransportStreamEvent.Metadata<A>((Option<Pid>)new Some((Object)pid), md);
    }

    public TransportStreamEvent error(Pid pid, MpegError e) {
        return new TransportStreamEvent.Error((Option<Pid>)new Some((Object)pid), e);
    }

    public TransportStreamEvent error(Option<Pid> pid, MpegError e) {
        return new TransportStreamEvent.Error(pid, e);
    }

    private <S> Scan<Tuple2<Map<Pid, S>, TransportStreamIndex>, PidStamped<Either<MpegError, Section>>, TransportStreamEvent> sectionsToTables(Scan<S, Section, Either<GroupingError, GroupedSections<Section>>> group, TableBuilder tableBuilder) {
        Scan sectionsToTablesForPid = group.map((Function1 & Serializable)x0$1 -> {
            Either<TableBuildingError, Table> either;
            Either either2 = x0$1;
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                GroupingError e = (GroupingError)left.value();
                either = package$.MODULE$.Left().apply((Object)e);
            } else if (either2 instanceof Right) {
                Right right = (Right)either2;
                GroupedSections gs = (GroupedSections)right.value();
                either = tableBuilder.build(gs);
            } else {
                throw new MatchError((Object)either2);
            }
            return either;
        });
        Scan sectionsToTables = Scan$.MODULE$.apply((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$2, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Map state = (Map)tuple22._1();
            PidStamped pidStamped = (PidStamped)tuple22._2();
            if (pidStamped == null) throw new MatchError((Object)tuple22);
            Pid pid = pidStamped.pid();
            Either e = (Either)pidStamped.value();
            Either either = e;
            if (either instanceof Right) {
                Right right = (Right)either;
                Section section = (Section)right.value();
                Object groupingState = state.getOrElse((Object)pid, (Function0 & Serializable)() -> group.initial());
                Tuple2 tuple23 = sectionsToTablesForPid.transform(groupingState, (Object)section);
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Object s = tuple23._1();
                Chunk out = (Chunk)tuple23._2();
                Tuple2 tuple24 = new Tuple2(s, (Object)out);
                Tuple2 tuple25 = tuple24;
                Object s2 = tuple25._1();
                Chunk out2 = (Chunk)tuple25._2();
                tuple2 = new Tuple2((Object)state.updated((Object)pid, s2), (Object)out2.map((Function1 & Serializable)x$2 -> new PidStamped<Either>(pid, (Either)x$2)));
                return tuple2;
            } else {
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Left left = (Left)either;
                MpegError err = (MpegError)left.value();
                tuple2 = new Tuple2((Object)state, (Object)Chunk$.MODULE$.singleton(new PidStamped<Left>(pid, package$.MODULE$.Left().apply((Object)err))));
            }
            return tuple2;
        }, (Function1 & Serializable)state -> Chunk$.MODULE$.concat((Seq)((Chain)state.foldLeft((Object)Chain$.MODULE$.empty(), (Function2 & Serializable)(x0$3, x1$2) -> {
            Tuple2 tuple2;
            Chain acc;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$3, x1$2);
                    if (tuple22 == null) break block2;
                    acc = (Chain)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Pid pid = (Pid)tuple2._1();
            Object gs = tuple2._2();
            Chain chain = acc.$colon$plus((Object)sectionsToTablesForPid.onComplete(gs).map((Function1 & Serializable)x$3 -> new PidStamped<Either>(pid, (Either)x$3)));
            return chain;
        })).toList(), ClassTag$.MODULE$.apply(PidStamped.class)));
        return sectionsToTables.andThen(PidStamped$.MODULE$.preserve(MpegError$.MODULE$.passErrors(TransportStreamIndex$.MODULE$.build()))).map(TransportStreamEvent$::$anonfun$sectionsToTables$8);
    }

    public <S> Scan<Tuple2<Tuple2<Map<Pid, ContinuityCounter>, Demultiplexer.State>, Tuple2<Map<Pid, S>, TransportStreamIndex>>, Packet, TransportStreamEvent> fromPacketStream(SectionCodec sectionCodec, Scan<S, Section, Either<GroupingError, GroupedSections<Section>>> group, TableBuilder tableBuilder) {
        Scan demuxed = Demultiplexer$.MODULE$.demultiplex(sectionCodec).andThen(this.sectionsToTables(group, tableBuilder).semipass((Function1 & Serializable)x0$1 -> {
            PidStamped pidStamped = x0$1;
            if (pidStamped != null) {
                Right right;
                Demultiplexer.Result result;
                Pid pid = pidStamped.pid();
                Either either = (Either)pidStamped.value();
                if (either instanceof Right && (result = (Demultiplexer.Result)(right = (Right)either).value()) instanceof Demultiplexer.SectionResult) {
                    Demultiplexer.SectionResult sectionResult = (Demultiplexer.SectionResult)result;
                    Section section = sectionResult.section();
                    return package$.MODULE$.Right().apply(new PidStamped<Right>(pid, package$.MODULE$.Right().apply((Object)section)));
                }
            }
            if (pidStamped != null) {
                Right right;
                Demultiplexer.Result result;
                Pid pid = pidStamped.pid();
                Either either = (Either)pidStamped.value();
                if (either instanceof Right && (result = (Demultiplexer.Result)(right = (Right)either).value()) instanceof Demultiplexer.PesPacketResult) {
                    Demultiplexer.PesPacketResult pesPacketResult = (Demultiplexer.PesPacketResult)result;
                    PesPacket p = pesPacketResult.body();
                    return package$.MODULE$.Left().apply((Object)MODULE$.pes(pid, p));
                }
            }
            if (pidStamped == null) throw new MatchError((Object)pidStamped);
            Pid pid = pidStamped.pid();
            Either either = (Either)pidStamped.value();
            if (!(either instanceof Left)) throw new MatchError((Object)pidStamped);
            Left left = (Left)either;
            DemultiplexerError e = (DemultiplexerError)left.value();
            return package$.MODULE$.Right().apply(new PidStamped<Left>(pid, package$.MODULE$.Left().apply((Object)e.toMpegError())));
        }));
        return demuxed.semipass((Function1 & Serializable)x0$2 -> {
            Packet packet = x0$2;
            if (packet != null) {
                TransportStreamHeader header = packet.header();
                Option<BitVector> option = packet.payload();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BitVector payload = (BitVector)some.value();
                    if (header.scramblingControl() != 0) {
                        return package$.MODULE$.Left().apply((Object)MODULE$.scrambledPayload(header.pid(), payload));
                    }
                }
            }
            if (packet == null) throw new MatchError((Object)packet);
            return package$.MODULE$.Right().apply((Object)packet);
        });
    }

    public <S> Scan<Tuple2<Map<Pid, S>, TransportStreamIndex>, PidStamped<Section>, TransportStreamEvent> fromSectionStream(Scan<S, Section, Either<GroupingError, GroupedSections<Section>>> group, TableBuilder tableBuilder) {
        return this.sectionsToTables(group, tableBuilder).contramap((Function1 & Serializable)x$4 -> x$4.map((Function1 & Serializable)x$5 -> package$.MODULE$.Right().apply(x$5)));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ TransportStreamEvent $anonfun$sectionsToTables$8(PidStamped x0$4) {
        block5: {
            block4: {
                var3_1 = x0$4;
                if (var3_1 == null) ** GOTO lbl29
                pid = var3_1.pid();
                value = (Either)var3_1.value();
                var6_4 = false;
                var7_5 = null;
                var8_6 = value;
                if (!(var8_6 instanceof Left)) break block4;
                var9_7 = (Left)var8_6;
                e = (MpegError)var9_7.value();
                var2_9 = TransportStreamEvent$.MODULE$.error(pid, e);
                break block5;
            }
            if (!(var8_6 instanceof Right)) ** GOTO lbl-1000
            var6_4 = true;
            var7_5 = (Right)var8_6;
            var11_10 = (Either)var7_5.value();
            if (var11_10 instanceof Left) {
                var12_11 = (Left)var11_10;
                tsi = (TransportStreamIndex)var12_11.value();
                var2_9 = TransportStreamEvent$.MODULE$.metadata(tsi);
            } else if (var6_4 && (var14_13 = (Either)var7_5.value()) instanceof Right) {
                var15_14 = (Right)var14_13;
                tbl = (Table)var15_14.value();
                var2_9 = TransportStreamEvent$.MODULE$.table(pid, tbl);
            } else {
                throw new MatchError((Object)var8_6);
lbl29:
                // 1 sources

                throw new MatchError((Object)var3_1);
            }
        }
        var1_16 = var2_9;
        return var1_16;
    }

    private TransportStreamEvent$() {
    }
}

