/*
 * Decompiled with CFR 0.152.
 */
package fs2.protocols.mpeg.transport;

import fs2.Chunk;
import fs2.Chunk$;
import fs2.Scan;
import fs2.Scan$;
import fs2.protocols.mpeg.transport.AdaptationField;
import fs2.protocols.mpeg.transport.ContinuityCounter;
import fs2.protocols.mpeg.transport.DemultiplexerError;
import fs2.protocols.mpeg.transport.Packet;
import fs2.protocols.mpeg.transport.Pid;
import fs2.protocols.mpeg.transport.PidStamped;
import fs2.protocols.mpeg.transport.TransportStreamHeader;
import fs2.protocols.mpeg.transport.TransportStreamHeader$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scodec.Codec;
import scodec.Codec$;
import scodec.Transformer$;
import scodec.bits.BitVector;
import scodec.bits.BitVector$;
import scodec.codecs.DropUnits$;
import scodec.codecs.package;
import scodec.package;
import shapeless.;
import shapeless.Generic$;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.Lazy$;

public final class Packet$
implements Serializable {
    public static final Packet$ MODULE$ = new Packet$();

    public Vector<Packet> packetize(Pid pid, ContinuityCounter startingCountinuityCounter, BitVector section) {
        return this.go$1(true, startingCountinuityCounter, section, package$.MODULE$.Vector().empty(), pid);
    }

    public Vector<Packet> packetizeMany(Pid pid, ContinuityCounter startingCountinuityCounter, Vector<BitVector> sections) {
        return this.go$3(startingCountinuityCounter, BitVector$.MODULE$.empty(), sections, package$.MODULE$.Vector().empty(), pid);
    }

    public Packet payload(Pid pid, ContinuityCounter continuityCounter, Option<Object> payloadUnitStart, BitVector payload) {
        Pid thisPid = pid;
        ContinuityCounter thisContinuityCounter = continuityCounter;
        Option<Object> thisPayloadUnitStart = payloadUnitStart;
        int payloadLength = 8 * (payloadUnitStart.isDefined() ? 183 : 184);
        Predef$.MODULE$.require(payload.length() <= (long)payloadLength, (Function0 & Serializable)() -> new StringBuilder(29).append("payload too long; must be <= ").append(payloadLength).toString());
        BitVector thisPayload = payload.$plus$plus(BitVector$.MODULE$.high((long)payloadLength - payload.length()));
        return new Packet(new TransportStreamHeader(false, payloadUnitStart.isDefined(), false, thisPid, 0, 1, thisContinuityCounter), (Option<AdaptationField>)None$.MODULE$, thisPayloadUnitStart, (Option<BitVector>)new Some((Object)thisPayload));
    }

    public Codec<Packet> codec(Codec<AdaptationField> adaptationField) {
        Codec<TransportStreamHeader> inst$macro$33 = TransportStreamHeader$.MODULE$.codec();
        return package.StringEnrichedWithCodecContextSupport$.MODULE$.$bar$extension(scodec.codecs.package$.MODULE$.StringEnrichedWithCodecContextSupport("packet"), (Codec)scodec.package$.MODULE$.TransformSyntax((Object)scodec.codecs.package$.MODULE$.fixedSizeBytes(188L, package.ValueCodecEnrichedWithHListSupport$.MODULE$.flatPrepend$extension(scodec.package$.MODULE$.ValueCodecEnrichedWithHListSupport(package.StringEnrichedWithCodecContextSupport$.MODULE$.$bar$extension(scodec.codecs.package$.MODULE$.StringEnrichedWithCodecContextSupport("header"), Codec$.MODULE$.apply(Lazy$.MODULE$.apply((Function0 & Serializable)() -> inst$macro$33)))), (Function1 & Serializable)hdr -> {
            Codec codec2 = package.StringEnrichedWithCodecContextSupport$.MODULE$.$bar$extension(scodec.codecs.package$.MODULE$.StringEnrichedWithCodecContextSupport("adaptation_field"), scodec.codecs.package$.MODULE$.conditional(hdr.adaptationFieldIncluded(), (Function0 & Serializable)() -> adaptationField));
            Codec codec3 = package.StringEnrichedWithCodecContextSupport$.MODULE$.$bar$extension(scodec.codecs.package$.MODULE$.StringEnrichedWithCodecContextSupport("payload_start_ind"), scodec.codecs.package$.MODULE$.conditional(hdr.payloadUnitStartIndicator(), (Function0 & Serializable)() -> scodec.codecs.package$.MODULE$.uint8()));
            return package.HListCodecEnrichedWithHListSupport$.MODULE$.$colon$colon$extension(scodec.package$.MODULE$.HListCodecEnrichedWithHListSupport(package.ValueCodecEnrichedWithHListSupport$.MODULE$.$colon$colon$extension(scodec.package$.MODULE$.ValueCodecEnrichedWithHListSupport(package.StringEnrichedWithCodecContextSupport$.MODULE$.$bar$extension(scodec.codecs.package$.MODULE$.StringEnrichedWithCodecContextSupport("payload"), scodec.codecs.package$.MODULE$.conditional(hdr.payloadIncluded(), (Function0 & Serializable)() -> scodec.codecs.package$.MODULE$.bits()))), codec3)), codec2);
        })), Codec$.MODULE$.transformInstance()).as(Transformer$.MODULE$.fromGenericWithUnitsHListReverse(Generic$.MODULE$.instance((Function1 & Serializable)x0$9 -> {
            Packet packet = x0$9;
            if (packet != null) {
                TransportStreamHeader header$macro$54 = packet.header();
                Option<AdaptationField> adaptationField$macro$55 = packet.adaptationField();
                Option<Object> payloadUnitStart$macro$56 = packet.payloadUnitStart();
                Option<BitVector> payload$macro$57 = packet.payload();
                return new .colon.colon((Object)header$macro$54, (HList)new .colon.colon(adaptationField$macro$55, (HList)new .colon.colon(payloadUnitStart$macro$56, (HList)new .colon.colon(payload$macro$57, (HList)HNil$.MODULE$))));
            }
            throw new MatchError((Object)packet);
        }, (Function1 & Serializable)x0$10 -> {
            .colon.colon colon2 = x0$10;
            if (colon2 != null) {
                TransportStreamHeader header$macro$50 = (TransportStreamHeader)colon2.head();
                .colon.colon colon3 = (.colon.colon)colon2.tail();
                if (colon3 != null) {
                    Option adaptationField$macro$51 = (Option)colon3.head();
                    .colon.colon colon4 = (.colon.colon)colon3.tail();
                    if (colon4 != null) {
                        Option payloadUnitStart$macro$52 = (Option)colon4.head();
                        .colon.colon colon5 = (.colon.colon)colon4.tail();
                        if (colon5 != null) {
                            Option payload$macro$53 = (Option)colon5.head();
                            HNil hNil = (HNil)colon5.tail();
                            if (HNil$.MODULE$.equals(hNil)) {
                                return new Packet(header$macro$50, (Option<AdaptationField>)adaptationField$macro$51, (Option<Object>)payloadUnitStart$macro$52, (Option<BitVector>)payload$macro$53);
                            }
                        }
                    }
                }
            }
            throw new MatchError((Object)colon2);
        }), DropUnits$.MODULE$.non$minusempty$u0020K$u0020and$u0020L$u0020where$u0020head$u0020of$u0020K$u0020and$u0020L$u0020are$u0020same$u0020type(DropUnits$.MODULE$.non$minusempty$u0020K$u0020and$u0020L$u0020where$u0020head$u0020of$u0020K$u0020and$u0020L$u0020are$u0020same$u0020type(DropUnits$.MODULE$.non$minusempty$u0020K$u0020and$u0020L$u0020where$u0020head$u0020of$u0020K$u0020and$u0020L$u0020are$u0020same$u0020type(DropUnits$.MODULE$.non$minusempty$u0020K$u0020and$u0020L$u0020where$u0020head$u0020of$u0020K$u0020and$u0020L$u0020are$u0020same$u0020type(DropUnits$.MODULE$.base())))))));
    }

    public Scan<Map<Pid, ContinuityCounter>, Packet, Either<PidStamped<DemultiplexerError.Discontinuity>, Packet>> validateContinuity() {
        return Scan$.MODULE$.stateful((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(state, packet) -> {
            Pid pid = packet.header().pid();
            ContinuityCounter currentContinuityCounter = packet.header().continuityCounter();
            Option err = (Option)state.get((Object)pid).map((Function1 & Serializable)lastContinuityCounter -> {
                ContinuityCounter expectedContinuityCounter;
                ContinuityCounter continuityCounter = expectedContinuityCounter = packet.header().adaptationFieldControl() == 0 || packet.header().adaptationFieldControl() == 2 ? lastContinuityCounter : lastContinuityCounter.next();
                ContinuityCounter continuityCounter2 = currentContinuityCounter;
                if (!(continuityCounter != null ? !((Object)continuityCounter).equals(continuityCounter2) : continuityCounter2 != null)) {
                    return None$.MODULE$;
                }
                Left err = package$.MODULE$.Left().apply(new PidStamped<DemultiplexerError.Discontinuity>(pid, new DemultiplexerError.Discontinuity((ContinuityCounter)lastContinuityCounter, currentContinuityCounter, packet.header().adaptationFieldControl())));
                return new Some((Object)err);
            }).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
            Map newState = (Map)state.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pid), (Object)currentContinuityCounter));
            Chunk out = (Chunk)err.map((Function1 & Serializable)e -> Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Either[]{e, package$.MODULE$.Right().apply(packet)}))).getOrElse((Function0 & Serializable)() -> Chunk$.MODULE$.singleton((Object)package$.MODULE$.Right().apply(packet)));
            return new Tuple2((Object)newState, (Object)out);
        });
    }

    public Packet apply(TransportStreamHeader header, Option<AdaptationField> adaptationField, Option<Object> payloadUnitStart, Option<BitVector> payload) {
        return new Packet(header, adaptationField, payloadUnitStart, payload);
    }

    public Option<Tuple4<TransportStreamHeader, Option<AdaptationField>, Option<Object>, Option<BitVector>>> unapply(Packet x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.header(), x$0.adaptationField(), x$0.payloadUnitStart(), x$0.payload()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Packet$.class);
    }

    private final Vector go$1(boolean first, ContinuityCounter cc, BitVector remaining, Vector acc, Pid pid$1) {
        while (!remaining.isEmpty()) {
            Tuple2 tuple2 = remaining.splitAt(8L * (long)(first ? 183 : 184));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitVector packetData = (BitVector)tuple2._1();
            BitVector remData = (BitVector)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)packetData, (Object)remData);
            BitVector packetData2 = (BitVector)tuple22._1();
            BitVector remData2 = (BitVector)tuple22._2();
            acc = (Vector)acc.$colon$plus((Object)this.payload(pid$1, cc, (Option<Object>)(first ? new Some((Object)BoxesRunTime.boxToInteger((int)0)) : None$.MODULE$), packetData2));
            remaining = remData2;
            cc = cc.next();
            first = false;
        }
        return acc;
    }

    private final Tuple3 go$2(long needed, Vector remainingSections, BitVector acc) {
        while (!remainingSections.isEmpty()) {
            Tuple2 tuple2 = ((BitVector)remainingSections.head()).splitAt(needed);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitVector x = (BitVector)tuple2._1();
            BitVector rem = (BitVector)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)x, (Object)rem);
            BitVector x2 = (BitVector)tuple22._1();
            BitVector rem2 = (BitVector)tuple22._2();
            BitVector newAcc = acc.$plus$plus(x2);
            long left = needed - x2.size();
            if (left == 0L) {
                return new Tuple3((Object)newAcc, (Object)rem2, (Object)remainingSections.tail());
            }
            acc = newAcc;
            remainingSections = remainingSections.tail();
            needed = left;
        }
        return new Tuple3((Object)acc, (Object)BitVector$.MODULE$.empty(), (Object)package$.MODULE$.Vector().empty());
    }

    private final Tuple3 accumulateN$1(long n, Vector sections) {
        return this.go$2(n, sections, BitVector$.MODULE$.empty());
    }

    private final Vector go$3(ContinuityCounter cc, BitVector remaining, Vector remainingSections, Vector acc, Pid pid$2) {
        while (!remaining.isEmpty() || !remainingSections.isEmpty()) {
            Tuple2 tuple2;
            BitVector bitVector = remaining;
            Tuple3 tuple3 = this.accumulateN$1(1472L, (Vector)remainingSections.$plus$colon((Object)bitVector));
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            BitVector packetData = (BitVector)tuple3._1();
            BitVector overflow = (BitVector)tuple3._2();
            Vector remSections = (Vector)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)packetData, (Object)overflow, (Object)remSections);
            BitVector packetData2 = (BitVector)tuple32._1();
            BitVector overflow2 = (BitVector)tuple32._2();
            Vector remSections2 = (Vector)tuple32._3();
            None$ payloadUnitStart = remSections2.size() < remainingSections.size() ? new Some((Object)BoxesRunTime.boxToInteger((int)((int)(remaining.size() / 8L)))) : None$.MODULE$;
            Tuple2 tuple22 = tuple2 = payloadUnitStart.isDefined() ? new Tuple2((Object)packetData2.take(1464L), (Object)packetData2.drop(1464L).$plus$plus(overflow2)) : new Tuple2((Object)packetData2, (Object)overflow2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitVector adjPacketData = (BitVector)tuple2._1();
            BitVector adjOverflow = (BitVector)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)adjPacketData, (Object)adjOverflow);
            BitVector adjPacketData2 = (BitVector)tuple23._1();
            BitVector adjOverflow2 = (BitVector)tuple23._2();
            Packet packet = this.payload(pid$2, cc, (Option<Object>)payloadUnitStart, adjPacketData2);
            acc = (Vector)acc.$colon$plus((Object)packet);
            remainingSections = remSections2;
            remaining = adjOverflow2;
            cc = cc.next();
        }
        return acc;
    }

    private Packet$() {
    }
}

