/*
 * Decompiled with CFR 0.152.
 */
package fs2.protocols.mpeg.transport.psi;

import cats.data.Chain;
import cats.data.Chain$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Scan;
import fs2.Scan$;
import fs2.protocols.mpeg.MpegError;
import fs2.protocols.mpeg.MpegError$;
import fs2.protocols.mpeg.PesPacket;
import fs2.protocols.mpeg.transport.ContinuityCounter;
import fs2.protocols.mpeg.transport.Demultiplexer;
import fs2.protocols.mpeg.transport.Demultiplexer$;
import fs2.protocols.mpeg.transport.DemultiplexerError;
import fs2.protocols.mpeg.transport.Packet;
import fs2.protocols.mpeg.transport.Pid;
import fs2.protocols.mpeg.transport.PidStamped;
import fs2.protocols.mpeg.transport.PidStamped$;
import fs2.protocols.mpeg.transport.TransportStreamHeader;
import fs2.protocols.mpeg.transport.psi.GroupedSections;
import fs2.protocols.mpeg.transport.psi.GroupingError;
import fs2.protocols.mpeg.transport.psi.Section;
import fs2.protocols.mpeg.transport.psi.SectionCodec;
import fs2.protocols.mpeg.transport.psi.Table;
import fs2.protocols.mpeg.transport.psi.TableBuilder;
import fs2.protocols.mpeg.transport.psi.TransportStreamEvent;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.BitVector;

public final class TransportStreamEvent$ {
    public static final TransportStreamEvent$ MODULE$ = new TransportStreamEvent$();

    public TransportStreamEvent pes(Pid pid, PesPacket pes) {
        return new TransportStreamEvent.Pes(pid, pes);
    }

    public TransportStreamEvent table(Pid pid, Table table) {
        return new TransportStreamEvent.Table(pid, table);
    }

    public TransportStreamEvent scrambledPayload(Pid pid, BitVector content) {
        return new TransportStreamEvent.ScrambledPayload(pid, content);
    }

    public <A> TransportStreamEvent metadata(A md) {
        return new TransportStreamEvent.Metadata<A>((Option<Pid>)None$.MODULE$, md);
    }

    public <A> TransportStreamEvent metadata(Pid pid, A md) {
        return new TransportStreamEvent.Metadata<A>((Option<Pid>)new Some((Object)pid), md);
    }

    public TransportStreamEvent error(Pid pid, MpegError e) {
        return new TransportStreamEvent.Error((Option<Pid>)new Some((Object)pid), e);
    }

    public TransportStreamEvent error(Option<Pid> pid, MpegError e) {
        return new TransportStreamEvent.Error(pid, e);
    }

    private <S> Scan<Tuple2<Map<Pid, S>, TransportStreamIndex>, PidStamped<Either<MpegError, Section>>, TransportStreamEvent> sectionsToTables(Scan<S, Section, Either<GroupingError, GroupedSections<Section>>> group, TableBuilder tableBuilder) {
        Scan sectionsToTablesForPid = group.map((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                GroupingError e = (GroupingError)left.value();
                return package$.MODULE$.Left().apply((Object)e);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                GroupedSections gs = (GroupedSections)right.value();
                return tableBuilder.build(gs);
            }
            throw new MatchError((Object)either);
        });
        Scan sectionsToTables = Scan$.MODULE$.apply((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 != null) {
                Map state = (Map)tuple2._1();
                PidStamped pidStamped = (PidStamped)tuple2._2();
                if (pidStamped != null) {
                    Pid pid = pidStamped.pid();
                    Either e = (Either)pidStamped.value();
                    Either either = e;
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        Section section = (Section)right.value();
                        Object groupingState = state.getOrElse((Object)pid, (Function0 & Serializable)() -> group.initial());
                        Tuple2 tuple22 = sectionsToTablesForPid.transform(groupingState, (Object)section);
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Object s = tuple22._1();
                        Chunk out = (Chunk)tuple22._2();
                        Tuple2 tuple23 = new Tuple2(s, (Object)out);
                        Object s2 = tuple23._1();
                        Chunk out2 = (Chunk)tuple23._2();
                        return new Tuple2((Object)state.updated((Object)pid, s2), (Object)out2.map((Function1 & Serializable)x$2 -> new PidStamped<Either>(pid, (Either)x$2)));
                    }
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        MpegError err = (MpegError)left.value();
                        return new Tuple2((Object)state, (Object)Chunk$.MODULE$.singleton(new PidStamped<Left>(pid, package$.MODULE$.Left().apply((Object)err))));
                    }
                    throw new MatchError((Object)either);
                }
            }
            throw new MatchError((Object)tuple2);
        }, (Function1 & Serializable)state -> Chunk$.MODULE$.concat((Seq)((Chain)state.foldLeft((Object)Chain$.MODULE$.empty(), (Function2 & Serializable)(x0$3, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$3, x1$2);
            if (tuple2 != null) {
                Chain acc = (Chain)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Pid pid = (Pid)tuple22._1();
                    Object gs = tuple22._2();
                    return acc.$colon$plus((Object)sectionsToTablesForPid.onComplete(gs).map((Function1 & Serializable)x$3 -> new PidStamped<Either>(pid, (Either)x$3)));
                }
            }
            throw new MatchError((Object)tuple2);
        })).toList(), ClassTag$.MODULE$.apply(PidStamped.class)));
        return sectionsToTables.andThen(PidStamped$.MODULE$.preserve(MpegError$.MODULE$.passErrors(TransportStreamIndex$.MODULE$.build()))).map((Function1 & Serializable)x0$4 -> {
            PidStamped pidStamped = x0$4;
            if (pidStamped != null) {
                Either either;
                Pid pid = pidStamped.pid();
                Either value = (Either)pidStamped.value();
                boolean bl = false;
                Right right = null;
                Either either2 = value;
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    MpegError e = (MpegError)left.value();
                    return MODULE$.error(pid, e);
                }
                if (either2 instanceof Right) {
                    bl = true;
                    right = (Right)either2;
                    Either either3 = (Either)right.value();
                    if (either3 instanceof Left) {
                        Left left = (Left)either3;
                        TransportStreamIndex tsi = (TransportStreamIndex)left.value();
                        return MODULE$.metadata(tsi);
                    }
                }
                if (bl && (either = (Either)right.value()) instanceof Right) {
                    Right right2 = (Right)either;
                    Table tbl = (Table)right2.value();
                    return MODULE$.table(pid, tbl);
                }
                throw new MatchError((Object)either2);
            }
            throw new MatchError((Object)pidStamped);
        });
    }

    public <S> Scan<Tuple2<Tuple2<Map<Pid, ContinuityCounter>, Demultiplexer.State>, Tuple2<Map<Pid, S>, TransportStreamIndex>>, Packet, TransportStreamEvent> fromPacketStream(SectionCodec sectionCodec, Scan<S, Section, Either<GroupingError, GroupedSections<Section>>> group, TableBuilder tableBuilder) {
        Scan demuxed = Demultiplexer$.MODULE$.demultiplex(sectionCodec).andThen(this.sectionsToTables(group, tableBuilder).semipass((Function1 & Serializable)x0$1 -> {
            PidStamped pidStamped = x0$1;
            if (pidStamped != null) {
                Right right;
                Demultiplexer.Result result;
                Pid pid = pidStamped.pid();
                Either either = (Either)pidStamped.value();
                if (either instanceof Right && (result = (Demultiplexer.Result)(right = (Right)either).value()) instanceof Demultiplexer.SectionResult) {
                    Demultiplexer.SectionResult sectionResult = (Demultiplexer.SectionResult)result;
                    Section section = sectionResult.section();
                    return package$.MODULE$.Right().apply(new PidStamped<Right>(pid, package$.MODULE$.Right().apply((Object)section)));
                }
            }
            if (pidStamped != null) {
                Right right;
                Demultiplexer.Result result;
                Pid pid = pidStamped.pid();
                Either either = (Either)pidStamped.value();
                if (either instanceof Right && (result = (Demultiplexer.Result)(right = (Right)either).value()) instanceof Demultiplexer.PesPacketResult) {
                    Demultiplexer.PesPacketResult pesPacketResult = (Demultiplexer.PesPacketResult)result;
                    PesPacket p = pesPacketResult.body();
                    return package$.MODULE$.Left().apply((Object)MODULE$.pes(pid, p));
                }
            }
            if (pidStamped != null) {
                Pid pid = pidStamped.pid();
                Either either = (Either)pidStamped.value();
                if (either instanceof Left) {
                    Left left = (Left)either;
                    DemultiplexerError e = (DemultiplexerError)left.value();
                    return package$.MODULE$.Right().apply(new PidStamped<Left>(pid, package$.MODULE$.Left().apply((Object)e.toMpegError())));
                }
            }
            throw new MatchError((Object)pidStamped);
        }));
        return demuxed.semipass((Function1 & Serializable)x0$2 -> {
            Packet packet = x0$2;
            if (packet != null) {
                TransportStreamHeader header = packet.header();
                Option<BitVector> option = packet.payload();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BitVector payload = (BitVector)some.value();
                    if (header.scramblingControl() != 0) {
                        return package$.MODULE$.Left().apply((Object)MODULE$.scrambledPayload(header.pid(), payload));
                    }
                }
            }
            if (packet != null) {
                return package$.MODULE$.Right().apply((Object)packet);
            }
            throw new MatchError((Object)packet);
        });
    }

    public <S> Scan<Tuple2<Map<Pid, S>, TransportStreamIndex>, PidStamped<Section>, TransportStreamEvent> fromSectionStream(Scan<S, Section, Either<GroupingError, GroupedSections<Section>>> group, TableBuilder tableBuilder) {
        return this.sectionsToTables(group, tableBuilder).contramap((Function1 & Serializable)x$4 -> x$4.map((Function1 & Serializable)x$5 -> package$.MODULE$.Right().apply(x$5)));
    }

    private TransportStreamEvent$() {
    }
}

