/*
 * Decompiled with CFR 0.152.
 */
package fs2.protocols.mpeg.transport;

import fs2.Chunk;
import fs2.Chunk$;
import fs2.Scan;
import fs2.Scan$;
import fs2.protocols.mpeg.transport.AdaptationField;
import fs2.protocols.mpeg.transport.ContinuityCounter;
import fs2.protocols.mpeg.transport.DemultiplexerError;
import fs2.protocols.mpeg.transport.DemultiplexerError$Discontinuity$;
import fs2.protocols.mpeg.transport.Packet;
import fs2.protocols.mpeg.transport.Pid;
import fs2.protocols.mpeg.transport.PidStamped;
import fs2.protocols.mpeg.transport.PidStamped$;
import fs2.protocols.mpeg.transport.TransportStreamHeader;
import fs2.protocols.mpeg.transport.TransportStreamHeader$;
import java.io.Serializable;
import scala.DummyImplicit$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scodec.Codec;
import scodec.Codec$;
import scodec.Iso$;
import scodec.bits.BitVector;
import scodec.bits.BitVector$;
import scodec.codecs.codecs$package$;

public final class Packet$
implements Mirror.Product,
Serializable {
    public static final Packet$ MODULE$ = new Packet$();

    private Packet$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Packet$.class);
    }

    public Packet apply(TransportStreamHeader header, Option<AdaptationField> adaptationField, Option<Object> payloadUnitStart, Option<BitVector> payload) {
        return new Packet(header, adaptationField, payloadUnitStart, payload);
    }

    public Packet unapply(Packet x$1) {
        return x$1;
    }

    public String toString() {
        return "Packet";
    }

    public Vector<Packet> packetize(Pid pid, ContinuityCounter startingCountinuityCounter, BitVector section) {
        return this.go$1(pid, true, startingCountinuityCounter, section, package$.MODULE$.Vector().empty());
    }

    public Vector<Packet> packetizeMany(Pid pid, ContinuityCounter startingCountinuityCounter, Vector<BitVector> sections) {
        return this.go$3(pid, startingCountinuityCounter, BitVector$.MODULE$.empty(), sections, package$.MODULE$.Vector().empty());
    }

    public Packet payload(Pid pid, ContinuityCounter continuityCounter, Option<Object> payloadUnitStart, BitVector payload) {
        Pid thisPid = pid;
        ContinuityCounter thisContinuityCounter = continuityCounter;
        Option<Object> thisPayloadUnitStart = payloadUnitStart;
        int payloadLength = 8 * (payloadUnitStart.isDefined() ? 183 : 184);
        Predef$.MODULE$.require(payload.length() <= (long)payloadLength, () -> this.payload$$anonfun$1(payloadLength));
        BitVector thisPayload = payload.$plus$plus(BitVector$.MODULE$.high((long)payloadLength - payload.length()));
        return this.apply(TransportStreamHeader$.MODULE$.apply(false, payloadUnitStart.isDefined(), false, thisPid, 0, 1, thisContinuityCounter), (Option<AdaptationField>)None$.MODULE$, thisPayloadUnitStart, (Option<BitVector>)Some$.MODULE$.apply((Object)thisPayload));
    }

    public Codec<Packet> codec(Codec<AdaptationField> adaptationField) {
        return codecs$package$.MODULE$.$bar("packet", codecs$package$.MODULE$.fixedSizeBytes(188L, Codec$.MODULE$.flatPrepend(codecs$package$.MODULE$.$bar("header", TransportStreamHeader$.MODULE$.codec()), (Function1 & Serializable)hdr -> {
            Codec codec = codecs$package$.MODULE$.$bar("adaptation_field", codecs$package$.MODULE$.conditional(hdr.adaptationFieldIncluded(), () -> this.$anonfun$1(adaptationField)));
            Codec codec2 = codecs$package$.MODULE$.$bar("payload_start_ind", codecs$package$.MODULE$.conditional(hdr.payloadUnitStartIndicator(), this::$anonfun$2));
            return Codec$.MODULE$.$colon$colon(Codec$.MODULE$.$colon$colon(codecs$package$.MODULE$.$bar("payload", codecs$package$.MODULE$.conditional(hdr.payloadIncluded(), this::codec$$anonfun$1$$anonfun$1)), codec2, DummyImplicit$.MODULE$.dummyImplicit()), codec);
        })).as(Iso$.MODULE$.product((Mirror.Product)this)));
    }

    public Scan<Map<Pid, ContinuityCounter>, Packet, Either<PidStamped<DemultiplexerError.Discontinuity>, Packet>> validateContinuity() {
        return Scan$.MODULE$.stateful((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(state, packet) -> {
            Pid pid = packet.header().pid();
            ContinuityCounter currentContinuityCounter = packet.header().continuityCounter();
            Option err = (Option)state.get((Object)pid).map((Function1 & Serializable)lastContinuityCounter -> {
                None$ none$;
                ContinuityCounter expectedContinuityCounter;
                ContinuityCounter continuityCounter = expectedContinuityCounter = packet.header().adaptationFieldControl() == 0 || packet.header().adaptationFieldControl() == 2 ? lastContinuityCounter : lastContinuityCounter.next();
                ContinuityCounter continuityCounter2 = currentContinuityCounter;
                if (!(continuityCounter != null ? !((Object)continuityCounter).equals(continuityCounter2) : continuityCounter2 != null)) {
                    none$ = None$.MODULE$;
                } else {
                    Left err = package$.MODULE$.Left().apply(PidStamped$.MODULE$.apply(pid, DemultiplexerError$Discontinuity$.MODULE$.apply((ContinuityCounter)lastContinuityCounter, currentContinuityCounter, packet.header().adaptationFieldControl())));
                    none$ = Some$.MODULE$.apply((Object)err);
                }
                return none$;
            }).getOrElse(this::$anonfun$4);
            Pid pid2 = (Pid)Predef$.MODULE$.ArrowAssoc((Object)pid);
            Map newState = (Map)state.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)pid2, (Object)currentContinuityCounter));
            Chunk out = (Chunk)err.map((Function1 & Serializable)e -> Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Either[]{e, package$.MODULE$.Right().apply(packet)}))).getOrElse(() -> this.$anonfun$6(packet));
            return Tuple2$.MODULE$.apply((Object)newState, (Object)out);
        });
    }

    public Packet fromProduct(Product x$0) {
        return new Packet((TransportStreamHeader)x$0.productElement(0), (Option<AdaptationField>)((Option)x$0.productElement(1)), (Option<Object>)((Option)x$0.productElement(2)), (Option<BitVector>)((Option)x$0.productElement(3)));
    }

    private final Vector go$1(Pid pid$1, boolean first, ContinuityCounter cc, BitVector remaining, Vector acc) {
        Vector vector = acc;
        BitVector bitVector = remaining;
        ContinuityCounter continuityCounter = cc;
        boolean bl = first;
        while (!bitVector.isEmpty()) {
            Tuple2 tuple2 = bitVector.splitAt(8L * (long)(bl ? 183 : 184));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitVector packetData = (BitVector)tuple2._1();
            BitVector remData = (BitVector)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)packetData, (Object)remData);
            BitVector packetData2 = (BitVector)tuple22._1();
            BitVector remData2 = (BitVector)tuple22._2();
            boolean bl2 = false;
            ContinuityCounter continuityCounter2 = continuityCounter.next();
            BitVector bitVector2 = remData2;
            Vector vector2 = (Vector)vector.$colon$plus((Object)this.payload(pid$1, continuityCounter, (Option<Object>)(bl ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)) : None$.MODULE$), packetData2));
            bl = bl2;
            continuityCounter = continuityCounter2;
            bitVector = bitVector2;
            vector = vector2;
        }
        return vector;
    }

    private final Tuple3 go$2(long needed, Vector remainingSections, BitVector acc) {
        Tuple3 tuple3;
        BitVector bitVector = acc;
        Vector vector = remainingSections;
        long l = needed;
        while (true) {
            if (vector.isEmpty()) {
                tuple3 = Tuple3$.MODULE$.apply((Object)bitVector, (Object)BitVector$.MODULE$.empty(), (Object)package$.MODULE$.Vector().empty());
                break;
            }
            Tuple2 tuple2 = ((BitVector)vector.head()).splitAt(l);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BitVector x = (BitVector)tuple2._1();
            BitVector rem = (BitVector)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)x, (Object)rem);
            BitVector x2 = (BitVector)tuple22._1();
            BitVector rem2 = (BitVector)tuple22._2();
            BitVector newAcc = bitVector.$plus$plus(x2);
            long left = l - x2.size();
            if (left == 0L) {
                tuple3 = Tuple3$.MODULE$.apply((Object)newAcc, (Object)rem2, (Object)vector.tail());
                break;
            }
            long l2 = left;
            Vector vector2 = vector.tail();
            BitVector bitVector2 = newAcc;
            l = l2;
            vector = vector2;
            bitVector = bitVector2;
        }
        return tuple3;
    }

    private final Tuple3 accumulateN$1(long n, Vector sections) {
        return this.go$2(n, sections, BitVector$.MODULE$.empty());
    }

    private final Vector go$3(Pid pid$2, ContinuityCounter cc, BitVector remaining, Vector remainingSections, Vector acc) {
        Vector vector = acc;
        Vector vector2 = remainingSections;
        BitVector bitVector = remaining;
        ContinuityCounter continuityCounter = cc;
        while (!bitVector.isEmpty() || !vector2.isEmpty()) {
            Tuple3 tuple3 = this.accumulateN$1(1472L, (Vector)vector2.$plus$colon((Object)bitVector));
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            BitVector packetData = (BitVector)tuple3._1();
            BitVector overflow = (BitVector)tuple3._2();
            Vector remSections = (Vector)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)packetData, (Object)overflow, (Object)remSections);
            BitVector packetData2 = (BitVector)tuple32._1();
            BitVector overflow2 = (BitVector)tuple32._2();
            Vector remSections2 = (Vector)tuple32._3();
            None$ payloadUnitStart = remSections2.size() < vector2.size() ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)(bitVector.size() / 8L)))) : None$.MODULE$;
            Tuple2 tuple2 = payloadUnitStart.isDefined() ? Tuple2$.MODULE$.apply((Object)packetData2.take(1464L), (Object)packetData2.drop(1464L).$plus$plus(overflow2)) : Tuple2$.MODULE$.apply((Object)packetData2, (Object)overflow2);
            BitVector adjPacketData = (BitVector)tuple2._1();
            BitVector adjOverflow = (BitVector)tuple2._2();
            Packet packet = this.payload(pid$2, continuityCounter, (Option<Object>)payloadUnitStart, adjPacketData);
            ContinuityCounter continuityCounter2 = continuityCounter.next();
            BitVector bitVector2 = adjOverflow;
            Vector vector3 = remSections2;
            Vector vector4 = (Vector)vector.$colon$plus((Object)packet);
            continuityCounter = continuityCounter2;
            bitVector = bitVector2;
            vector2 = vector3;
            vector = vector4;
        }
        return vector;
    }

    private final String payload$$anonfun$1(int payloadLength$1) {
        return new StringBuilder(29).append("payload too long; must be <= ").append(payloadLength$1).toString();
    }

    private final Codec $anonfun$1(Codec adaptationField$2) {
        return adaptationField$2;
    }

    private final Codec $anonfun$2() {
        return codecs$package$.MODULE$.uint8();
    }

    private final Codec codec$$anonfun$1$$anonfun$1() {
        return codecs$package$.MODULE$.bits();
    }

    private final None$ $anonfun$4() {
        return None$.MODULE$;
    }

    private final Chunk $anonfun$6(Packet packet$3) {
        return Chunk$.MODULE$.singleton((Object)package$.MODULE$.Right().apply((Object)packet$3));
    }
}

