/*
 * Decompiled with CFR 0.152.
 */
package fs2.protocols.mpeg.transport.psi;

import cats.data.Chain;
import cats.data.Chain$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Scan;
import fs2.Scan$;
import fs2.protocols.mpeg.MpegError;
import fs2.protocols.mpeg.MpegError$;
import fs2.protocols.mpeg.PesPacket;
import fs2.protocols.mpeg.transport.AdaptationField;
import fs2.protocols.mpeg.transport.ContinuityCounter;
import fs2.protocols.mpeg.transport.Demultiplexer;
import fs2.protocols.mpeg.transport.Demultiplexer$;
import fs2.protocols.mpeg.transport.Demultiplexer$PesPacketResult$;
import fs2.protocols.mpeg.transport.Demultiplexer$SectionResult$;
import fs2.protocols.mpeg.transport.DemultiplexerError;
import fs2.protocols.mpeg.transport.Packet;
import fs2.protocols.mpeg.transport.Packet$;
import fs2.protocols.mpeg.transport.Pid;
import fs2.protocols.mpeg.transport.PidStamped;
import fs2.protocols.mpeg.transport.PidStamped$;
import fs2.protocols.mpeg.transport.TransportStreamHeader;
import fs2.protocols.mpeg.transport.psi.GroupedSections;
import fs2.protocols.mpeg.transport.psi.GroupingError;
import fs2.protocols.mpeg.transport.psi.Section;
import fs2.protocols.mpeg.transport.psi.SectionCodec;
import fs2.protocols.mpeg.transport.psi.Table;
import fs2.protocols.mpeg.transport.psi.TableBuilder;
import fs2.protocols.mpeg.transport.psi.TableBuildingError;
import fs2.protocols.mpeg.transport.psi.TransportStreamEvent;
import fs2.protocols.mpeg.transport.psi.TransportStreamEvent$Error$;
import fs2.protocols.mpeg.transport.psi.TransportStreamEvent$Metadata$;
import fs2.protocols.mpeg.transport.psi.TransportStreamEvent$Pes$;
import fs2.protocols.mpeg.transport.psi.TransportStreamEvent$ScrambledPayload$;
import fs2.protocols.mpeg.transport.psi.TransportStreamEvent$Table$;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.BitVector;

public final class TransportStreamEvent$
implements Serializable {
    public static final TransportStreamEvent$Pes$ Pes;
    public static final TransportStreamEvent$Table$ Table;
    public static final TransportStreamEvent$ScrambledPayload$ ScrambledPayload;
    public static final TransportStreamEvent$Metadata$ Metadata;
    public static final TransportStreamEvent$Error$ Error;
    public static final TransportStreamEvent$ MODULE$;

    private TransportStreamEvent$() {
    }

    static {
        MODULE$ = new TransportStreamEvent$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransportStreamEvent$.class);
    }

    public TransportStreamEvent pes(Pid pid, PesPacket pes) {
        return TransportStreamEvent$Pes$.MODULE$.apply(pid, pes);
    }

    public TransportStreamEvent table(Pid pid, Table table) {
        return TransportStreamEvent$Table$.MODULE$.apply(pid, table);
    }

    public TransportStreamEvent scrambledPayload(Pid pid, BitVector content) {
        return TransportStreamEvent$ScrambledPayload$.MODULE$.apply(pid, content);
    }

    public <A> TransportStreamEvent metadata(A md) {
        return TransportStreamEvent$Metadata$.MODULE$.apply((Option<Pid>)None$.MODULE$, md);
    }

    public <A> TransportStreamEvent metadata(Pid pid, A md) {
        return TransportStreamEvent$Metadata$.MODULE$.apply((Option<Pid>)Some$.MODULE$.apply((Object)pid), md);
    }

    public TransportStreamEvent error(Pid pid, MpegError e) {
        return TransportStreamEvent$Error$.MODULE$.apply((Option<Pid>)Some$.MODULE$.apply((Object)pid), e);
    }

    public TransportStreamEvent error(Option<Pid> pid, MpegError e) {
        return TransportStreamEvent$Error$.MODULE$.apply(pid, e);
    }

    private <S> Scan<Tuple2<Map<Pid, S>, TransportStreamIndex>, PidStamped<Either<MpegError, Section>>, TransportStreamEvent> sectionsToTables(Scan<S, Section, Either<GroupingError, GroupedSections<Section>>> group, TableBuilder tableBuilder) {
        Scan sectionsToTablesForPid = group.map((Function1 & Serializable)x$1 -> {
            Either<TableBuildingError, Table> either;
            Either either2 = x$1;
            if (either2 instanceof Left) {
                GroupingError e = (GroupingError)((Left)either2).value();
                either = package$.MODULE$.Left().apply((Object)e);
            } else if (either2 instanceof Right) {
                GroupedSections gs = (GroupedSections)((Right)either2).value();
                either = tableBuilder.build(gs);
            } else {
                throw new MatchError((Object)either2);
            }
            return either;
        });
        Scan sectionsToTables = Scan$.MODULE$.apply((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            PidStamped pidStamped = (PidStamped)tuple22._2();
            Map state = (Map)tuple22._1();
            if (pidStamped == null) throw new MatchError((Object)tuple22);
            PidStamped pidStamped2 = PidStamped$.MODULE$.unapply(pidStamped);
            Pid pid = pidStamped2._1();
            Either either = (Either)pidStamped2._2();
            Pid pid2 = pid;
            Either e = either;
            Either either2 = e;
            if (either2 instanceof Right) {
                Section section = (Section)((Right)either2).value();
                Object groupingState = state.getOrElse((Object)pid2, () -> this.$anonfun$3(group));
                Tuple2 tuple23 = sectionsToTablesForPid.transform(groupingState, (Object)section);
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                Object s = tuple23._1();
                Chunk out = (Chunk)tuple23._2();
                Tuple2 tuple24 = Tuple2$.MODULE$.apply(s, (Object)out);
                Object s2 = tuple24._1();
                Chunk out2 = (Chunk)tuple24._2();
                tuple2 = Tuple2$.MODULE$.apply((Object)state.updated((Object)pid2, s2), (Object)out2.map((Function1 & Serializable)_$1 -> PidStamped$.MODULE$.apply(pid2, _$1)));
                return tuple2;
            } else {
                if (!(either2 instanceof Left)) throw new MatchError((Object)either2);
                MpegError err = (MpegError)((Left)either2).value();
                tuple2 = Tuple2$.MODULE$.apply((Object)state, (Object)Chunk$.MODULE$.singleton(PidStamped$.MODULE$.apply(pid2, package$.MODULE$.Left().apply((Object)err))));
            }
            return tuple2;
        }, (Function1 & Serializable)state -> Chunk$.MODULE$.concat((Seq)((Chain)state.foldLeft((Object)Chain$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Chain acc;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._2();
                    acc = (Chain)tuple22._1();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Pid pid = (Pid)tuple2._1();
            Object gs = tuple2._2();
            return acc.$colon$plus((Object)sectionsToTablesForPid.onComplete(gs).map((Function1 & Serializable)_$2 -> PidStamped$.MODULE$.apply(pid, _$2)));
        })).toList(), ClassTag$.MODULE$.apply(PidStamped.class)));
        return sectionsToTables.andThen(PidStamped$.MODULE$.preserve(MpegError$.MODULE$.passErrors(TransportStreamIndex$.MODULE$.build()))).map((Function1 & Serializable)x$1 -> {
            TransportStreamEvent transportStreamEvent;
            PidStamped pidStamped = x$1;
            if (pidStamped == null) throw new MatchError((Object)pidStamped);
            PidStamped pidStamped2 = PidStamped$.MODULE$.unapply(pidStamped);
            Pid pid = pidStamped2._1();
            Either either = (Either)pidStamped2._2();
            Pid pid2 = pid;
            Either value = either;
            Either either2 = value;
            if (either2 instanceof Left) {
                MpegError e = (MpegError)((Left)either2).value();
                transportStreamEvent = this.error(pid2, e);
                return transportStreamEvent;
            } else {
                if (!(either2 instanceof Right)) throw new MatchError((Object)either2);
                Either either3 = (Either)((Right)either2).value();
                if (either3 instanceof Left) {
                    TransportStreamIndex tsi = (TransportStreamIndex)((Left)either3).value();
                    transportStreamEvent = this.metadata(tsi);
                    return transportStreamEvent;
                } else {
                    if (!(either3 instanceof Right)) throw new MatchError((Object)either2);
                    Table tbl = (Table)((Right)either3).value();
                    transportStreamEvent = this.table(pid2, tbl);
                }
            }
            return transportStreamEvent;
        });
    }

    public <S> Scan<Tuple2<Tuple2<Map<Pid, ContinuityCounter>, Demultiplexer.State>, Tuple2<Map<Pid, S>, TransportStreamIndex>>, Packet, TransportStreamEvent> fromPacketStream(SectionCodec sectionCodec, Scan<S, Section, Either<GroupingError, GroupedSections<Section>>> group, TableBuilder tableBuilder) {
        Scan demuxed = Demultiplexer$.MODULE$.demultiplex(sectionCodec).andThen(this.sectionsToTables(group, tableBuilder).semipass((Function1 & Serializable)x$1 -> {
            Right right;
            PidStamped pidStamped = x$1;
            if (pidStamped == null) throw new MatchError((Object)pidStamped);
            PidStamped pidStamped2 = PidStamped$.MODULE$.unapply(pidStamped);
            Pid pid = pidStamped2._1();
            Either either = (Either)pidStamped2._2();
            Pid pid2 = pid;
            if (either instanceof Right) {
                Demultiplexer.Result result = (Demultiplexer.Result)((Right)either).value();
                if (result instanceof Demultiplexer.SectionResult) {
                    Section section;
                    Demultiplexer.SectionResult sectionResult = Demultiplexer$SectionResult$.MODULE$.unapply((Demultiplexer.SectionResult)result);
                    Section section2 = section = sectionResult._1();
                    right = package$.MODULE$.Right().apply(PidStamped$.MODULE$.apply(pid2, package$.MODULE$.Right().apply((Object)section2)));
                    return right;
                }
                Pid pid3 = pid;
                if (result instanceof Demultiplexer.PesPacketResult) {
                    PesPacket pesPacket;
                    Demultiplexer.PesPacketResult pesPacketResult = Demultiplexer$PesPacketResult$.MODULE$.unapply((Demultiplexer.PesPacketResult)result);
                    PesPacket p = pesPacket = pesPacketResult._1();
                    right = package$.MODULE$.Left().apply((Object)this.pes(pid3, p));
                    return right;
                }
            }
            Pid pid4 = pid;
            if (!(either instanceof Left)) throw new MatchError((Object)pidStamped);
            DemultiplexerError e = (DemultiplexerError)((Left)either).value();
            right = package$.MODULE$.Right().apply(PidStamped$.MODULE$.apply(pid4, package$.MODULE$.Left().apply((Object)e.toMpegError())));
            return right;
        }));
        return demuxed.semipass((Function1 & Serializable)x$1 -> {
            Right right;
            Packet packet = x$1;
            if (packet == null) throw new MatchError((Object)packet);
            Packet packet2 = Packet$.MODULE$.unapply(packet);
            TransportStreamHeader transportStreamHeader = packet2._1();
            Option<AdaptationField> option = packet2._2();
            Option<Object> option2 = packet2._3();
            Option<BitVector> option3 = packet2._4();
            TransportStreamHeader header = transportStreamHeader;
            if (option3 instanceof Some) {
                BitVector payload = (BitVector)((Some)option3).value();
                if (header.scramblingControl() != 0) {
                    right = package$.MODULE$.Left().apply((Object)this.scrambledPayload(header.pid(), payload));
                    return right;
                }
            }
            Packet p = packet;
            right = package$.MODULE$.Right().apply((Object)p);
            return right;
        });
    }

    public <S> Scan<Tuple2<Map<Pid, S>, TransportStreamIndex>, PidStamped<Section>, TransportStreamEvent> fromSectionStream(Scan<S, Section, Either<GroupingError, GroupedSections<Section>>> group, TableBuilder tableBuilder) {
        return this.sectionsToTables(group, tableBuilder).contramap((Function1 & Serializable)_$3 -> _$3.map((Function1 & Serializable)_$4 -> package$.MODULE$.Right().apply(_$4)));
    }

    private final Object $anonfun$3(Scan group$2) {
        return group$2.initial();
    }
}

