/*
 * Decompiled with CFR 0.152.
 */
package fs2.protocols.mpeg.transport.psi;

import fs2.Scan;
import fs2.protocols.mpeg.transport.Pid;
import fs2.protocols.mpeg.transport.ProgramNumber;
import fs2.protocols.mpeg.transport.psi.ConditionalAccessTable;
import fs2.protocols.mpeg.transport.psi.ProgramAssociationTable;
import fs2.protocols.mpeg.transport.psi.ProgramMapRecord;
import fs2.protocols.mpeg.transport.psi.ProgramMapTable;
import fs2.protocols.mpeg.transport.psi.StreamType;
import fs2.protocols.mpeg.transport.psi.Table;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex$;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex$DefaultTransportStreamIndex$;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex$LookupError$;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex$LookupError$MissingProgramAssociation$;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex$LookupError$UnknownProgram$;
import fs2.protocols.mpeg.transport.psi.TransportStreamIndex$LookupError$UnknownStreamType$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public abstract class TransportStreamIndex {
    public static Scan<TransportStreamIndex, Table, Either<TransportStreamIndex, Table>> build() {
        return TransportStreamIndex$.MODULE$.build();
    }

    public static TransportStreamIndex empty() {
        return TransportStreamIndex$.MODULE$.empty();
    }

    public static int ordinal(TransportStreamIndex transportStreamIndex) {
        return TransportStreamIndex$.MODULE$.ordinal(transportStreamIndex);
    }

    public abstract Option<ProgramAssociationTable> pat();

    public abstract Option<ConditionalAccessTable> cat();

    public abstract Either<LookupError, ProgramMapTable> pmt(ProgramNumber var1);

    public Either<LookupError, List<ProgramMapRecord>> programMapRecords(ProgramNumber program, StreamType streamType) {
        return this.pat().toRight(TransportStreamIndex::programMapRecords$$anonfun$1).flatMap((Function1 & Serializable)p -> p.programByPid().get((Object)program).toRight(TransportStreamIndex::programMapRecords$$anonfun$2$$anonfun$1).flatMap((Function1 & Serializable)x$1 -> {
            Pid pid = x$1;
            return this.pmt(program).flatMap((Function1 & Serializable)q -> q.componentStreamMapping().get((Object)streamType).toRight(TransportStreamIndex::programMapRecords$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1).map((Function1 & Serializable)pmrs -> pmrs));
        }));
    }

    public Either<LookupError, ProgramMapRecord> programManRecord(ProgramNumber program, StreamType streamType) {
        return this.programMapRecords(program, streamType).map((Function1 & Serializable)_$1 -> (ProgramMapRecord)_$1.head());
    }

    public abstract TransportStreamIndex withPat(ProgramAssociationTable var1);

    public abstract TransportStreamIndex withPmt(ProgramMapTable var1);

    public abstract TransportStreamIndex withCat(ConditionalAccessTable var1);

    private static final TransportStreamIndex$LookupError$MissingProgramAssociation$ programMapRecords$$anonfun$1() {
        return TransportStreamIndex$LookupError$MissingProgramAssociation$.MODULE$;
    }

    private static final TransportStreamIndex$LookupError$UnknownProgram$ programMapRecords$$anonfun$2$$anonfun$1() {
        return TransportStreamIndex$LookupError$UnknownProgram$.MODULE$;
    }

    private static final TransportStreamIndex$LookupError$UnknownStreamType$ programMapRecords$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1() {
        return TransportStreamIndex$LookupError$UnknownStreamType$.MODULE$;
    }

    public static class DefaultTransportStreamIndex
    extends TransportStreamIndex
    implements Product,
    Serializable {
        private final Option pat;
        private final Option cat;
        private final Map pmts;

        public static DefaultTransportStreamIndex apply(Option<ProgramAssociationTable> option, Option<ConditionalAccessTable> option2, Map<ProgramNumber, ProgramMapTable> map) {
            return TransportStreamIndex$DefaultTransportStreamIndex$.MODULE$.apply(option, option2, map);
        }

        public static DefaultTransportStreamIndex fromProduct(Product product) {
            return TransportStreamIndex$DefaultTransportStreamIndex$.MODULE$.fromProduct(product);
        }

        public static DefaultTransportStreamIndex unapply(DefaultTransportStreamIndex defaultTransportStreamIndex) {
            return TransportStreamIndex$DefaultTransportStreamIndex$.MODULE$.unapply(defaultTransportStreamIndex);
        }

        public DefaultTransportStreamIndex(Option<ProgramAssociationTable> pat, Option<ConditionalAccessTable> cat, Map<ProgramNumber, ProgramMapTable> pmts) {
            this.pat = pat;
            this.cat = cat;
            this.pmts = pmts;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DefaultTransportStreamIndex)) return false;
            DefaultTransportStreamIndex defaultTransportStreamIndex = (DefaultTransportStreamIndex)object;
            Option<ProgramAssociationTable> option = this.pat();
            Option<ProgramAssociationTable> option2 = defaultTransportStreamIndex.pat();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<ConditionalAccessTable> option3 = this.cat();
            Option<ConditionalAccessTable> option4 = defaultTransportStreamIndex.cat();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Map<ProgramNumber, ProgramMapTable> map = this.pmts();
            Map<ProgramNumber, ProgramMapTable> map2 = defaultTransportStreamIndex.pmts();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!defaultTransportStreamIndex.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DefaultTransportStreamIndex;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "DefaultTransportStreamIndex";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "pat";
                    break;
                }
                case 1: {
                    string = "cat";
                    break;
                }
                case 2: {
                    string = "pmts";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public Option<ProgramAssociationTable> pat() {
            return this.pat;
        }

        @Override
        public Option<ConditionalAccessTable> cat() {
            return this.cat;
        }

        public Map<ProgramNumber, ProgramMapTable> pmts() {
            return this.pmts;
        }

        @Override
        public Either<LookupError, ProgramMapTable> pmt(ProgramNumber prg) {
            return this.pmts().get((Object)prg).toRight(this::pmt$$anonfun$1);
        }

        @Override
        public TransportStreamIndex withPat(ProgramAssociationTable pat) {
            Set programs = pat.programByPid().keys().toSet();
            Some some = Some$.MODULE$.apply((Object)pat);
            Map map = this.pmts().view().filter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ProgramNumber k = (ProgramNumber)tuple2._1();
                return programs.apply((Object)k);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Option<ConditionalAccessTable> option = this.copy$default$2();
            return this.copy((Option<ProgramAssociationTable>)some, option, (Map<ProgramNumber, ProgramMapTable>)map);
        }

        @Override
        public TransportStreamIndex withPmt(ProgramMapTable pmt) {
            ProgramNumber programNumber = (ProgramNumber)Predef$.MODULE$.ArrowAssoc((Object)pmt.programNumber());
            Map map = (Map)this.pmts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)programNumber, (Object)pmt));
            Option<ProgramAssociationTable> option = this.copy$default$1();
            Option<ConditionalAccessTable> option2 = this.copy$default$2();
            return this.copy(option, option2, (Map<ProgramNumber, ProgramMapTable>)map);
        }

        @Override
        public TransportStreamIndex withCat(ConditionalAccessTable cat) {
            Some some = Some$.MODULE$.apply((Object)cat);
            Option<ProgramAssociationTable> option = this.copy$default$1();
            Map<ProgramNumber, ProgramMapTable> map = this.copy$default$3();
            return this.copy(option, (Option<ConditionalAccessTable>)some, map);
        }

        public DefaultTransportStreamIndex copy(Option<ProgramAssociationTable> pat, Option<ConditionalAccessTable> cat, Map<ProgramNumber, ProgramMapTable> pmts) {
            return new DefaultTransportStreamIndex(pat, cat, pmts);
        }

        public Option<ProgramAssociationTable> copy$default$1() {
            return this.pat();
        }

        public Option<ConditionalAccessTable> copy$default$2() {
            return this.cat();
        }

        public Map<ProgramNumber, ProgramMapTable> copy$default$3() {
            return this.pmts();
        }

        public Option<ProgramAssociationTable> _1() {
            return this.pat();
        }

        public Option<ConditionalAccessTable> _2() {
            return this.cat();
        }

        public Map<ProgramNumber, ProgramMapTable> _3() {
            return this.pmts();
        }

        private final TransportStreamIndex$LookupError$UnknownProgram$ pmt$$anonfun$1() {
            return TransportStreamIndex$LookupError$UnknownProgram$.MODULE$;
        }
    }

    public static abstract class LookupError {
        public static int ordinal(LookupError lookupError) {
            return TransportStreamIndex$LookupError$.MODULE$.ordinal(lookupError);
        }
    }
}

