/*
 * Decompiled with CFR 0.152.
 */
package fs2.protocols.pcap;

import fs2.Chunk;
import fs2.interop.scodec.StreamDecoder;
import fs2.protocols.ethernet.EthernetFrameHeader;
import fs2.protocols.ip.IpHeader;
import fs2.protocols.ip.udp.DatagramHeader;
import fs2.protocols.pcap.CaptureFile$;
import fs2.protocols.pcap.CaptureFile$DatagramRecord$;
import fs2.protocols.pcap.GlobalHeader;
import fs2.protocols.pcap.LinkType;
import fs2.protocols.pcap.Record;
import fs2.protocols.pcap.RecordHeader;
import fs2.timeseries.TimeStamped;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scodec.Codec;
import scodec.Err;

public class CaptureFile
implements Product,
Serializable {
    private final GlobalHeader header;
    private final Vector records;

    public static CaptureFile apply(GlobalHeader globalHeader, Vector<Record> vector) {
        return CaptureFile$.MODULE$.apply(globalHeader, vector);
    }

    public static Codec<CaptureFile> codec() {
        return CaptureFile$.MODULE$.codec();
    }

    public static CaptureFile fromProduct(Product product) {
        return CaptureFile$.MODULE$.fromProduct(product);
    }

    public static <A> StreamDecoder<TimeStamped<A>> payloadStreamDecoder(Function1<LinkType, Option<StreamDecoder<A>>> function1) {
        return CaptureFile$.MODULE$.payloadStreamDecoder(function1);
    }

    public static <A> StreamDecoder<TimeStamped<A>> payloadStreamDecoderPF(PartialFunction<LinkType, StreamDecoder<A>> partialFunction) {
        return CaptureFile$.MODULE$.payloadStreamDecoderPF(partialFunction);
    }

    public static StreamDecoder<Record> recordStreamDecoder() {
        return CaptureFile$.MODULE$.recordStreamDecoder();
    }

    public static <A> StreamDecoder<A> streamDecoder(Function1<GlobalHeader, Either<Err, Function1<RecordHeader, StreamDecoder<A>>>> function1) {
        return CaptureFile$.MODULE$.streamDecoder(function1);
    }

    public static StreamDecoder<TimeStamped<DatagramRecord>> udpDatagrams() {
        return CaptureFile$.MODULE$.udpDatagrams();
    }

    public static CaptureFile unapply(CaptureFile captureFile) {
        return CaptureFile$.MODULE$.unapply(captureFile);
    }

    public CaptureFile(GlobalHeader header, Vector<Record> records) {
        this.header = header;
        this.records = records;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CaptureFile)) return false;
        CaptureFile captureFile = (CaptureFile)object;
        GlobalHeader globalHeader = this.header();
        GlobalHeader globalHeader2 = captureFile.header();
        if (globalHeader == null) {
            if (globalHeader2 != null) {
                return false;
            }
        } else if (!((Object)globalHeader).equals(globalHeader2)) return false;
        Vector<Record> vector = this.records();
        Vector<Record> vector2 = captureFile.records();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        if (!captureFile.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CaptureFile;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "CaptureFile";
    }

    public Object productElement(int n) {
        Vector<Record> vector;
        int n2 = n;
        if (0 == n2) {
            vector = this._1();
        } else if (1 == n2) {
            vector = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return vector;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "header";
        } else if (1 == n2) {
            string = "records";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public GlobalHeader header() {
        return this.header;
    }

    public Vector<Record> records() {
        return this.records;
    }

    public CaptureFile copy(GlobalHeader header, Vector<Record> records) {
        return new CaptureFile(header, records);
    }

    public GlobalHeader copy$default$1() {
        return this.header();
    }

    public Vector<Record> copy$default$2() {
        return this.records();
    }

    public GlobalHeader _1() {
        return this.header();
    }

    public Vector<Record> _2() {
        return this.records();
    }

    public static class DatagramRecord
    implements Product,
    Serializable {
        private final EthernetFrameHeader ethernet;
        private final IpHeader ip;
        private final DatagramHeader udp;
        private final Chunk payload;

        public static DatagramRecord apply(EthernetFrameHeader ethernetFrameHeader, IpHeader ipHeader, DatagramHeader datagramHeader, Chunk<Object> chunk) {
            return CaptureFile$DatagramRecord$.MODULE$.apply(ethernetFrameHeader, ipHeader, datagramHeader, chunk);
        }

        public static DatagramRecord fromProduct(Product product) {
            return CaptureFile$DatagramRecord$.MODULE$.fromProduct(product);
        }

        public static DatagramRecord unapply(DatagramRecord datagramRecord) {
            return CaptureFile$DatagramRecord$.MODULE$.unapply(datagramRecord);
        }

        public DatagramRecord(EthernetFrameHeader ethernet, IpHeader ip, DatagramHeader udp, Chunk<Object> payload) {
            this.ethernet = ethernet;
            this.ip = ip;
            this.udp = udp;
            this.payload = payload;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DatagramRecord)) return false;
            DatagramRecord datagramRecord = (DatagramRecord)object;
            EthernetFrameHeader ethernetFrameHeader = this.ethernet();
            EthernetFrameHeader ethernetFrameHeader2 = datagramRecord.ethernet();
            if (ethernetFrameHeader == null) {
                if (ethernetFrameHeader2 != null) {
                    return false;
                }
            } else if (!((Object)ethernetFrameHeader).equals(ethernetFrameHeader2)) return false;
            IpHeader ipHeader = this.ip();
            IpHeader ipHeader2 = datagramRecord.ip();
            if (ipHeader == null) {
                if (ipHeader2 != null) {
                    return false;
                }
            } else if (!ipHeader.equals(ipHeader2)) return false;
            DatagramHeader datagramHeader = this.udp();
            DatagramHeader datagramHeader2 = datagramRecord.udp();
            if (datagramHeader == null) {
                if (datagramHeader2 != null) {
                    return false;
                }
            } else if (!((Object)datagramHeader).equals(datagramHeader2)) return false;
            Chunk<Object> chunk = this.payload();
            Chunk<Object> chunk2 = datagramRecord.payload();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            if (!datagramRecord.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DatagramRecord;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "DatagramRecord";
        }

        public Object productElement(int n) {
            Chunk<Object> chunk;
            int n2 = n;
            switch (n2) {
                case 0: {
                    chunk = this._1();
                    break;
                }
                case 1: {
                    chunk = this._2();
                    break;
                }
                case 2: {
                    chunk = this._3();
                    break;
                }
                case 3: {
                    chunk = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return chunk;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "ethernet";
                    break;
                }
                case 1: {
                    string = "ip";
                    break;
                }
                case 2: {
                    string = "udp";
                    break;
                }
                case 3: {
                    string = "payload";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public EthernetFrameHeader ethernet() {
            return this.ethernet;
        }

        public IpHeader ip() {
            return this.ip;
        }

        public DatagramHeader udp() {
            return this.udp;
        }

        public Chunk<Object> payload() {
            return this.payload;
        }

        public DatagramRecord copy(EthernetFrameHeader ethernet, IpHeader ip, DatagramHeader udp, Chunk<Object> payload) {
            return new DatagramRecord(ethernet, ip, udp, payload);
        }

        public EthernetFrameHeader copy$default$1() {
            return this.ethernet();
        }

        public IpHeader copy$default$2() {
            return this.ip();
        }

        public DatagramHeader copy$default$3() {
            return this.udp();
        }

        public Chunk<Object> copy$default$4() {
            return this.payload();
        }

        public EthernetFrameHeader _1() {
            return this.ethernet();
        }

        public IpHeader _2() {
            return this.ip();
        }

        public DatagramHeader _3() {
            return this.udp();
        }

        public Chunk<Object> _4() {
            return this.payload();
        }
    }
}

