/*
 * Decompiled with CFR 0.152.
 */
package fs2.interop.reactivestreams;

import cats.effect.kernel.Async;
import cats.effect.std.Dispatcher;
import cats.effect.std.Queue;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.SignallingRef;
import fs2.interop.reactivestreams.StreamSubscription$;
import fs2.interop.reactivestreams.StreamSubscription$Finite$;
import fs2.interop.reactivestreams.StreamSubscription$Infinite$;
import java.io.Serializable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

public final class StreamSubscription<F, A>
implements Subscription {
    private final Queue<F, Request> requests;
    private final SignallingRef<F, Object> cancelled;
    private final Subscriber<A> sub;
    private final Stream<F, A> stream;
    private final Dispatcher<F> dispatcher;
    private final Async<F> F;

    public static <F, A> Object apply(Subscriber<A> subscriber, Stream<F, A> stream, Dispatcher<F> dispatcher, Async<F> async) {
        return StreamSubscription$.MODULE$.apply(subscriber, stream, dispatcher, async);
    }

    public StreamSubscription(Queue<F, Request> requests, SignallingRef<F, Object> cancelled, Subscriber<A> sub, Stream<F, A> stream, Dispatcher<F> dispatcher, Async<F> F) {
        this.requests = requests;
        this.cancelled = cancelled;
        this.sub = sub;
        this.stream = stream;
        this.dispatcher = dispatcher;
        this.F = F;
    }

    public F onError(Throwable e) {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.cancelled.set((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.F);
        return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.onError$$anonfun$1(e), this.F);
    }

    public F onComplete() {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.cancelled.set((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.F);
        return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, this::onComplete$$anonfun$1, this.F);
    }

    public void unsafeStart() {
        Object object = package.all$.MODULE$.catsSyntaxIfM(this.cancelled.get(), this.F);
        Object s = this.stream.through(this.subscriptionPipe$1()).interruptWhen(this.cancelled, this.F).evalMap((Function1 & Serializable)x -> this.F.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$7$$anonfun$1(x)))).handleErrorWith((Function1 & Serializable)e -> Stream$.MODULE$.eval(this.onError((Throwable)e))).onFinalize(IfMOps$.MODULE$.ifM$extension(object, this::$anonfun$3, this::$anonfun$4, this.F), this.F).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F))).drain();
        this.dispatcher.unsafeRunAndForget(s);
    }

    public void cancel() {
        this.dispatcher.unsafeRunSync(this.cancelled.set((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public void request(long n) {
        Object object;
        if (n == Long.MAX_VALUE) {
            Request request = (Request)package.all$.MODULE$.catsSyntaxApplicativeId((Object)StreamSubscription$Infinite$.MODULE$);
            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)request, this.F);
        } else if (n > 0L) {
            Request request = (Request)package.all$.MODULE$.catsSyntaxApplicativeId((Object)StreamSubscription$Finite$.MODULE$.apply(n));
            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)request, this.F);
        } else {
            object = this.F.raiseError((Object)new IllegalArgumentException(new StringBuilder(35).append("3.9 - invalid number of elements [").append(n).append("]").toString()));
        }
        Object request = object;
        Object object2 = package.all$.MODULE$.catsSyntaxIfM(this.cancelled.get(), this.F);
        Object prog = IfMOps$.MODULE$.ifM$extension(object2, this::$anonfun$5, () -> this.$anonfun$6(request), this.F);
        this.dispatcher.unsafeRunAndForget(prog);
    }

    private final void onError$$anonfun$2$$anonfun$1(Throwable e$2) {
        this.sub.onError(e$2);
    }

    private final Object onError$$anonfun$1(Throwable e$1) {
        return this.F.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.onError$$anonfun$2$$anonfun$1(e$1)));
    }

    private final void onComplete$$anonfun$2$$anonfun$1() {
        this.sub.onComplete();
    }

    private final Object onComplete$$anonfun$1() {
        return this.F.delay((Function0)((JFunction0.mcV.sp & Serializable)this::onComplete$$anonfun$2$$anonfun$1));
    }

    private final Pull go$2(Stream s) {
        return Pull$.MODULE$.eval(this.requests.take()).flatMap((Function1 & Serializable)x$12 -> {
            Pull pull;
            Request request = x$12;
            if (StreamSubscription$Infinite$.MODULE$.equals(request)) {
                Stream stream = Stream$.MODULE$.InvariantOps(s);
                Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                pull = Stream.ToPull$.MODULE$.echo$extension(stream2);
            } else if (request instanceof Finite) {
                long l;
                Finite finite = StreamSubscription$Finite$.MODULE$.unapply((Finite)request);
                long n = l = finite._1();
                Stream stream = Stream$.MODULE$.InvariantOps(s);
                Stream stream3 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                pull = Stream.ToPull$.MODULE$.take$extension(stream3, n).flatMap((Function1 & Serializable)x$1 -> {
                    Pull pull;
                    Option option = x$1;
                    if (None$.MODULE$.equals(option)) {
                        pull = Pull$.MODULE$.done();
                    } else if (option instanceof Some) {
                        Stream rem = (Stream)((Some)option).value();
                        pull = this.go$2(rem);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return pull;
                });
            } else {
                throw new MatchError((Object)request);
            }
            return pull;
        });
    }

    private final Function1 subscriptionPipe$1() {
        return (Function1 & Serializable)in -> {
            Pull pull = Pull$.MODULE$.StreamPullOps(this.go$2((Stream)in));
            return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
        };
    }

    private final void $anonfun$7$$anonfun$1(Object x$1) {
        this.sub.onNext(x$1);
    }

    private final Object $anonfun$3() {
        return this.F.unit();
    }

    private final Object $anonfun$4() {
        return this.onComplete();
    }

    private final Object $anonfun$5() {
        return this.F.unit();
    }

    private final Object $anonfun$6(Object request$1) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFlatMapOps(request$1, this.F).flatMap((Function1 & Serializable)a -> this.requests.offer(a)), this.F);
        return ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, (Function1 & Serializable)e -> this.onError((Throwable)e), this.F);
    }

    public static class Finite
    implements Request,
    Product,
    Serializable {
        private final long n;

        public static Finite apply(long l) {
            return StreamSubscription$Finite$.MODULE$.apply(l);
        }

        public static Finite fromProduct(Product product) {
            return StreamSubscription$Finite$.MODULE$.fromProduct(product);
        }

        public static Finite unapply(Finite finite) {
            return StreamSubscription$Finite$.MODULE$.unapply(finite);
        }

        public Finite(long n) {
            this.n = n;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.n()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Finite)) return false;
            Finite finite = (Finite)object;
            if (this.n() != finite.n()) return false;
            if (!finite.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Finite;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Finite";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "n";
        }

        public long n() {
            return this.n;
        }

        public Finite copy(long n) {
            return new Finite(n);
        }

        public long copy$default$1() {
            return this.n();
        }

        public long _1() {
            return this.n();
        }
    }

    public static interface Request {
    }
}

