/*
 * Decompiled with CFR 0.152.
 */
package fs2.interop.reactivestreams;

import cats.effect.kernel.Async;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.kernel.syntax.GenSpawnOps_$;
import cats.effect.kernel.syntax.MonadCancelOps$;
import cats.effect.std.Dispatcher;
import cats.effect.std.Queue;
import cats.effect.syntax.package;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Stream;
import fs2.Stream$;
import fs2.interop.reactivestreams.StreamSubscription$;
import fs2.interop.reactivestreams.StreamSubscription$Finite$;
import fs2.interop.reactivestreams.StreamSubscription$Infinite$;
import java.io.Serializable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class StreamSubscription<F, A>
implements Subscription {
    private final Queue<F, Request> requests;
    private final Deferred<F, BoxedUnit> canceled;
    private final Subscriber<A> sub;
    private final Stream<F, A> stream;
    private final Dispatcher<F> requestDispatcher;
    private final Async<F> F;

    public static <F, A> Resource<F, StreamSubscription<F, A>> apply(Stream<F, A> stream, Subscriber<A> subscriber, Async<F> async) {
        return StreamSubscription$.MODULE$.apply(stream, subscriber, async);
    }

    public static <F, A> Object subscribe(Stream<F, A> stream, Subscriber<A> subscriber, Async<F> async) {
        return StreamSubscription$.MODULE$.subscribe(stream, subscriber, async);
    }

    public StreamSubscription(Queue<F, Request> requests, Deferred<F, BoxedUnit> canceled, Subscriber<A> sub, Stream<F, A> stream, Dispatcher<F> requestDispatcher, Async<F> F) {
        this.requests = requests;
        this.canceled = canceled;
        this.sub = sub;
        this.stream = stream;
        this.requestDispatcher = requestDispatcher;
        this.F = F;
    }

    private F onError(Throwable ex) {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.cancelMe(), this.F);
        return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.onError$$anonfun$1(ex), this.F);
    }

    private F onComplete() {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.cancelMe(), this.F);
        return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object, this::onComplete$$anonfun$1, this.F);
    }

    public F run() {
        Object events = this.stream.through(this.subscriptionPipe$1()).foreach((Function1 & Serializable)x -> this.F.delay((Function0 & Serializable)() -> {
            this.$anonfun$1$$anonfun$1(x);
            return BoxedUnit.UNIT;
        })).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F))).drain();
        Object object = package.all$.MODULE$.genSpawnOps_(events);
        Object object2 = package.all$.MODULE$.monadCancelOps(GenSpawnOps_$.MODULE$.race$extension(object, this.canceled.get(), this.F), this.F);
        return (F)package.all$.MODULE$.toFunctorOps(MonadCancelOps$.MODULE$.guaranteeCase$extension(object2, (Function1 & Serializable)x$12 -> {
            Outcome outcome = x$12;
            if (outcome instanceof Outcome.Succeeded) {
                Object object;
                Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                Object result = object = succeeded._1();
                return package.all$.MODULE$.toFlatMapOps(result, this.F).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object object = ((Left)either).value();
                        if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                            return this.onComplete();
                        }
                    }
                    if (either instanceof Right) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object object = ((Right)either).value();
                        if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                            return this.F.unit();
                        }
                    }
                    throw new MatchError((Object)either);
                });
            }
            if (outcome instanceof Outcome.Errored) {
                Throwable throwable;
                Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                Throwable ex = throwable = (Throwable)errored._1();
                return this.onError(ex);
            }
            if (outcome instanceof Outcome.Canceled && Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome)) {
                return this.cancelMe();
            }
            throw new MatchError((Object)outcome);
        }, this.F), this.F).void();
    }

    private F cancelMe() {
        return (F)package.all$.MODULE$.toFunctorOps(this.canceled.complete((Object)BoxedUnit.UNIT), this.F).void();
    }

    public void cancel() {
        try {
            this.requestDispatcher.unsafeRunAndForget(this.cancelMe());
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void request(long n) {
        Object prog = package.all$.MODULE$.toFlatMapOps(this.canceled.tryGet(), this.F).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                if (n == Long.MAX_VALUE) {
                    return this.requests.offer((Object)StreamSubscription$Infinite$.MODULE$);
                }
                if (n > 0L) {
                    return this.requests.offer((Object)StreamSubscription$Finite$.MODULE$.apply(n));
                }
                return this.onError(new IllegalArgumentException(new StringBuilder(29).append("Invalid number of elements [").append(n).append("]").toString()));
            }
            if (option instanceof Some) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = ((Some)option).value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return this.F.unit();
                }
            }
            throw new MatchError((Object)option);
        });
        try {
            this.requestDispatcher.unsafeRunAndForget(prog);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private final void onError$$anonfun$1$$anonfun$1(Throwable ex$2) {
        this.sub.onError(ex$2);
    }

    private final Object onError$$anonfun$1(Throwable ex$1) {
        return this.F.delay((Function0 & Serializable)() -> {
            this.onError$$anonfun$1$$anonfun$1(ex$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void onComplete$$anonfun$1$$anonfun$1() {
        this.sub.onComplete();
    }

    private final Object onComplete$$anonfun$1() {
        return this.F.delay((Function0 & Serializable)() -> {
            this.onComplete$$anonfun$1$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private final Pull go$1(Stream s) {
        return Pull$.MODULE$.eval(this.requests.take()).flatMap((Function1 & Serializable)x$12 -> {
            Request request = x$12;
            if (StreamSubscription$Infinite$.MODULE$.equals(request)) {
                Stream stream = Stream$.MODULE$.InvariantOps(s);
                Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                return Stream.ToPull$.MODULE$.echo$extension(stream2);
            }
            if (request instanceof Finite) {
                long l;
                Finite finite = StreamSubscription$Finite$.MODULE$.unapply((Finite)request);
                long n = l = finite._1();
                Stream stream = Stream$.MODULE$.InvariantOps(s);
                Stream stream3 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                return Stream.ToPull$.MODULE$.take$extension(stream3, n).flatMap((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (None$.MODULE$.equals(option)) {
                        return Pull$.MODULE$.done();
                    }
                    if (option instanceof Some) {
                        Stream rem = (Stream)((Some)option).value();
                        return this.go$1(rem);
                    }
                    throw new MatchError((Object)option);
                });
            }
            throw new MatchError((Object)request);
        });
    }

    private final Function1 subscriptionPipe$1() {
        return (Function1 & Serializable)in -> {
            Pull pull = Pull$.MODULE$.StreamPullOps(this.go$1((Stream)in));
            return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
        };
    }

    private final void $anonfun$1$$anonfun$1(Object x$1) {
        this.sub.onNext(x$1);
    }

    public static class Finite
    implements Request,
    Product,
    Serializable {
        private final long n;

        public static Finite apply(long l) {
            return StreamSubscription$Finite$.MODULE$.apply(l);
        }

        public static Finite fromProduct(Product product) {
            return StreamSubscription$Finite$.MODULE$.fromProduct(product);
        }

        public static Finite unapply(Finite finite) {
            return StreamSubscription$Finite$.MODULE$.unapply(finite);
        }

        public Finite(long n) {
            this.n = n;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.n()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Finite)) return false;
            Finite finite = (Finite)object;
            if (this.n() != finite.n()) return false;
            if (!finite.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Finite;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Finite";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "n";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long n() {
            return this.n;
        }

        public Finite copy(long n) {
            return new Finite(n);
        }

        public long copy$default$1() {
            return this.n();
        }

        public long _1() {
            return this.n();
        }
    }

    public static interface Request {
    }
}

