/*
 * Decompiled with CFR 0.152.
 */
package co.luminositylabs.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Configuration
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    public static final String DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME = "co.luminositylabs.configFile";
    private static final String DEFAULT_CONFIG_FILENAME = "co.luminositylabs.config.properties";
    private static final long serialVersionUID = -2216420313823699897L;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Properties properties = new Properties();

    public Properties getProperties() {
        this.readLock.lock();
        try {
            Properties properties = (Properties)this.properties.clone();
            return properties;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getPropertiesWithPrefix(String prefix) {
        this.readLock.lock();
        try {
            Properties propertiesWithPrefix = new Properties();
            for (String propertyName : this.properties.stringPropertyNames()) {
                if (!propertyName.startsWith(prefix)) continue;
                propertiesWithPrefix.setProperty(propertyName, this.properties.getProperty(propertyName));
            }
            Properties properties = propertiesWithPrefix;
            return properties;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setProperties(Properties properties) {
        this.writeLock.lock();
        try {
            this.properties.clear();
            this.properties.putAll((Map<?, ?>)properties);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.writeLock.lock();
        try {
            this.properties.setProperty(propertyName, propertyValue);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getProperty(String propertyName) {
        this.readLock.lock();
        try {
            String string = this.properties.getProperty(propertyName);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String propertyName, String defaultValue) {
        this.readLock.lock();
        try {
            String string = this.properties.getProperty(propertyName, defaultValue);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Object get(Object key) {
        this.readLock.lock();
        try {
            Object object = this.properties.get(key);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOrDefault(Object key, Object defaultValue) {
        this.readLock.lock();
        try {
            Object object = this.properties.getOrDefault(key, defaultValue);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        this.writeLock.lock();
        try {
            Object object = this.properties.put(key, value);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void putAll(Map<?, ?> map) {
        this.writeLock.lock();
        try {
            this.properties.putAll(map);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(Object key, Object value) {
        this.writeLock.lock();
        try {
            Object object = this.properties.putIfAbsent(key, value);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void readProperties() {
        this.writeLock.lock();
        try {
            logger.debug("default config file path property name: {}", (Object)DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME);
            this.properties.clear();
            logger.debug("Searching system properties for a specified config file path ({})", (Object)DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME);
            String configFileFullPathName = System.getProperty(DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME);
            if (configFileFullPathName != null) {
                logger.debug("Found system property ({}={})", (Object)DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME, (Object)configFileFullPathName);
            } else {
                logger.debug("Did not find system property ({})", (Object)DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME);
                logger.debug("Assuming a default name for the config file without a path. ({})", (Object)DEFAULT_CONFIG_FILENAME);
                configFileFullPathName = DEFAULT_CONFIG_FILENAME;
            }
            logger.debug("Looking for {} in filesystem...", (Object)configFileFullPathName);
            File configFileFullPath = new File(configFileFullPathName);
            if (configFileFullPath.exists()) {
                logger.debug("file exists in filesystem at {}", (Object)configFileFullPath);
                try {
                    FileReader fileReader = new FileReader(configFileFullPath);
                    this.properties.load(fileReader);
                }
                catch (IOException ioe) {
                    logger.debug("Error occurred while trying to read properties from {} on filesystem.", (Object)configFileFullPathName, (Object)ioe);
                }
            } else {
                String homeDirectoryPath = System.getProperty("user.home");
                if (homeDirectoryPath != null) {
                    logger.debug("could not find file... checking home directory.");
                    File configFileRelativeToHomeDirectory = new File(homeDirectoryPath, configFileFullPathName);
                    InputStream inputStream = null;
                    if (configFileRelativeToHomeDirectory.exists()) {
                        logger.debug("Found config file in home directory ({})", (Object)configFileRelativeToHomeDirectory);
                        try {
                            inputStream = new FileInputStream(configFileRelativeToHomeDirectory);
                        }
                        catch (FileNotFoundException e) {
                            logger.debug("Did not find config file in home directory");
                        }
                    } else {
                        logger.debug("Did not find config file in home directory");
                        logger.debug("Looking for {} in classpath...", (Object)configFileFullPathName);
                        inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileFullPathName);
                        if (inputStream != null) {
                            logger.debug("file exists in classpath at {}", (Object)configFileFullPath);
                        } else {
                            logger.debug("Did not find file ({}) in classpath", (Object)configFileFullPathName);
                        }
                    }
                    if (inputStream != null) {
                        try {
                            logger.debug("Reading properties from input stream.");
                            this.properties.load(inputStream);
                            logger.debug("Read properties from input stream: {}", (Object)this.properties);
                        }
                        catch (IOException ioe) {
                            logger.debug("Error occurred while trying to read properties from {}.", (Object)configFileFullPathName, (Object)ioe);
                        }
                    }
                } else {
                    logger.debug("user.home system property was not found.");
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

