/*
 * Decompiled with CFR 0.152.
 */
package co.luminositylabs.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Configuration
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    public static final String DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME = "co.luminositylabs.configFile";
    private static final String DEFAULT_CONFIG_FILENAME = "co.luminositylabs.config.properties";
    private static final long serialVersionUID = 7848558640626834259L;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Properties properties = new Properties();

    public Properties getProperties() {
        this.readLock.lock();
        try {
            Properties properties = (Properties)this.properties.clone();
            return properties;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getPropertiesWithPrefix(String prefix) {
        this.readLock.lock();
        try {
            Properties propertiesWithPrefix = new Properties();
            for (String propertyName : this.properties.stringPropertyNames()) {
                if (!propertyName.startsWith(prefix)) continue;
                propertiesWithPrefix.setProperty(propertyName, this.properties.getProperty(propertyName));
            }
            Properties properties = propertiesWithPrefix;
            return properties;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setProperties(Properties properties) {
        this.writeLock.lock();
        try {
            this.properties.clear();
            this.properties.putAll((Map<?, ?>)properties);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.writeLock.lock();
        try {
            this.properties.setProperty(propertyName, propertyValue);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getProperty(String propertyName) {
        this.readLock.lock();
        try {
            String string = this.properties.getProperty(propertyName);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String propertyName, String defaultValue) {
        this.readLock.lock();
        try {
            String string = this.properties.getProperty(propertyName, defaultValue);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Object get(Object key) {
        this.readLock.lock();
        try {
            Object object = this.properties.get(key);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOrDefault(Object key, Object defaultValue) {
        this.readLock.lock();
        try {
            Object object = this.properties.getOrDefault(key, defaultValue);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        this.writeLock.lock();
        try {
            Object object = this.properties.put(key, value);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void putAll(Map<?, ?> map) {
        this.writeLock.lock();
        try {
            this.properties.putAll(map);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(Object key, Object value) {
        this.writeLock.lock();
        try {
            Object object = this.properties.putIfAbsent(key, value);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void readProperties() {
        block33: {
            this.writeLock.lock();
            try {
                logger.debug("default config file path property name: {}", (Object)DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME);
                this.properties.clear();
                String configFileName = this.configFileName();
                logger.debug("Looking for {} in filesystem...", (Object)configFileName);
                Path configFilePath = Paths.get(configFileName, new String[0]);
                if (Files.exists(configFilePath, new LinkOption[0])) {
                    logger.debug("file exists in filesystem at {}", (Object)configFilePath);
                    try (InputStream inputStream = Files.newInputStream(configFilePath, new OpenOption[0]);){
                        this.properties.load(inputStream);
                        break block33;
                    }
                    catch (IOException ioe) {
                        logger.debug("Error occurred while trying to read properties from {} on filesystem.", (Object)configFilePath, (Object)ioe);
                    }
                    break block33;
                }
                String homeDirectoryPathName = System.getProperty("user.home");
                if (homeDirectoryPathName != null) {
                    logger.debug("could not find file... checking home directory.");
                    Path homeDirectoryPath = Paths.get(homeDirectoryPathName, new String[0]);
                    Path configFilePathRelativeToHomeDirectory = homeDirectoryPath.resolve(configFilePath);
                    if (Files.exists(configFilePathRelativeToHomeDirectory, new LinkOption[0])) {
                        logger.debug("Found config file in home directory ({})", (Object)configFilePathRelativeToHomeDirectory);
                        try (InputStream inputStream = Files.newInputStream(configFilePathRelativeToHomeDirectory, new OpenOption[0]);){
                            this.readPropertiesFromInputStream(inputStream);
                            break block33;
                        }
                        catch (FileNotFoundException e) {
                            logger.debug("Did not find config file in home directory");
                        }
                        catch (IOException ioe) {
                            logger.debug("Error occurred while trying to read properties from {}.", (Object)configFilePathRelativeToHomeDirectory, (Object)ioe);
                        }
                        break block33;
                    }
                    logger.debug("Did not find config file in home directory");
                    logger.debug("Looking for {} in classpath...", (Object)configFilePath);
                    try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileName);){
                        if (inputStream != null) {
                            logger.debug("file exists in classpath at {}", (Object)configFilePath);
                            this.readPropertiesFromInputStream(inputStream);
                        } else {
                            logger.debug("Did not find file ({}) in classpath", (Object)configFilePath);
                        }
                        break block33;
                    }
                    catch (IOException ioe) {
                        logger.debug("Error occurred while trying to read properties from {}.", (Object)configFileName, (Object)ioe);
                    }
                    break block33;
                }
                logger.debug("user.home system property was not found.");
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private String configFileName() {
        logger.debug("Searching system properties for a specified config file path ({})", (Object)DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME);
        String configFileName = System.getProperty(DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME);
        if (configFileName != null) {
            logger.debug("Found system property ({}={})", (Object)DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME, (Object)configFileName);
        } else {
            logger.debug("Did not find system property ({})", (Object)DEFAULT_CONFIG_FILE_PATH_PROPERTY_NAME);
            logger.debug("Assuming a default name for the config file without a path. ({})", (Object)DEFAULT_CONFIG_FILENAME);
            configFileName = DEFAULT_CONFIG_FILENAME;
        }
        return configFileName;
    }

    private void readPropertiesFromInputStream(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "Unable to read properties from null input stream");
        logger.debug("Reading properties from input stream.");
        this.properties.load(inputStream);
        logger.debug("Read properties from input stream: {}", (Object)this.properties);
    }
}

