/*
 * Decompiled with CFR 0.152.
 */
package co.luminositylabs.utils.orientdb;

import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientDBUtil {
    private static final Logger logger = LoggerFactory.getLogger(OrientDBUtil.class);
    public static final String PROPERTY_NAME_ODB_EMBEDDED = "orientdb.embedded";
    public static final String PROPERTY_NAME_ODB_SERVER_ENGINE = "orientdb.server.engine";
    public static final String PROPERTY_NAME_ODB_SERVER_REMOTE_HOSTNAME = "orientdb.server.remote.hostname";
    public static final String PROPERTY_NAME_ODB_SERVER_REMOTE_PORT_RANGE = "orientdb.server.remote.portRange";
    public static final String PROPERTY_NAME_ODB_DATABASE_PATH = "orientdb.databasePath";
    public static final String PROPERTY_NAME_ODB_DATABASE_NAME = "orientdb.databaseName";
    public static final String PROPERTY_NAME_ODB_USERNAME = "orientdb.server.username";
    public static final String PROPERTY_NAME_ODB_PASSWORD = "orientdb.server.password";
    public static final String DEFAULT_BINARY_PROTOCOL_PORTRANGE = "2424-2430";

    protected OrientDBUtil() {
    }

    public static String buildDatabaseUrl(String databaseName, Engine engine, String hostname, String portRange, String databasePath) {
        Objects.requireNonNull(databaseName, "A  databaseName must be provided");
        Objects.requireNonNull(engine, "An engine must be provided");
        StringBuilder databaseUrlStringBuilder = new StringBuilder(engine.toStringValue());
        databaseUrlStringBuilder.append(":");
        if (engine.equals((Object)Engine.REMOTE)) {
            Objects.requireNonNull(hostname, "When remote engine is used, a hostname must be provided");
            databaseUrlStringBuilder.append(hostname);
            if (portRange != null) {
                int port;
                int endIndex = portRange.length();
                int rangeSeparatorIdx = portRange.indexOf("-");
                if (rangeSeparatorIdx != -1) {
                    endIndex = rangeSeparatorIdx;
                }
                String parsablePortRangeString = portRange.substring(0, endIndex);
                try {
                    port = Integer.parseInt(parsablePortRangeString);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("portRange must be a string representing an integer value or an integer range", nfe);
                }
                databaseUrlStringBuilder.append(":").append(port);
            }
        }
        if (databasePath != null) {
            databaseUrlStringBuilder.append(databasePath);
            if (!databasePath.endsWith("/")) {
                databaseUrlStringBuilder.append("/");
            }
        } else {
            databaseUrlStringBuilder.append("/");
        }
        databaseUrlStringBuilder.append(databaseName);
        return databaseUrlStringBuilder.toString();
    }

    public static OServer startEmbeddedServer(String username, String password, String portRange) throws Exception {
        logger.debug("Starting embedded OrientDB server");
        Objects.requireNonNull(username, "Username must be specified");
        Objects.requireNonNull(password, "Password must be specified");
        String embeddedServerPortRange = DEFAULT_BINARY_PROTOCOL_PORTRANGE;
        if (portRange != null) {
            embeddedServerPortRange = portRange;
        }
        OServer oServer = OServerMain.create();
        OServerConfiguration serverConfig = new OServerConfiguration();
        serverConfig.users = new OServerUserConfiguration[]{new OServerUserConfiguration("root", "password", "*"), new OServerUserConfiguration(username, password, "*")};
        serverConfig.network = new OServerNetworkConfiguration();
        serverConfig.network.listeners = new ArrayList();
        OServerNetworkListenerConfiguration networkListenerConfig = new OServerNetworkListenerConfiguration();
        networkListenerConfig.ipAddress = "0.0.0.0";
        networkListenerConfig.portRange = embeddedServerPortRange;
        serverConfig.network.listeners.add(networkListenerConfig);
        serverConfig.network.protocols = new ArrayList();
        OServerNetworkProtocolConfiguration protocolConfig = new OServerNetworkProtocolConfiguration("binary", "com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary");
        serverConfig.network.protocols.add(protocolConfig);
        serverConfig.properties = new OServerEntryConfiguration[]{new OServerEntryConfiguration("server.cache.staticResources", "false"), new OServerEntryConfiguration("server.database.path", "target/dbs"), new OServerEntryConfiguration("plugin.dynamic", "false")};
        oServer.startup(serverConfig);
        oServer.activate();
        return oServer;
    }

    public static enum Engine {
        PLOCAL("plocal"),
        REMOTE("remote");

        private String stringValue;

        private Engine(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toStringValue() {
            return this.stringValue;
        }

        public static Engine fromString(String engineName) {
            Engine engine = null;
            if (engineName != null) {
                for (Engine validEngine : Engine.values()) {
                    if (!engineName.equalsIgnoreCase(validEngine.stringValue)) continue;
                    engine = validEngine;
                }
            }
            return engine;
        }
    }
}

