/*
 * Decompiled with CFR 0.152.
 */
package com.c8db;

import com.arangodb.velocypack.VPack;
import com.arangodb.velocypack.VPackAnnotationFieldFilter;
import com.arangodb.velocypack.VPackAnnotationFieldNaming;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackInstanceCreator;
import com.arangodb.velocypack.VPackJsonDeserializer;
import com.arangodb.velocypack.VPackJsonSerializer;
import com.arangodb.velocypack.VPackModule;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackParserModule;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.ValueType;
import com.c8db.C8DBException;
import com.c8db.C8Database;
import com.c8db.C8SerializationAccessor;
import com.c8db.Protocol;
import com.c8db.Service;
import com.c8db.entity.C8DBVersion;
import com.c8db.entity.DataCenterEntity;
import com.c8db.entity.DcInfoEntity;
import com.c8db.entity.GeoFabricEntity;
import com.c8db.entity.LoadBalancingStrategy;
import com.c8db.entity.LogEntity;
import com.c8db.entity.LogLevelEntity;
import com.c8db.entity.Permissions;
import com.c8db.entity.ServerRole;
import com.c8db.entity.UserEntity;
import com.c8db.internal.C8Context;
import com.c8db.internal.C8DBImpl;
import com.c8db.internal.C8Defaults;
import com.c8db.internal.InternalC8DBBuilder;
import com.c8db.internal.http.HttpCommunication;
import com.c8db.internal.http.HttpConnectionFactory;
import com.c8db.internal.net.ConnectionFactory;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostDescription;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.net.HostHandler;
import com.c8db.internal.net.HostResolver;
import com.c8db.internal.util.C8DeserializerImpl;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.internal.util.C8SerializerImpl;
import com.c8db.internal.util.DefaultC8Serialization;
import com.c8db.internal.velocystream.VstCommunicationSync;
import com.c8db.internal.velocystream.VstConnectionFactorySync;
import com.c8db.model.LogOptions;
import com.c8db.model.UserCreateOptions;
import com.c8db.model.UserUpdateOptions;
import com.c8db.util.C8CursorInitializer;
import com.c8db.util.C8Deserializer;
import com.c8db.util.C8Serialization;
import com.c8db.util.C8Serializer;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.Response;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;

public interface C8DB
extends C8SerializationAccessor {
    public void shutdown() throws C8DBException;

    public C8Database db();

    public C8Database db(String var1, String var2, String var3, String var4);

    public C8Database db(String var1, String var2);

    public C8Database db(String var1, String var2, Map<String, String> var3);

    public Boolean createGeoFabric(String var1, String var2, String var3, String var4, String var5) throws C8DBException;

    public Collection<String> getGeoFabrics() throws C8DBException;

    public Collection<String> getAccessibleGeoFabrics() throws C8DBException;

    public Collection<String> getAccessibleGeoFabricsFor(String var1) throws C8DBException;

    public Boolean updateDataCentersForGeoFabric(String var1, String var2, String var3) throws C8DBException;

    public GeoFabricEntity getGeoFabricInformation(String var1, String var2) throws C8DBException;

    public Boolean updateSpotRegionForGeoFabric(String var1, String var2, String var3) throws C8DBException;

    public List<DataCenterEntity> getEdgeLocations(String var1) throws C8DBException;

    public List<DcInfoEntity> getAllEdgeLocations() throws C8DBException;

    public DcInfoEntity getLocalEdgeLocation() throws C8DBException;

    public DcInfoEntity getEdgeLocation(String var1) throws C8DBException;

    public Boolean updateSpotStatus(String var1, boolean var2);

    public C8DBVersion getVersion() throws C8DBException;

    public ServerRole getRole() throws C8DBException;

    public UserEntity createUser(String var1, String var2, String var3) throws C8DBException;

    public UserEntity createUser(String var1, String var2, String var3, UserCreateOptions var4) throws C8DBException;

    public void deleteUser(String var1) throws C8DBException;

    public UserEntity getUser(String var1) throws C8DBException;

    public Collection<UserEntity> getUsers() throws C8DBException;

    public UserEntity updateUser(String var1, UserUpdateOptions var2) throws C8DBException;

    public UserEntity replaceUser(String var1, UserUpdateOptions var2) throws C8DBException;

    public void grantDefaultDatabaseAccess(String var1, Permissions var2) throws C8DBException;

    public void grantDefaultCollectionAccess(String var1, Permissions var2) throws C8DBException;

    public Response execute(Request var1) throws C8DBException;

    public Response execute(Request var1, HostHandle var2) throws C8DBException;

    public LogEntity getLogs(LogOptions var1) throws C8DBException;

    public LogLevelEntity getLogLevel() throws C8DBException;

    public LogLevelEntity setLogLevel(LogLevelEntity var1) throws C8DBException;

    public C8DB _setCursorInitializer(C8CursorInitializer var1);

    public static class Builder
    extends InternalC8DBBuilder {
        private static String PROPERTY_KEY_PROTOCOL = "arangodb.protocol";
        protected Protocol protocol;

        @Override
        protected void loadProperties(Properties properties) {
            super.loadProperties(properties);
            this.protocol = Builder.loadProtocol(properties, this.protocol);
        }

        private static Protocol loadProtocol(Properties properties, Protocol currentValue) {
            return Protocol.valueOf(Builder.getProperty(properties, PROPERTY_KEY_PROTOCOL, currentValue, C8Defaults.DEFAULT_NETWORK_PROTOCOL).toUpperCase());
        }

        public Builder useProtocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public Builder loadProperties(InputStream in) throws C8DBException {
            super.loadProperties(in);
            return this;
        }

        public Builder host(String host, int port) {
            this.setHost(Service.C8DB, host, port);
            return this;
        }

        public Builder serviceHost(Service service, String host, int port) {
            this.setHost(service, host, port);
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.setTimeout(timeout);
            return this;
        }

        public Builder responseSizeLimit(Integer responseSizeLimit) {
            this.setResponseSizeLimit(responseSizeLimit);
            return this;
        }

        public Builder user(String user) {
            this.setUser(user);
            return this;
        }

        public Builder password(String password) {
            this.setPassword(password);
            return this;
        }

        public Builder email(String email) {
            this.setEmail(email);
            return this;
        }

        public Builder jwtToken(String jwt) {
            this.setJwtToken(jwt);
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.setApiKey(apiKey);
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.setUseSsl(useSsl);
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.setSslContext(sslContext);
            return this;
        }

        public Builder chunksize(Integer chunksize) {
            this.setChunksize(chunksize);
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.setMaxConnections(maxConnections);
            return this;
        }

        public Builder connectionTtl(Long connectionTtl) {
            this.setConnectionTtl(connectionTtl);
            return this;
        }

        public Builder acquireHostList(Boolean acquireHostList) {
            this.setAcquireHostList(acquireHostList);
            return this;
        }

        public Builder acquireHostListInterval(Integer acquireHostListInterval) {
            this.setAcquireHostListInterval(acquireHostListInterval);
            return this;
        }

        public Builder loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
            this.setLoadBalancingStrategy(loadBalancingStrategy);
            return this;
        }

        public <T> Builder registerSerializer(Class<T> clazz, VPackSerializer<T> serializer) {
            this.vpackBuilder.registerSerializer(clazz, serializer);
            return this;
        }

        public <T> Builder registerEnclosingSerializer(Class<T> clazz, VPackSerializer<T> serializer) {
            this.vpackBuilder.registerEnclosingSerializer(clazz, serializer);
            return this;
        }

        public <T> Builder registerDeserializer(Class<T> clazz, VPackDeserializer<T> deserializer) {
            this.vpackBuilder.registerDeserializer(clazz, deserializer);
            return this;
        }

        public <T> Builder registerInstanceCreator(Class<T> clazz, VPackInstanceCreator<T> creator) {
            this.vpackBuilder.registerInstanceCreator(clazz, creator);
            return this;
        }

        public Builder registerJsonDeserializer(ValueType type, VPackJsonDeserializer deserializer) {
            this.vpackParserBuilder.registerDeserializer(type, deserializer);
            return this;
        }

        public Builder registerJsonDeserializer(String attribute, ValueType type, VPackJsonDeserializer deserializer) {
            this.vpackParserBuilder.registerDeserializer(attribute, type, deserializer);
            return this;
        }

        public <T> Builder registerJsonSerializer(Class<T> clazz, VPackJsonSerializer<T> serializer) {
            this.vpackParserBuilder.registerSerializer(clazz, serializer);
            return this;
        }

        public <T> Builder registerJsonSerializer(String attribute, Class<T> clazz, VPackJsonSerializer<T> serializer) {
            this.vpackParserBuilder.registerSerializer(attribute, clazz, serializer);
            return this;
        }

        public <A extends Annotation> Builder annotationFieldFilter(Class<A> type, VPackAnnotationFieldFilter<A> fieldFilter) {
            this.vpackBuilder.annotationFieldFilter(type, fieldFilter);
            return this;
        }

        public <A extends Annotation> Builder annotationFieldNaming(Class<A> type, VPackAnnotationFieldNaming<A> fieldNaming) {
            this.vpackBuilder.annotationFieldNaming(type, fieldNaming);
            return this;
        }

        public Builder registerModule(VPackModule module) {
            this.vpackBuilder.registerModule(module);
            return this;
        }

        public Builder registerModules(VPackModule ... modules) {
            this.vpackBuilder.registerModules(modules);
            return this;
        }

        public Builder registerJsonModule(VPackParserModule module) {
            this.vpackParserBuilder.registerModule(module);
            return this;
        }

        public Builder registerJsonModules(VPackParserModule ... modules) {
            this.vpackParserBuilder.registerModules(modules);
            return this;
        }

        @Deprecated
        public Builder setSerializer(C8Serializer serializer) {
            this.serializer(serializer);
            return this;
        }

        @Deprecated
        public Builder setDeserializer(C8Deserializer deserializer) {
            this.deserializer(deserializer);
            return this;
        }

        public Builder serializer(C8Serialization serialization) {
            this.setSerializer(serialization);
            return this;
        }

        public synchronized C8DB build() {
            if (((List)this.hosts.get((Object)Service.C8DB)).isEmpty()) {
                ((List)this.hosts.get((Object)Service.C8DB)).add(this.host);
            }
            if (((List)this.hosts.get((Object)Service.C8STREAMS)).isEmpty()) {
                ((List)this.hosts.get((Object)Service.C8STREAMS)).addAll((Collection)this.hosts.get((Object)Service.C8DB));
            }
            if (((List)this.hosts.get((Object)Service.C8FUNCTION)).isEmpty()) {
                ((List)this.hosts.get((Object)Service.C8FUNCTION)).addAll((Collection)this.hosts.get((Object)Service.C8DB));
            }
            VPack vpacker = this.vpackBuilder.serializeNullValues(false).build();
            VPack vpackerNull = this.vpackBuilder.serializeNullValues(true).build();
            VPackParser vpackParser = this.vpackParserBuilder.build();
            C8Serializer serializerTemp = this.serializer != null ? this.serializer : new C8SerializerImpl(vpacker, vpackerNull, vpackParser);
            C8Deserializer deserializerTemp = this.deserializer != null ? this.deserializer : new C8DeserializerImpl(vpackerNull, vpackParser);
            DefaultC8Serialization internal = new DefaultC8Serialization(serializerTemp, deserializerTemp);
            C8Serialization custom = this.customSerializer != null ? this.customSerializer : internal;
            C8SerializationFactory util = new C8SerializationFactory(internal, custom);
            int protocolMaxConnections = this.protocol == Protocol.VST ? 1 : 20;
            int max = this.maxConnections != null ? Math.max(1, this.maxConnections) : protocolMaxConnections;
            ConnectionFactory connectionFactory = this.protocol == null || Protocol.VST == this.protocol ? new VstConnectionFactorySync(this.timeout, this.connectionTtl, this.useSsl, this.sslContext) : new HttpConnectionFactory(this.timeout, this.responseSizeLimit, this.user, this.password, this.email, this.jwtAuth, this.useSsl, this.sslContext, custom, this.protocol, this.connectionTtl, this.httpCookieSpec, this.jwtToken, this.apiKey, (HostDescription)((List)this.hosts.get((Object)Service.C8DB)).get(0));
            Map<Service, Collection<Host>> hostsMatrix = this.createHostMatrix(max, connectionFactory);
            HostResolver hostResolver = this.createHostResolver(hostsMatrix, max, connectionFactory);
            Map<Service, HostHandler> hostHandlerMatrix = this.createHostHandlerMatrix(hostResolver);
            return new C8DBImpl(new VstCommunicationSync.Builder(hostHandlerMatrix).timeout(this.timeout).user(this.user).password(this.password).useSsl(this.useSsl).sslContext(this.sslContext).chunksize(this.chunksize).maxConnections(this.maxConnections).connectionTtl(this.connectionTtl), new HttpCommunication.Builder(hostHandlerMatrix), util, this.protocol, hostResolver, new C8Context());
        }
    }
}

