/*
 * Decompiled with CFR 0.152.
 */
package com.c8db;

import com.c8db.entity.ErrorEntity;

public class C8DBException
extends RuntimeException {
    private static final long serialVersionUID = 6165638002614173801L;
    private final ErrorEntity entity;
    private final Integer responseCode;

    public C8DBException(ErrorEntity errorEntity) {
        super(String.format("Response: %s, Error: %s - %s", errorEntity.getCode(), errorEntity.getErrorNum(), errorEntity.getErrorMessage()));
        this.entity = errorEntity;
        this.responseCode = null;
    }

    public C8DBException(String message) {
        super(message);
        this.entity = null;
        this.responseCode = null;
    }

    public C8DBException(String message, Integer responseCode) {
        super(message);
        this.entity = null;
        this.responseCode = responseCode;
    }

    public C8DBException(Throwable cause) {
        super(cause);
        this.entity = null;
        this.responseCode = null;
    }

    public C8DBException(String message, Throwable cause) {
        super(message, cause);
        this.entity = null;
        this.responseCode = null;
    }

    public String getErrorMessage() {
        return this.entity != null ? this.entity.getErrorMessage() : null;
    }

    public String getException() {
        return this.entity != null ? this.entity.getException() : null;
    }

    public Integer getResponseCode() {
        Integer entityResponseCode = this.entity != null ? Integer.valueOf(this.entity.getCode()) : null;
        return this.responseCode != null ? this.responseCode : entityResponseCode;
    }

    public Integer getErrorNum() {
        return this.entity != null ? Integer.valueOf(this.entity.getErrorNum()) : null;
    }
}

