/*
 * Decompiled with CFR 0.152.
 */
package com.c8db;

import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackSlice;
import com.c8db.C8DBException;
import com.c8db.jackson.dataformat.velocypack.VPackMapper;
import com.c8db.util.C8Serialization;
import com.c8db.util.C8Serializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;

public class VelocyJack
implements C8Serialization {
    private final ObjectMapper vpackMapper = new VPackMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final ObjectMapper vpackMapperNull = new VPackMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS);
    private final ObjectMapper jsonMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final VPackParser vpackParser = new VPackParser.Builder().build();

    public void configure(ConfigureFunction f) {
        f.configure(this.vpackMapper);
        f.configure(this.vpackMapperNull);
        f.configure(this.jsonMapper);
    }

    @Override
    public VPackSlice serialize(Object entity) throws C8DBException {
        return this.serialize(entity, new C8Serializer.Options());
    }

    @Override
    public VPackSlice serialize(Object entity, C8Serializer.Options options) throws C8DBException {
        if (options.getType() == null) {
            options.type(entity.getClass());
        }
        try {
            VPackSlice vpack;
            Class<?> type = entity.getClass();
            boolean serializeNullValues = options.isSerializeNullValues();
            if (String.class.isAssignableFrom(type)) {
                vpack = this.vpackParser.fromJson((String)entity, serializeNullValues);
            } else if (options.isStringAsJson() && Iterable.class.isAssignableFrom(type)) {
                Iterator iterator = ((Iterable)Iterable.class.cast(entity)).iterator();
                if (iterator.hasNext() && String.class.isAssignableFrom(iterator.next().getClass())) {
                    vpack = this.vpackParser.fromJson((Iterable)entity, serializeNullValues);
                } else {
                    ObjectMapper vp = serializeNullValues ? this.vpackMapperNull : this.vpackMapper;
                    vpack = new VPackSlice(vp.writeValueAsBytes(entity));
                }
            } else {
                ObjectMapper vp = serializeNullValues ? this.vpackMapperNull : this.vpackMapper;
                vpack = new VPackSlice(vp.writeValueAsBytes(entity));
            }
            return vpack;
        }
        catch (JsonProcessingException e) {
            throw new C8DBException(e);
        }
    }

    @Override
    public <T> T deserialize(VPackSlice vpack, Type type) throws C8DBException {
        try {
            Object doc;
            if (type == String.class && !vpack.isString()) {
                JsonNode node = this.vpackMapper.readTree(Arrays.copyOfRange(vpack.getBuffer(), vpack.getStart(), vpack.getStart() + vpack.getByteSize()));
                doc = this.jsonMapper.writeValueAsString((Object)node);
            } else {
                doc = this.vpackMapper.readValue(vpack.getBuffer(), vpack.getStart(), vpack.getStart() + vpack.getByteSize(), (Class)type);
            }
            return (T)doc;
        }
        catch (IOException e) {
            throw new C8DBException(e);
        }
    }

    public static interface ConfigureFunction {
        public void configure(ObjectMapper var1);
    }
}

