/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.c8db.C8Admin;
import com.c8db.C8DBException;
import com.c8db.entity.FeaturesEntity;
import com.c8db.entity.LimitsEntity;
import com.c8db.entity.TenantEntity;
import com.c8db.entity.TenantMetricsEntity;
import com.c8db.entity.TenantsEntity;
import com.c8db.internal.C8DBImpl;
import com.c8db.internal.C8DatabaseImpl;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.InternalC8Admin;
import com.c8db.model.TenantMetricsOption;
import java.util.List;

public class C8AdminImpl
extends InternalC8Admin<C8DBImpl, C8DatabaseImpl, C8ExecutorSync>
implements C8Admin {
    protected C8AdminImpl(C8DatabaseImpl db) {
        super(db);
    }

    @Override
    public FeaturesEntity getTenantFeatures(String tenant) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getTenantFeaturesRequest(tenant), this.getTenantFeaturesResponseDeserializer());
    }

    @Override
    public Boolean isLimitsEnabled() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getLimitsEnabledRequest(), this.getLimitsEnabledResponseDeserializer());
    }

    @Override
    public LimitsEntity getTenantLimits(String tenant) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getTenantLimitsRequest(tenant), this.getTenantLimitsResponseDeserializer());
    }

    @Override
    public List<TenantsEntity> getTenants() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getTenantsRequest(), this.getTenantsResponseDeserializer());
    }

    @Override
    public TenantEntity getTenant(String tenant) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getTenantRequest(tenant), this.getTenantResponseDeserializer());
    }

    @Override
    public TenantMetricsEntity getTenantMetrics(TenantMetricsOption options) throws C8DBException {
        TenantMetricsEntity tenantMetrics = ((C8ExecutorSync)this.executor).execute(this.getTenantMetricsRequest(options), this.getTenantMetricResponseDeserializer());
        return tenantMetrics;
    }
}

