/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.VPackSlice;
import com.c8db.C8Collection;
import com.c8db.C8DBException;
import com.c8db.entity.CollectionEntity;
import com.c8db.entity.CollectionPropertiesEntity;
import com.c8db.entity.DocumentCreateEntity;
import com.c8db.entity.DocumentDeleteEntity;
import com.c8db.entity.DocumentUpdateEntity;
import com.c8db.entity.IndexEntity;
import com.c8db.entity.MultiDocumentEntity;
import com.c8db.entity.Permissions;
import com.c8db.internal.C8DBImpl;
import com.c8db.internal.C8DatabaseImpl;
import com.c8db.internal.C8Errors;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.InternalC8Collection;
import com.c8db.internal.util.DocumentUtil;
import com.c8db.model.CollectionCountOptions;
import com.c8db.model.CollectionCreateOptions;
import com.c8db.model.CollectionPropertiesOptions;
import com.c8db.model.CollectionTruncateOptions;
import com.c8db.model.DocumentCreateOptions;
import com.c8db.model.DocumentDeleteOptions;
import com.c8db.model.DocumentExistsOptions;
import com.c8db.model.DocumentReadOptions;
import com.c8db.model.DocumentReplaceOptions;
import com.c8db.model.DocumentUpdateOptions;
import com.c8db.model.FulltextIndexOptions;
import com.c8db.model.GeoIndexOptions;
import com.c8db.model.HashIndexOptions;
import com.c8db.model.PersistentIndexOptions;
import com.c8db.model.SkiplistIndexOptions;
import com.c8db.model.TTLIndexOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C8CollectionImpl
extends InternalC8Collection<C8DBImpl, C8DatabaseImpl, C8ExecutorSync>
implements C8Collection {
    private static final Logger LOGGER = LoggerFactory.getLogger(C8Collection.class);

    protected C8CollectionImpl(C8DatabaseImpl db, String name) {
        super(db, name);
    }

    @Override
    public boolean exists() throws C8DBException {
        try {
            this.getInfo();
            return true;
        }
        catch (C8DBException e) {
            if (C8Errors.ERROR_C8_DATA_SOURCE_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public CollectionEntity truncate() throws C8DBException {
        return this.truncate(null);
    }

    @Override
    public CollectionEntity truncate(CollectionTruncateOptions options) throws C8DBException {
        return (CollectionEntity)((C8ExecutorSync)this.executor).execute(this.truncateRequest(options), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionPropertiesEntity count() throws C8DBException {
        return this.count(null);
    }

    @Override
    public CollectionPropertiesEntity count(CollectionCountOptions options) throws C8DBException {
        return (CollectionPropertiesEntity)((C8ExecutorSync)this.executor).execute(this.countRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionEntity create() throws C8DBException {
        return ((C8DatabaseImpl)this.db()).createCollection(this.name());
    }

    @Override
    public CollectionEntity create(CollectionCreateOptions options) throws C8DBException {
        return ((C8DatabaseImpl)this.db()).createCollection(this.name(), options);
    }

    @Override
    public void drop() throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.dropRequest(null), (Type)((Object)Void.class));
    }

    @Override
    public void drop(boolean isSystem) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.dropRequest(isSystem), (Type)((Object)Void.class));
    }

    @Override
    public CollectionEntity getInfo() throws C8DBException {
        return (CollectionEntity)((C8ExecutorSync)this.executor).execute(this.getInfoRequest(), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionPropertiesEntity getProperties() throws C8DBException {
        return (CollectionPropertiesEntity)((C8ExecutorSync)this.executor).execute(this.getPropertiesRequest(), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionPropertiesEntity changeProperties(CollectionPropertiesOptions options) throws C8DBException {
        return (CollectionPropertiesEntity)((C8ExecutorSync)this.executor).execute(this.changePropertiesRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public synchronized CollectionEntity rename(String newName) throws C8DBException {
        CollectionEntity result = (CollectionEntity)((C8ExecutorSync)this.executor).execute(this.renameRequest(newName), (Type)((Object)CollectionEntity.class));
        this.name = result.getName();
        return result;
    }

    @Override
    public void grantAccess(String user, Permissions permissions) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public void revokeAccess(String user) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    @Override
    public void resetAccess(String user) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.resetAccessRequest(user), (Type)((Object)Void.class));
    }

    @Override
    public Permissions getPermissions(String user) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }

    @Override
    public <T> DocumentCreateEntity<T> insertDocument(T value) throws C8DBException {
        return this.insertDocument(value, new DocumentCreateOptions());
    }

    @Override
    public <T> DocumentCreateEntity<T> insertDocument(T value, DocumentCreateOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.insertDocumentRequest(value, options), this.insertDocumentResponseDeserializer(value, options));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentCreateEntity<T>> insertDocuments(Collection<T> values) throws C8DBException {
        return this.insertDocuments(values, new DocumentCreateOptions());
    }

    @Override
    public <T> MultiDocumentEntity<DocumentCreateEntity<T>> insertDocuments(Collection<T> values, DocumentCreateOptions options) throws C8DBException {
        DocumentCreateOptions params = options != null ? options : new DocumentCreateOptions();
        return ((C8ExecutorSync)this.executor).execute(this.insertDocumentsRequest(values, params), this.insertDocumentsResponseDeserializer(values, params));
    }

    @Override
    public <T> T getDocument(String key, Class<T> type) throws C8DBException {
        return this.getDocument(key, type, new DocumentReadOptions());
    }

    @Override
    public <T> T getDocument(String key, Class<T> type, DocumentReadOptions options) throws C8DBException {
        DocumentUtil.validateDocumentKey(key);
        try {
            return ((C8ExecutorSync)this.executor).execute(this.getDocumentRequest(key, options), type);
        }
        catch (C8DBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if (e.getErrorNum() != null && e.getErrorNum() == 1655) {
                throw e;
            }
            if (!(e.getResponseCode() == null || e.getResponseCode() != 404 && e.getResponseCode() != 304 && e.getResponseCode() != 412 || options != null && !options.isCatchException())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public <T> MultiDocumentEntity<T> getDocuments(Collection<String> keys, Class<T> type) throws C8DBException {
        return this.getDocuments(keys, type, new DocumentReadOptions());
    }

    @Override
    public <T> MultiDocumentEntity<T> getDocuments(Collection<String> keys, Class<T> type, DocumentReadOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getDocumentsRequest(keys, options), this.getDocumentsResponseDeserializer(type, options));
    }

    @Override
    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value) throws C8DBException {
        return this.replaceDocument(key, value, new DocumentReplaceOptions());
    }

    @Override
    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value, DocumentReplaceOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.replaceDocumentRequest(key, value, options), this.replaceDocumentResponseDeserializer(value, options));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> replaceDocuments(Collection<T> values) throws C8DBException {
        return this.replaceDocuments(values, new DocumentReplaceOptions());
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> replaceDocuments(Collection<T> values, DocumentReplaceOptions options) throws C8DBException {
        DocumentReplaceOptions params = options != null ? options : new DocumentReplaceOptions();
        return ((C8ExecutorSync)this.executor).execute(this.replaceDocumentsRequest(values, params), this.replaceDocumentsResponseDeserializer(values, params));
    }

    @Override
    public <T> DocumentUpdateEntity<T> updateDocument(String key, T value) throws C8DBException {
        return this.updateDocument(key, value, new DocumentUpdateOptions());
    }

    @Override
    public <T> DocumentUpdateEntity<T> updateDocument(String key, T value, DocumentUpdateOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.updateDocumentRequest(key, value, options), this.updateDocumentResponseDeserializer(value, options));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> updateDocuments(Collection<T> values) throws C8DBException {
        return this.updateDocuments(values, new DocumentUpdateOptions());
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> updateDocuments(Collection<T> values, DocumentUpdateOptions options) throws C8DBException {
        DocumentUpdateOptions params = options != null ? options : new DocumentUpdateOptions();
        return ((C8ExecutorSync)this.executor).execute(this.updateDocumentsRequest(values, params), this.updateDocumentsResponseDeserializer(values, params));
    }

    @Override
    public DocumentDeleteEntity<Void> deleteDocument(String key) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.deleteDocumentRequest(key, new DocumentDeleteOptions()), this.deleteDocumentResponseDeserializer(Void.class));
    }

    @Override
    public <T> DocumentDeleteEntity<T> deleteDocument(String key, Class<T> type, DocumentDeleteOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.deleteDocumentRequest(key, options), this.deleteDocumentResponseDeserializer(type));
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteDocuments(Collection<?> values) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.deleteDocumentsRequest(values, new DocumentDeleteOptions()), this.deleteDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentDeleteEntity<T>> deleteDocuments(Collection<?> values, Class<T> type, DocumentDeleteOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(type));
    }

    @Override
    public Boolean documentExists(String key) {
        return this.documentExists(key, new DocumentExistsOptions());
    }

    @Override
    public Boolean documentExists(String key, DocumentExistsOptions options) throws C8DBException {
        try {
            ((C8ExecutorSync)this.executor).execute(this.documentExistsRequest(key, options), (Type)((Object)VPackSlice.class));
            return true;
        }
        catch (C8DBException e) {
            if (e.getErrorNum() != null && e.getErrorNum() == 1655) {
                throw e;
            }
            if (!(e.getResponseCode() == null || e.getResponseCode() != 404 && e.getResponseCode() != 304 && e.getResponseCode() != 412 || options != null && !options.isCatchException())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public IndexEntity getIndex(String id) throws C8DBException {
        return (IndexEntity)((C8ExecutorSync)this.executor).execute(this.getIndexRequest(id), (Type)((Object)IndexEntity.class));
    }

    @Override
    public String deleteIndex(String id) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.deleteIndexRequest(id), this.deleteIndexResponseDeserializer());
    }

    @Override
    public IndexEntity ensureHashIndex(Iterable<String> fields, HashIndexOptions options) throws C8DBException {
        return (IndexEntity)((C8ExecutorSync)this.executor).execute(this.createHashIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureSkiplistIndex(Iterable<String> fields, SkiplistIndexOptions options) throws C8DBException {
        return (IndexEntity)((C8ExecutorSync)this.executor).execute(this.createSkiplistIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensurePersistentIndex(Iterable<String> fields, PersistentIndexOptions options) throws C8DBException {
        return (IndexEntity)((C8ExecutorSync)this.executor).execute(this.createPersistentIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureGeoIndex(Iterable<String> fields, GeoIndexOptions options) throws C8DBException {
        return (IndexEntity)((C8ExecutorSync)this.executor).execute(this.createGeoIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureFulltextIndex(Iterable<String> fields, FulltextIndexOptions options) throws C8DBException {
        return (IndexEntity)((C8ExecutorSync)this.executor).execute(this.createFulltextIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureTTLIndex(Iterable<String> fields, TTLIndexOptions options) throws C8DBException {
        return (IndexEntity)((C8ExecutorSync)this.executor).execute(this.createTTLIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public Collection<IndexEntity> getIndexes() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getIndexesRequest(), this.getIndexesResponseDeserializer());
    }
}

