/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.exception.VPackException;
import com.c8db.C8DB;
import com.c8db.C8DBException;
import com.c8db.C8Database;
import com.c8db.Protocol;
import com.c8db.entity.C8DBVersion;
import com.c8db.entity.DataCenterEntity;
import com.c8db.entity.DcInfoEntity;
import com.c8db.entity.GeoFabricEntity;
import com.c8db.entity.LogEntity;
import com.c8db.entity.LogLevelEntity;
import com.c8db.entity.Permissions;
import com.c8db.entity.ServerRole;
import com.c8db.entity.UserEntity;
import com.c8db.internal.C8Context;
import com.c8db.internal.C8DatabaseImpl;
import com.c8db.internal.C8Executor;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.DocumentCache;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.http.HttpCommunication;
import com.c8db.internal.http.HttpProtocol;
import com.c8db.internal.net.CommunicationProtocol;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.net.HostResolver;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.internal.velocystream.VstCommunicationSync;
import com.c8db.internal.velocystream.VstProtocol;
import com.c8db.model.LogOptions;
import com.c8db.model.UserCreateOptions;
import com.c8db.model.UserUpdateOptions;
import com.c8db.util.C8CursorInitializer;
import com.c8db.util.C8Serialization;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C8DBImpl
extends InternalC8DB<C8ExecutorSync>
implements C8DB {
    private static final Logger LOGGER = LoggerFactory.getLogger(C8DBImpl.class);
    private C8CursorInitializer cursorInitializer;
    private CommunicationProtocol cp;

    public C8DBImpl(VstCommunicationSync.Builder vstBuilder, HttpCommunication.Builder httpBuilder, C8SerializationFactory util, Protocol protocol, HostResolver hostResolver, C8Context context) {
        super(new C8ExecutorSync(C8DBImpl.createProtocol(vstBuilder, httpBuilder, util.get(C8SerializationFactory.Serializer.INTERNAL), protocol), util, new DocumentCache()), util, context);
        this.cp = C8DBImpl.createProtocol(new VstCommunicationSync.Builder(vstBuilder).maxConnections(1), new HttpCommunication.Builder(httpBuilder), util.get(C8SerializationFactory.Serializer.INTERNAL), protocol);
        hostResolver.init(this.executor(), this.util());
        LOGGER.debug("ArangoDB Client is ready to use");
    }

    private static CommunicationProtocol createProtocol(VstCommunicationSync.Builder vstBuilder, HttpCommunication.Builder httpBuilder, C8Serialization util, Protocol protocol) {
        return protocol == null || Protocol.VST == protocol ? C8DBImpl.createVST(vstBuilder, util) : C8DBImpl.createHTTP(httpBuilder, util);
    }

    private static CommunicationProtocol createVST(VstCommunicationSync.Builder builder, C8Serialization util) {
        return new VstProtocol(builder.build(util));
    }

    private static CommunicationProtocol createHTTP(HttpCommunication.Builder builder, C8Serialization util) {
        return new HttpProtocol(builder.build(util));
    }

    @Override
    protected C8ExecutorSync executor() {
        return (C8ExecutorSync)this.executor;
    }

    @Override
    public void shutdown() throws C8DBException {
        try {
            ((C8ExecutorSync)this.executor).disconnect();
            this.cp.close();
        }
        catch (IOException e) {
            throw new C8DBException(e);
        }
    }

    @Override
    public C8Database db() {
        return this.db("demo", "_system", "", "");
    }

    @Override
    public C8Database db(String tenant, String name) {
        return this.db(tenant, name, "", "");
    }

    @Override
    public C8Database db(String tenant, String name, String spotDc, String dcList) {
        return new C8DatabaseImpl(this, tenant, name, spotDc, dcList).setCursorInitializer(this.cursorInitializer);
    }

    @Override
    public C8Database db(String tenant, String name, Map<String, String> headerParams) {
        this.context.getHeaderParam().putAll(headerParams);
        return this.db(tenant, name, "", "");
    }

    @Override
    public Boolean createGeoFabric(String tenant, String name, String spotDc, String dcList, String geoFabric) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.createGeoFabricRequest(tenant, name, spotDc, dcList, geoFabric), this.createGeoFabricResponseDeserializer());
    }

    @Override
    public Collection<String> getGeoFabrics() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getGeoFabricsRequest(this.db().tenant(), this.db().name()), this.getGeoFabricsResponseDeserializer());
    }

    @Override
    public Collection<String> getAccessibleGeoFabrics() throws C8DBException {
        return this.db().getAccessibleGeoFabrics();
    }

    @Override
    public Collection<String> getAccessibleGeoFabricsFor(String user) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getAccessibleGeoFabricsForRequest(this.db().tenant(), this.db().name(), user, false), this.getAccessibleGeoFabricsForResponseDeserializer());
    }

    @Override
    public Boolean updateDataCentersForGeoFabric(String tenant, String name, String dcList) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.updateDCListRequest(tenant, name, dcList), this.updateDCListResponseDeserializer());
    }

    @Override
    public Boolean updateSpotRegionForGeoFabric(String tenant, String name, String spotDc) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.updateSpotDcRequest(tenant, name, spotDc), this.updateSpotDcResponseDeserializer());
    }

    @Override
    public GeoFabricEntity getGeoFabricInformation(String tenant, String name) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getGeoFabricInfoRequest(tenant, name), this.getGeoFabricInfoResponseDeserializer());
    }

    @Override
    public List<DataCenterEntity> getEdgeLocations(String tenant) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getEdgeLocationsRequest(tenant), this.getEdgeLocationsResponseDeserializer());
    }

    @Override
    public List<DcInfoEntity> getAllEdgeLocations() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getAllEdgeLocationsRequest(), this.getAllEdgeLocationsResponseDeserializer());
    }

    @Override
    public DcInfoEntity getLocalEdgeLocation() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getLocalEdgeLocationRequest(), this.getLocalEdgeLocationResponseDeserializer());
    }

    @Override
    public DcInfoEntity getEdgeLocation(String dcName) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getEdgeLocationRequest(dcName), this.getEdgeLocationResponseDeserializer());
    }

    @Override
    public Boolean updateSpotStatus(String dcName, boolean isSpot) {
        return ((C8ExecutorSync)this.executor).execute(this.updateSpotStatusRequest(dcName, isSpot), this.BooleanResponseDeserializer());
    }

    @Override
    public C8DBVersion getVersion() throws C8DBException {
        return this.db().getVersion();
    }

    @Override
    public ServerRole getRole() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getRoleRequest(), this.getRoleResponseDeserializer());
    }

    @Override
    public UserEntity createUser(String user, String passwd, String email) throws C8DBException {
        return (UserEntity)((C8ExecutorSync)this.executor).execute(this.createUserRequest(this.db().tenant(), "_system", user, passwd, email, new UserCreateOptions()), (Type)((Object)UserEntity.class));
    }

    @Override
    public UserEntity createUser(String user, String passwd, String email, UserCreateOptions options) throws C8DBException {
        return (UserEntity)((C8ExecutorSync)this.executor).execute(this.createUserRequest(this.db().tenant(), "_system", user, passwd, email, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public void deleteUser(String user) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.deleteUserRequest(this.db().tenant(), "_system", user), (Type)((Object)Void.class));
    }

    @Override
    public UserEntity getUser(String user) throws C8DBException {
        return (UserEntity)((C8ExecutorSync)this.executor).execute(this.getUserRequest(this.db().tenant(), "_system", user), (Type)((Object)UserEntity.class));
    }

    @Override
    public Collection<UserEntity> getUsers() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getUsersRequest(this.db().tenant(), "_system"), this.getUsersResponseDeserializer());
    }

    @Override
    public UserEntity updateUser(String user, UserUpdateOptions options) throws C8DBException {
        return (UserEntity)((C8ExecutorSync)this.executor).execute(this.updateUserRequest(this.db().tenant(), "_system", user, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public UserEntity replaceUser(String user, UserUpdateOptions options) throws C8DBException {
        return (UserEntity)((C8ExecutorSync)this.executor).execute(this.replaceUserRequest(this.db().tenant(), "_system", user, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public void grantDefaultDatabaseAccess(String user, Permissions permissions) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.updateUserDefaultDatabaseAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public void grantDefaultCollectionAccess(String user, Permissions permissions) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public Response execute(Request request) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(request, new C8Executor.ResponseDeserializer<Response>(){

            @Override
            public Response deserialize(Response response) throws VPackException {
                return response;
            }
        });
    }

    @Override
    public Response execute(Request request, HostHandle hostHandle) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(request, new C8Executor.ResponseDeserializer<Response>(){

            @Override
            public Response deserialize(Response response) throws VPackException {
                return response;
            }
        }, hostHandle);
    }

    @Override
    public LogEntity getLogs(LogOptions options) throws C8DBException {
        return (LogEntity)((C8ExecutorSync)this.executor).execute(this.getLogsRequest(options), (Type)((Object)LogEntity.class));
    }

    @Override
    public LogLevelEntity getLogLevel() throws C8DBException {
        return (LogLevelEntity)((C8ExecutorSync)this.executor).execute(this.getLogLevelRequest(), (Type)((Object)LogLevelEntity.class));
    }

    @Override
    public LogLevelEntity setLogLevel(LogLevelEntity entity) throws C8DBException {
        return (LogLevelEntity)((C8ExecutorSync)this.executor).execute(this.setLogLevelRequest(entity), (Type)((Object)LogLevelEntity.class));
    }

    @Override
    public C8DBImpl _setCursorInitializer(C8CursorInitializer cursorInitializer) {
        this.cursorInitializer = cursorInitializer;
        return this;
    }
}

