/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.c8db.C8Admin;
import com.c8db.C8Alerts;
import com.c8db.C8ApiKeys;
import com.c8db.C8Collection;
import com.c8db.C8Compute;
import com.c8db.C8Cursor;
import com.c8db.C8DBException;
import com.c8db.C8Database;
import com.c8db.C8Dynamo;
import com.c8db.C8Event;
import com.c8db.C8Graph;
import com.c8db.C8KeyValue;
import com.c8db.C8Redis;
import com.c8db.C8Stream;
import com.c8db.Restql;
import com.c8db.Service;
import com.c8db.entity.C8DBVersion;
import com.c8db.entity.C8StreamEntity;
import com.c8db.entity.C8qlExecutionExplainEntity;
import com.c8db.entity.C8qlParseEntity;
import com.c8db.entity.CollectionEntity;
import com.c8db.entity.CursorEntity;
import com.c8db.entity.DatabaseEntity;
import com.c8db.entity.EdgeDefinition;
import com.c8db.entity.GeoFabricPermissions;
import com.c8db.entity.GraphEntity;
import com.c8db.entity.IndexEntity;
import com.c8db.entity.Permissions;
import com.c8db.entity.QueryEntity;
import com.c8db.entity.QueryTrackingPropertiesEntity;
import com.c8db.entity.StreamTransactionEntity;
import com.c8db.entity.TransactionEntity;
import com.c8db.entity.TraversalEntity;
import com.c8db.entity.UserQueryEntity;
import com.c8db.entity.UserQueryOptions;
import com.c8db.internal.C8AdminImpl;
import com.c8db.internal.C8AlertsImpl;
import com.c8db.internal.C8ApiKeysImpl;
import com.c8db.internal.C8CollectionImpl;
import com.c8db.internal.C8ComputeImpl;
import com.c8db.internal.C8CursorExecute;
import com.c8db.internal.C8DBImpl;
import com.c8db.internal.C8DynamoImpl;
import com.c8db.internal.C8Errors;
import com.c8db.internal.C8EventImpl;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.C8GraphImpl;
import com.c8db.internal.C8KeyValueImpl;
import com.c8db.internal.C8RedisImpl;
import com.c8db.internal.C8StreamImpl;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.RestqlImpl;
import com.c8db.internal.cursor.C8CursorImpl;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.util.DocumentUtil;
import com.c8db.model.C8StreamCreateOptions;
import com.c8db.model.C8TransactionOptions;
import com.c8db.model.C8qlQueryExplainOptions;
import com.c8db.model.C8qlQueryOptions;
import com.c8db.model.CollectionCreateOptions;
import com.c8db.model.CollectionsReadOptions;
import com.c8db.model.DocumentReadOptions;
import com.c8db.model.GraphCreateOptions;
import com.c8db.model.StreamTransactionOptions;
import com.c8db.model.TraversalOptions;
import com.c8db.util.C8CursorInitializer;
import com.c8db.velocystream.Request;
import java.util.Collection;
import java.util.Map;

public class C8DatabaseImpl
extends InternalC8Database<C8DBImpl, C8ExecutorSync>
implements C8Database {
    private C8CursorInitializer cursorInitializer;

    protected C8DatabaseImpl(C8DBImpl c8DB, String tenant, String name, String spotDc, String dcList) {
        super(c8DB, tenant, name, spotDc, dcList);
    }

    @Override
    public C8DBVersion getVersion() throws C8DBException {
        return (C8DBVersion)((C8ExecutorSync)this.executor).execute(this.getVersionRequest(), (java.lang.reflect.Type)((Object)C8DBVersion.class));
    }

    @Override
    public boolean exists() throws C8DBException {
        try {
            this.getInfo();
            return true;
        }
        catch (C8DBException e) {
            if (C8Errors.ERROR_C8_DATABASE_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public Collection<String> getAccessibleGeoFabrics() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getAccessibleDatabasesRequest(), this.getAccessibleDatabasesForResponseDeserializer());
    }

    @Override
    public C8Collection collection(String name) {
        return new C8CollectionImpl(this, name);
    }

    @Override
    public CollectionEntity createCollection(String name) throws C8DBException {
        return (CollectionEntity)((C8ExecutorSync)this.executor).execute(this.createCollectionRequest(name, new CollectionCreateOptions()), (java.lang.reflect.Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionEntity createCollection(String name, CollectionCreateOptions options) throws C8DBException {
        return (CollectionEntity)((C8ExecutorSync)this.executor).execute(this.createCollectionRequest(name, options), (java.lang.reflect.Type)((Object)CollectionEntity.class));
    }

    @Override
    public Collection<CollectionEntity> getCollections() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getCollectionsRequest(new CollectionsReadOptions()), this.getCollectionsResponseDeserializer());
    }

    @Override
    public Collection<CollectionEntity> getCollections(CollectionsReadOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getCollectionsRequest(options), this.getCollectionsResponseDeserializer());
    }

    @Override
    public IndexEntity getIndex(String id) throws C8DBException {
        DocumentUtil.validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getIndex(split[1]);
    }

    @Override
    public String deleteIndex(String id) throws C8DBException {
        DocumentUtil.validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).deleteIndex(split[1]);
    }

    @Override
    public Boolean create() throws C8DBException {
        return ((C8DBImpl)this.c8db()).createGeoFabric(this.tenant(), this.name(), this.spotDc(), this.dcList(), this.name());
    }

    @Override
    public Boolean create(String geoFabric) throws C8DBException {
        return ((C8DBImpl)this.c8db()).createGeoFabric(this.tenant(), this.name(), this.spotDc(), this.dcList(), geoFabric);
    }

    @Override
    public Boolean drop() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.dropRequest(), this.createDropResponseDeserializer());
    }

    @Override
    public void grantAccess(String user, Permissions permissions) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.grantAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void grantAccess(String user) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.RW), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void revokeAccess(String user) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void resetAccess(String user) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.resetAccessRequest(user), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public Permissions getPermissions(String user) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }

    @Override
    public Map<String, GeoFabricPermissions> getResourcesPermissions(String user) {
        return ((C8ExecutorSync)this.executor).execute(this.getResourcesRequest(user, true), this.resourcesPermissionsResponseDeserializer());
    }

    @Override
    public Map<String, Permissions> getStreamsPermissions(String user, String fabric, boolean full) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getUserStreamsAccessRequest(user, fabric, full), this.listPermissionsResponseDeserializer());
    }

    @Override
    public Permissions getGeoFabricPermissions(String user, String fabric) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getUserPermissionsRequest(user, fabric), this.permissionsResponseDeserializer());
    }

    @Override
    public Permissions getStreamPermissions(String user, String fabric, String stream) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getUserStreamPermissionsRequest(user, fabric, stream), this.permissionsResponseDeserializer());
    }

    @Override
    public <T> C8Cursor<T> query(String query, Map<String, Object> bindVars, C8qlQueryOptions options, Class<T> type) throws C8DBException {
        Request request = this.queryRequest(query, bindVars, options);
        HostHandle hostHandle = new HostHandle();
        CursorEntity result = (CursorEntity)((C8ExecutorSync)this.executor).execute(request, (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
        return this.createCursor(result, type, options, hostHandle);
    }

    @Override
    public <T> C8Cursor<T> query(String query, Map<String, Object> bindVars, Class<T> type) throws C8DBException {
        return this.query(query, bindVars, null, type);
    }

    @Override
    public <T> C8Cursor<T> query(String query, C8qlQueryOptions options, Class<T> type) throws C8DBException {
        return this.query(query, null, options, type);
    }

    @Override
    public <T> C8Cursor<T> query(String query, Class<T> type) throws C8DBException {
        return this.query(query, null, null, type);
    }

    @Override
    public <T> C8Cursor<T> cursor(String cursorId, Class<T> type) throws C8DBException {
        HostHandle hostHandle = new HostHandle();
        CursorEntity result = (CursorEntity)((C8ExecutorSync)this.executor).execute(this.queryNextRequest(cursorId, null), (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
        return this.createCursor(result, type, null, hostHandle);
    }

    private <T> C8Cursor<T> createCursor(CursorEntity result, Class<T> type, C8qlQueryOptions options, final HostHandle hostHandle) {
        C8CursorExecute execute = new C8CursorExecute(){

            @Override
            public CursorEntity next(String id, Map<String, String> meta) {
                return (CursorEntity)((C8ExecutorSync)C8DatabaseImpl.this.executor).execute(C8DatabaseImpl.this.queryNextRequest(id, meta), (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
            }

            @Override
            public void close(String id, Map<String, String> meta) {
                ((C8ExecutorSync)C8DatabaseImpl.this.executor).execute(C8DatabaseImpl.this.queryCloseRequest(id, meta), (java.lang.reflect.Type)((Object)Void.class), hostHandle);
            }
        };
        return this.cursorInitializer != null ? this.cursorInitializer.createInstance(this, execute, type, result) : new C8CursorImpl<T>(this, execute, type, result);
    }

    @Override
    public C8qlParseEntity parseQuery(String query) throws C8DBException {
        return (C8qlParseEntity)((C8ExecutorSync)this.executor).execute(this.parseQueryRequest(query), (java.lang.reflect.Type)((Object)C8qlParseEntity.class));
    }

    @Override
    public Collection<QueryEntity> getCurrentlyRunningQueries() throws C8DBException {
        return (Collection)((C8ExecutorSync)this.executor).execute(this.getCurrentlyRunningQueriesRequest(), new Type<Collection<QueryEntity>>(){}.getType());
    }

    @Override
    public C8qlExecutionExplainEntity explainQuery(String query, Map<String, Object> bindVars, C8qlQueryExplainOptions options) throws C8DBException {
        return (C8qlExecutionExplainEntity)((C8ExecutorSync)this.executor).execute(this.explainQueryRequest(query, bindVars, options), (java.lang.reflect.Type)((Object)C8qlExecutionExplainEntity.class));
    }

    @Override
    public void clearSlowQueries() throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.clearSlowQueriesRequest(), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public Collection<QueryEntity> getSlowQueries() throws C8DBException {
        return (Collection)((C8ExecutorSync)this.executor).execute(this.getSlowQueriesRequest(), new Type<Collection<QueryEntity>>(){}.getType());
    }

    @Override
    public QueryTrackingPropertiesEntity getQueryTrackingProperties() throws C8DBException {
        return (QueryTrackingPropertiesEntity)((C8ExecutorSync)this.executor).execute(this.getQueryTrackingPropertiesRequest(), (java.lang.reflect.Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public QueryTrackingPropertiesEntity setQueryTrackingProperties(QueryTrackingPropertiesEntity properties) throws C8DBException {
        return (QueryTrackingPropertiesEntity)((C8ExecutorSync)this.executor).execute(this.setQueryTrackingPropertiesRequest(properties), (java.lang.reflect.Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public void killQuery(String id) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.killQueryRequest(id), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public C8Graph graph(String name) {
        return new C8GraphImpl(this, name);
    }

    @Override
    public GraphEntity createGraph(String name, Collection<EdgeDefinition> edgeDefinitions) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.createGraphRequest(name, edgeDefinitions, new GraphCreateOptions()), this.createGraphResponseDeserializer());
    }

    @Override
    public GraphEntity createGraph(String name, Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.createGraphRequest(name, edgeDefinitions, options), this.createGraphResponseDeserializer());
    }

    @Override
    public Collection<GraphEntity> getGraphs() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getGraphsRequest(), this.getGraphsResponseDeserializer());
    }

    @Override
    public <T> T transaction(String action, Class<T> type, C8TransactionOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.transactionRequest(action, options), this.transactionResponseDeserializer(type));
    }

    @Override
    public StreamTransactionEntity beginStreamTransaction(StreamTransactionOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.beginStreamTransactionRequest(options), this.streamTransactionResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity abortStreamTransaction(String id) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.abortStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity getStreamTransaction(String id) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public Collection<TransactionEntity> getStreamTransactions() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getStreamTransactionsRequest(), this.transactionsResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity commitStreamTransaction(String id) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.commitStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public DatabaseEntity getInfo() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    @Override
    public <V, E> TraversalEntity<V, E> executeTraversal(Class<V> vertexClass, Class<E> edgeClass, TraversalOptions options) throws C8DBException {
        Request request = this.executeTraversalRequest(options);
        return ((C8ExecutorSync)this.executor).execute(request, this.executeTraversalResponseDeserializer(vertexClass, edgeClass));
    }

    @Override
    public <T> T getDocument(String id, Class<T> type) throws C8DBException {
        DocumentUtil.validateDocumentId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getDocument(split[1], type);
    }

    @Override
    public <T> T getDocument(String id, Class<T> type, DocumentReadOptions options) throws C8DBException {
        DocumentUtil.validateDocumentId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getDocument(split[1], type, options);
    }

    protected C8DatabaseImpl setCursorInitializer(C8CursorInitializer cursorInitializer) {
        this.cursorInitializer = cursorInitializer;
        return this;
    }

    @Override
    public C8Stream stream(String name) {
        return new C8StreamImpl(this, name);
    }

    @Override
    public String createPersistentStream(String name, C8StreamCreateOptions options) throws C8DBException {
        try {
            return ((C8ExecutorSync)this.executor).execute(this.createC8PersistentStreamRequest(name, options), this.getC8StreamResponseDeserializer(), null, Service.C8STREAMS);
        }
        catch (C8DBException e) {
            if (!C8Errors.ERROR_STREAM_ALREADY_EXISTS.equals(e.getErrorNum())) {
                throw e;
            }
            return (options.getIsLocal() != false ? "c8locals." : "c8globals.") + name;
        }
    }

    @Override
    public Collection<C8StreamEntity> getPersistentStreams(C8StreamCreateOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getC8PersistentStreamsRequest(options), this.getC8StreamsResponseDeserializer(), null, Service.C8STREAMS);
    }

    @Override
    public Collection<C8StreamEntity> getStreams() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getC8StreamsRequest(), this.getC8StreamsResponseDeserializer(), null, Service.C8STREAMS);
    }

    @Override
    public void clearBacklog(boolean isLocal) {
        ((C8ExecutorSync)this.executor).execute(this.clearC8StreamBacklogRequest(isLocal), (java.lang.reflect.Type)((Object)Void.class), null, Service.C8STREAMS);
    }

    @Override
    public int getTtlMessages(boolean isLocal) {
        return ((C8ExecutorSync)this.executor).execute(this.getC8StreamTtlRequest(isLocal), this.getC8StreamTtlResponseDeserializer(), null, Service.C8STREAMS);
    }

    @Override
    public void ttlMessages(int ttl, boolean isLocal) {
        ((C8ExecutorSync)this.executor).execute(this.c8StreamTtlRequest(ttl, isLocal), (java.lang.reflect.Type)((Object)Void.class), null, Service.C8STREAMS);
    }

    @Override
    public void clearBacklog(String subscriptionName, boolean isLocal) {
        ((C8ExecutorSync)this.executor).execute(this.clearC8StreamBacklogRequest(subscriptionName, isLocal), (java.lang.reflect.Type)((Object)Void.class), null, Service.C8STREAMS);
    }

    @Override
    public void unsubscribe(String subscriptionName, boolean isLocal) {
        ((C8ExecutorSync)this.executor).execute(this.unsubscribeRequest(subscriptionName, isLocal), (java.lang.reflect.Type)((Object)Void.class), null, Service.C8STREAMS);
    }

    @Override
    public Restql restql() {
        return new RestqlImpl(this);
    }

    @Override
    public UserQueryEntity createUserQuery(UserQueryOptions userQueryDefinition) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.createUserQueryRequest(userQueryDefinition, null), this.createUserQueryResponseDeserializer());
    }

    @Override
    public UserQueryEntity createUserQuery(UserQueryOptions userQueryDefinition, String user) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.createUserQueryRequest(userQueryDefinition, user), this.createUserQueryResponseDeserializer());
    }

    @Override
    public <T> C8Cursor<T> executeUserQuery(String userName, String name, Map<String, Object> bindVars, Class<T> type) throws C8DBException {
        Request request = this.userQueryRequest(userName, name, bindVars);
        HostHandle hostHandle = new HostHandle();
        CursorEntity result = (CursorEntity)((C8ExecutorSync)this.executor).execute(request, (java.lang.reflect.Type)((Object)CursorEntity.class), hostHandle);
        return this.createCursor(result, type, null, hostHandle);
    }

    @Override
    public C8Event event() {
        return new C8EventImpl(this);
    }

    @Override
    public C8Admin admin() {
        return new C8AdminImpl(this);
    }

    @Override
    public C8ApiKeys apiKeys() {
        return new C8ApiKeysImpl(this);
    }

    @Override
    public C8Alerts alerts() {
        return new C8AlertsImpl(this);
    }

    @Override
    public C8KeyValue kv(String name) {
        return new C8KeyValueImpl(this, name);
    }

    @Override
    public C8Dynamo dynamo(String tableName) {
        return new C8DynamoImpl(this, tableName);
    }

    @Override
    public C8Redis redis(String tableName) {
        return new C8RedisImpl(this, tableName);
    }

    @Override
    public C8Compute compute() {
        return new C8ComputeImpl(this);
    }
}

