/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.c8db.C8DBException;
import com.c8db.C8EdgeCollection;
import com.c8db.entity.EdgeEntity;
import com.c8db.entity.EdgeUpdateEntity;
import com.c8db.internal.C8DBImpl;
import com.c8db.internal.C8DatabaseImpl;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.C8GraphImpl;
import com.c8db.internal.InternalC8EdgeCollection;
import com.c8db.model.EdgeCreateOptions;
import com.c8db.model.EdgeDeleteOptions;
import com.c8db.model.EdgeReplaceOptions;
import com.c8db.model.EdgeUpdateOptions;
import com.c8db.model.GraphDocumentReadOptions;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C8EdgeCollectionImpl
extends InternalC8EdgeCollection<C8DBImpl, C8DatabaseImpl, C8GraphImpl, C8ExecutorSync>
implements C8EdgeCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(C8EdgeCollectionImpl.class);

    protected C8EdgeCollectionImpl(C8GraphImpl graph, String name) {
        super(graph, name);
    }

    @Override
    public <T> EdgeEntity insertEdge(T value) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.insertEdgeRequest(value, new EdgeCreateOptions()), this.insertEdgeResponseDeserializer(value));
    }

    @Override
    public <T> EdgeEntity insertEdge(T value, EdgeCreateOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.insertEdgeRequest(value, options), this.insertEdgeResponseDeserializer(value));
    }

    @Override
    public <T> T getEdge(String key, Class<T> type) throws C8DBException {
        try {
            return ((C8ExecutorSync)this.executor).execute(this.getEdgeRequest(key, new GraphDocumentReadOptions()), this.getEdgeResponseDeserializer(type));
        }
        catch (C8DBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> T getEdge(String key, Class<T> type, GraphDocumentReadOptions options) throws C8DBException {
        try {
            return ((C8ExecutorSync)this.executor).execute(this.getEdgeRequest(key, options), this.getEdgeResponseDeserializer(type));
        }
        catch (C8DBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> EdgeUpdateEntity replaceEdge(String key, T value) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.replaceEdgeRequest(key, value, new EdgeReplaceOptions()), this.replaceEdgeResponseDeserializer(value));
    }

    @Override
    public <T> EdgeUpdateEntity replaceEdge(String key, T value, EdgeReplaceOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.replaceEdgeRequest(key, value, options), this.replaceEdgeResponseDeserializer(value));
    }

    @Override
    public <T> EdgeUpdateEntity updateEdge(String key, T value) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.updateEdgeRequest(key, value, new EdgeUpdateOptions()), this.updateEdgeResponseDeserializer(value));
    }

    @Override
    public <T> EdgeUpdateEntity updateEdge(String key, T value, EdgeUpdateOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.updateEdgeRequest(key, value, options), this.updateEdgeResponseDeserializer(value));
    }

    @Override
    public void deleteEdge(String key) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.deleteEdgeRequest(key, new EdgeDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public void deleteEdge(String key, EdgeDeleteOptions options) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.deleteEdgeRequest(key, options), (Type)((Object)Void.class));
    }
}

