/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.c8db.C8DBException;
import com.c8db.C8Event;
import com.c8db.entity.C8EventEntity;
import com.c8db.entity.C8EventIDEntity;
import com.c8db.internal.C8DBImpl;
import com.c8db.internal.C8DatabaseImpl;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.InternalC8Event;
import com.c8db.model.C8EventCreate;
import com.c8db.model.DocumentDeleteOptions;
import com.c8db.model.DocumentReadOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C8EventImpl
extends InternalC8Event<C8DBImpl, C8DatabaseImpl, C8ExecutorSync>
implements C8Event {
    private static final Logger LOGGER = LoggerFactory.getLogger(C8Event.class);

    protected C8EventImpl(C8DatabaseImpl db) {
        super(db);
    }

    @Override
    public C8EventIDEntity insertEvent(C8EventCreate value) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.insertEventRequest(value), this.insertEventResponseDeserializer());
    }

    @Override
    public C8EventEntity getEvent(String key) throws C8DBException {
        return this.getEvent(key, new DocumentReadOptions());
    }

    @Override
    public C8EventEntity getEvent(String key, DocumentReadOptions options) throws C8DBException {
        try {
            return (C8EventEntity)((C8ExecutorSync)this.executor).execute(this.getEventRequest(key, options), (Type)((Object)C8EventEntity.class));
        }
        catch (C8DBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if (e.getErrorNum() != null && e.getErrorNum() == 1655) {
                throw e;
            }
            if (!(e.getResponseCode() == null || e.getResponseCode() != 404 && e.getResponseCode() != 304 && e.getResponseCode() != 412 || options != null && !options.isCatchException())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Collection<C8EventEntity> getEvents() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getEventsRequest(), this.getEventsResponseDeserializer());
    }

    @Override
    public C8EventIDEntity deleteEvent(String key) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.deleteEventRequest(key, new DocumentDeleteOptions()), this.deleteEventResponseDeserializer());
    }

    @Override
    public Collection<C8EventIDEntity> deleteEvents(Collection<?> keys) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.deleteEventsRequest(keys, new DocumentDeleteOptions()), this.deleteEventsResponseDeserializer());
    }
}

