/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.c8db.C8DBException;
import com.c8db.internal.C8Context;
import com.c8db.internal.C8Executor;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.internal.util.EncodeUtils;
import com.c8db.util.C8Serialization;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public abstract class C8Executeable<E extends C8Executor> {
    private static final String SLASH = "/";
    protected final E executor;
    protected final C8SerializationFactory util;
    protected final C8Context context;

    protected C8Executeable(E executor, C8SerializationFactory util, C8Context context) {
        this.executor = executor;
        this.util = util;
        this.context = context;
    }

    protected E executor() {
        return this.executor;
    }

    public C8Serialization util() {
        return this.util.get(C8SerializationFactory.Serializer.INTERNAL);
    }

    public C8Serialization util(C8SerializationFactory.Serializer serializer) {
        return this.util.get(serializer);
    }

    protected Request request(String tenant, String database, RequestType requestType, String ... path) {
        return this.request(tenant, database, requestType, true, path);
    }

    protected Request request(String tenant, String database, RequestType requestType, boolean retryEnabled, String ... path) {
        Request request = new Request(tenant, database, requestType, retryEnabled, C8Executeable.createPath(path));
        for (Map.Entry<String, String> header : this.context.getHeaderParam().entrySet()) {
            request.putHeaderParam(header.getKey(), header.getValue());
        }
        return request;
    }

    protected static String createPath(String ... params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(SLASH);
            }
            try {
                String param = params[i].contains(SLASH) ? C8Executeable.createPath(params[i].split(SLASH)) : EncodeUtils.encodeURL(params[i]);
                sb.append(param);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new C8DBException(e);
            }
        }
        return sb.toString();
    }
}

