/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.exception.VPackException;
import com.c8db.C8DBException;
import com.c8db.Service;
import com.c8db.entity.MetaAware;
import com.c8db.internal.C8Executor;
import com.c8db.internal.DocumentCache;
import com.c8db.internal.net.CommunicationProtocol;
import com.c8db.internal.net.HostHandle;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C8ExecutorSync
extends C8Executor {
    private static final Logger LOG = LoggerFactory.getLogger(C8ExecutorSync.class);
    private final CommunicationProtocol protocol;

    public C8ExecutorSync(CommunicationProtocol protocol, C8SerializationFactory util, DocumentCache documentCache) {
        super(util, documentCache);
        this.protocol = protocol;
    }

    public <T> T execute(Request request, Type type) throws C8DBException {
        return this.execute(request, type, null);
    }

    public <T> T execute(Request request, Type type, HostHandle hostHandle) throws C8DBException {
        return this.execute(request, type, hostHandle, Service.C8DB);
    }

    public <T> T execute(Request request, final Type type, HostHandle hostHandle, Service service) throws C8DBException {
        return this.execute(request, new C8Executor.ResponseDeserializer<T>(){

            @Override
            public T deserialize(Response response) throws VPackException {
                Object result = C8ExecutorSync.this.createResult(type, response);
                return result;
            }
        }, hostHandle, service);
    }

    public <T> T execute(Request request, C8Executor.ResponseDeserializer<T> responseDeserializer) throws C8DBException {
        return this.execute(request, responseDeserializer, null);
    }

    public <T> T execute(Request request, C8Executor.ResponseDeserializer<T> responseDeserializer, HostHandle hostHandle) throws C8DBException {
        return this.execute(request, responseDeserializer, hostHandle, Service.C8DB);
    }

    public <T> T execute(Request request, C8Executor.ResponseDeserializer<T> responseDeserializer, HostHandle hostHandle, Service service) throws C8DBException {
        try {
            Response response = this.protocol.execute(request, hostHandle, service);
            T deserialize = responseDeserializer.deserialize(response);
            if (deserialize instanceof MetaAware) {
                LOG.debug("Respone is MetaAware " + deserialize.getClass().getName());
                ((MetaAware)deserialize).setMeta(response.getMeta());
            }
            return deserialize;
        }
        catch (VPackException e) {
            throw new C8DBException(e);
        }
    }

    public void disconnect() {
        try {
            this.protocol.close();
        }
        catch (IOException e) {
            throw new C8DBException(e);
        }
    }
}

