/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.c8db.C8DBException;
import com.c8db.C8EdgeCollection;
import com.c8db.C8Graph;
import com.c8db.C8VertexCollection;
import com.c8db.entity.EdgeDefinition;
import com.c8db.entity.GraphEntity;
import com.c8db.internal.C8DBImpl;
import com.c8db.internal.C8DatabaseImpl;
import com.c8db.internal.C8EdgeCollectionImpl;
import com.c8db.internal.C8Errors;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.C8VertexCollectionImpl;
import com.c8db.internal.InternalC8Graph;
import com.c8db.model.GraphCreateOptions;
import java.lang.reflect.Type;
import java.util.Collection;

public class C8GraphImpl
extends InternalC8Graph<C8DBImpl, C8DatabaseImpl, C8ExecutorSync>
implements C8Graph {
    protected C8GraphImpl(C8DatabaseImpl db, String name) {
        super(db, name);
    }

    @Override
    public boolean exists() throws C8DBException {
        try {
            this.getInfo();
            return true;
        }
        catch (C8DBException e) {
            if (C8Errors.ERROR_GRAPH_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public GraphEntity create(Collection<EdgeDefinition> edgeDefinitions) throws C8DBException {
        return ((C8DatabaseImpl)this.db()).createGraph(this.name(), edgeDefinitions);
    }

    @Override
    public GraphEntity create(Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) throws C8DBException {
        return ((C8DatabaseImpl)this.db()).createGraph(this.name(), edgeDefinitions, options);
    }

    @Override
    public void drop() throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public void drop(boolean dropCollections) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.dropRequest(dropCollections), (Type)((Object)Void.class));
    }

    @Override
    public GraphEntity getInfo() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    @Override
    public C8EdgeCollection edgeCollection(String name) {
        return new C8EdgeCollectionImpl(this, name);
    }

    @Override
    public Collection<String> getEdgeDefinitions() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getEdgeDefinitionsRequest(), this.getEdgeDefinitionsDeserializer());
    }

    @Override
    public GraphEntity addEdgeDefinition(EdgeDefinition definition) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.addEdgeDefinitionRequest(definition), this.addEdgeDefinitionResponseDeserializer());
    }

    @Override
    public GraphEntity replaceEdgeDefinition(EdgeDefinition definition) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.replaceEdgeDefinitionRequest(definition), this.replaceEdgeDefinitionResponseDeserializer());
    }

    @Override
    public GraphEntity removeEdgeDefinition(String definitionName) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.removeEdgeDefinitionRequest(definitionName), this.removeEdgeDefinitionResponseDeserializer());
    }

    @Override
    public Collection<String> getVertexCollections() throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getVertexCollectionsRequest(), this.getVertexCollectionsResponseDeserializer());
    }

    @Override
    public GraphEntity addVertexCollection(String name) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.addVertexCollectionRequest(name), this.addVertexCollectionResponseDeserializer());
    }

    @Override
    public C8VertexCollection vertexCollection(String name) {
        return new C8VertexCollectionImpl(this, name);
    }
}

