/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.c8db.C8DBException;
import com.c8db.C8KeyValue;
import com.c8db.entity.BaseKeyValue;
import com.c8db.entity.C8KVEntity;
import com.c8db.entity.DocumentCreateEntity;
import com.c8db.entity.DocumentDeleteEntity;
import com.c8db.entity.MultiDocumentEntity;
import com.c8db.internal.C8DBImpl;
import com.c8db.internal.C8DatabaseImpl;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.InternalC8KeyValue;
import com.c8db.internal.util.DocumentUtil;
import com.c8db.model.C8KVPairReadOptions;
import com.c8db.model.CollectionCreateOptions;
import com.c8db.model.DocumentCreateOptions;
import com.c8db.model.DocumentDeleteOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C8KeyValueImpl
extends InternalC8KeyValue<C8DBImpl, C8DatabaseImpl, C8ExecutorSync>
implements C8KeyValue {
    private static final Logger LOGGER = LoggerFactory.getLogger(C8KeyValueImpl.class);

    protected C8KeyValueImpl(C8DatabaseImpl db, String name) {
        super(db, name);
    }

    @Override
    public C8KVEntity create(Boolean expiration, CollectionCreateOptions options) throws C8DBException {
        return (C8KVEntity)((C8ExecutorSync)this.executor).execute(this.createRequest(this.name, expiration, options), (Type)((Object)C8KVEntity.class));
    }

    @Override
    public void drop() throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public C8KVEntity truncate() throws C8DBException {
        return (C8KVEntity)((C8ExecutorSync)this.executor).execute(this.truncateRequest(), (Type)((Object)Void.class));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentCreateEntity<T>> insertKVPairs(Collection<T> values, DocumentCreateOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.insertKVPairsRequest(values, options), this.insertKVPairsResponseDeserializer(values, options));
    }

    @Override
    public DocumentDeleteEntity<Void> deleteKVPair(String key) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.deleteKVPairRequest(key, new DocumentDeleteOptions()), this.deleteKVPairResponseDeserializer(Void.class));
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteKVPairs(Collection<?> values) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.deleteKVPairsRequest(values, new DocumentDeleteOptions()), this.deleteKVPairsResponseDeserializer(Void.class));
    }

    @Override
    public <T> T getKVPair(String key) throws C8DBException {
        DocumentUtil.validateDocumentKey(key);
        try {
            return ((C8ExecutorSync)this.executor).execute(this.getKVPairRequest(key), (Type)((Object)BaseKeyValue.class));
        }
        catch (C8DBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if (e.getErrorNum() != null && e.getErrorNum() == 1655) {
                throw e;
            }
            if (e.getResponseCode() != null && (e.getResponseCode() == 404 || e.getResponseCode() == 304 || e.getResponseCode() == 412)) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public <T> MultiDocumentEntity<T> getKVPairs(Collection<String> keys, C8KVPairReadOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.getKVPairsRequest(keys, options), this.getKVPairsResponseDeserializer());
    }
}

