/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.c8db.C8DBException;
import com.c8db.C8VertexCollection;
import com.c8db.entity.VertexEntity;
import com.c8db.entity.VertexUpdateEntity;
import com.c8db.internal.C8DBImpl;
import com.c8db.internal.C8DatabaseImpl;
import com.c8db.internal.C8ExecutorSync;
import com.c8db.internal.C8GraphImpl;
import com.c8db.internal.InternalC8VertexCollection;
import com.c8db.model.GraphDocumentReadOptions;
import com.c8db.model.VertexCreateOptions;
import com.c8db.model.VertexDeleteOptions;
import com.c8db.model.VertexReplaceOptions;
import com.c8db.model.VertexUpdateOptions;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C8VertexCollectionImpl
extends InternalC8VertexCollection<C8DBImpl, C8DatabaseImpl, C8GraphImpl, C8ExecutorSync>
implements C8VertexCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(C8VertexCollectionImpl.class);

    protected C8VertexCollectionImpl(C8GraphImpl graph, String name) {
        super(graph, name);
    }

    @Override
    public void drop() throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public <T> VertexEntity insertVertex(T value) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.insertVertexRequest(value, new VertexCreateOptions()), this.insertVertexResponseDeserializer(value));
    }

    @Override
    public <T> VertexEntity insertVertex(T value, VertexCreateOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.insertVertexRequest(value, options), this.insertVertexResponseDeserializer(value));
    }

    @Override
    public <T> T getVertex(String key, Class<T> type) throws C8DBException {
        try {
            return ((C8ExecutorSync)this.executor).execute(this.getVertexRequest(key, new GraphDocumentReadOptions()), this.getVertexResponseDeserializer(type));
        }
        catch (C8DBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> T getVertex(String key, Class<T> type, GraphDocumentReadOptions options) throws C8DBException {
        try {
            return ((C8ExecutorSync)this.executor).execute(this.getVertexRequest(key, options), this.getVertexResponseDeserializer(type));
        }
        catch (C8DBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public <T> VertexUpdateEntity replaceVertex(String key, T value) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.replaceVertexRequest(key, value, new VertexReplaceOptions()), this.replaceVertexResponseDeserializer(value));
    }

    @Override
    public <T> VertexUpdateEntity replaceVertex(String key, T value, VertexReplaceOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.replaceVertexRequest(key, value, options), this.replaceVertexResponseDeserializer(value));
    }

    @Override
    public <T> VertexUpdateEntity updateVertex(String key, T value) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.updateVertexRequest(key, value, new VertexUpdateOptions()), this.updateVertexResponseDeserializer(value));
    }

    @Override
    public <T> VertexUpdateEntity updateVertex(String key, T value, VertexUpdateOptions options) throws C8DBException {
        return ((C8ExecutorSync)this.executor).execute(this.updateVertexRequest(key, value, options), this.updateVertexResponseDeserializer(value));
    }

    @Override
    public void deleteVertex(String key) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.deleteVertexRequest(key, new VertexDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public void deleteVertex(String key, VertexDeleteOptions options) throws C8DBException {
        ((C8ExecutorSync)this.executor).execute(this.deleteVertexRequest(key, options), (Type)((Object)Void.class));
    }
}

