/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.C8DBException;
import com.c8db.entity.FeaturesEntity;
import com.c8db.entity.LimitsEntity;
import com.c8db.entity.TenantEntity;
import com.c8db.entity.TenantMetricsEntity;
import com.c8db.entity.TenantsEntity;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.model.TenantMetricsOption;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;

public abstract class InternalC8Admin<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_TENANTS = "/_api/tenants";
    protected static final String PATH_API_TENANT = "/_api/tenant";
    protected static final String PATH_API_FEATURES = "/_api/features";
    protected static final String PATH_API_LIMITS = "/_api/limits";
    protected static final String PATH_ENABLE = "enable";
    protected static final String PATH_TENANT = "tenant";
    protected static final String PATH_API_METRICS = "/_api/metrics/query";
    protected static final String PATH_QUERY = "query";
    private static final String C8CEP_THROUGHPUT_TOTAL = "c8cep_app_throughput_total";
    private static final String C8CEP_LATENCY_SUM = "c8cep_app_latency_seconds_sum";
    private final D db;

    protected InternalC8Admin(D db) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
    }

    public D db() {
        return this.db;
    }

    protected C8Executor.ResponseDeserializer<List<TenantsEntity>> getTenantsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<List<TenantsEntity>>(){

            @Override
            public List<TenantsEntity> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (List)InternalC8Admin.this.util().deserialize(result, new Type<List<TenantsEntity>>(){}.getType());
            }
        };
    }

    protected C8Executor.ResponseDeserializer<TenantEntity> getTenantResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<TenantEntity>(){

            @Override
            public TenantEntity deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (TenantEntity)InternalC8Admin.this.util().deserialize(result, new Type<TenantEntity>(){}.getType());
            }
        };
    }

    protected C8Executor.ResponseDeserializer<FeaturesEntity> getTenantFeaturesResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<FeaturesEntity>(){

            @Override
            public FeaturesEntity deserialize(Response response) throws VPackException {
                return (FeaturesEntity)InternalC8Admin.this.util().deserialize(response.getBody(), (java.lang.reflect.Type)((Object)FeaturesEntity.class));
            }
        };
    }

    protected C8Executor.ResponseDeserializer<Boolean> getLimitsEnabledResponseDeserializer() {
        return response -> {
            VPackSlice result = response.getBody().get("result").get("value");
            return (Boolean)this.util().deserialize(result, (java.lang.reflect.Type)((Object)Boolean.class));
        };
    }

    protected C8Executor.ResponseDeserializer<LimitsEntity> getTenantLimitsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<LimitsEntity>(){

            @Override
            public LimitsEntity deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (LimitsEntity)InternalC8Admin.this.util().deserialize(result, new Type<LimitsEntity>(){}.getType());
            }
        };
    }

    protected C8Executor.ResponseDeserializer<TenantMetricsEntity> getTenantMetricResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<TenantMetricsEntity>(){

            @Override
            public TenantMetricsEntity deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                String responseObj = (String)InternalC8Admin.this.util().deserialize(result, new Type<String>(){}.getType());
                TenantMetricsEntity tenantMetrics = InternalC8Admin.this.getTenantMetrics(responseObj);
                return tenantMetrics;
            }
        };
    }

    protected Request getTenantsRequest() {
        return this.request(null, null, RequestType.GET, PATH_API_TENANTS);
    }

    protected Request getTenantRequest(String tenant) {
        return this.request(null, null, RequestType.GET, PATH_API_TENANT, tenant);
    }

    protected Request getLimitsEnabledRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_LIMITS, PATH_ENABLE);
    }

    protected Request getTenantLimitsRequest(String tenant) {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_LIMITS, PATH_TENANT, tenant);
    }

    protected Request getTenantFeaturesRequest(String tenant) {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_FEATURES, PATH_TENANT, tenant);
    }

    protected Request getTenantMetricsRequest(TenantMetricsOption options) {
        VPackSlice body = this.util().serialize(options);
        Request request = this.request(null, ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_METRICS).setBody(body);
        return request;
    }

    private TenantMetricsEntity getTenantMetrics(String response) {
        ObjectMapper mapper = new ObjectMapper();
        TenantMetricsEntity tenantMetrics = new TenantMetricsEntity();
        try {
            JsonNode json = (JsonNode)mapper.readValue(response, JsonNode.class);
            if (json.has(C8CEP_THROUGHPUT_TOTAL)) {
                String throughtputJson = ((JsonNode)mapper.readValue(response, JsonNode.class)).get(C8CEP_THROUGHPUT_TOTAL).toString();
                List<Object> throughputlist = Arrays.asList((Object[])mapper.readValue(throughtputJson, TenantMetricsEntity.MetricsEntity[].class));
                tenantMetrics.setThroughput(throughputlist);
            }
            if (json.has(C8CEP_LATENCY_SUM)) {
                String latencySumJson = ((JsonNode)mapper.readValue(response, JsonNode.class)).get(C8CEP_LATENCY_SUM).toString();
                List<Object> latencySumlist = Arrays.asList((Object[])mapper.readValue(latencySumJson, TenantMetricsEntity.MetricsEntity[].class));
                tenantMetrics.setLatencySum(latencySumlist);
            }
        }
        catch (JsonProcessingException ex) {
            throw new C8DBException("PerfTestClient-Mapping-Tenant-Metrics : Exception processing Json while mapping", ex);
        }
        return tenantMetrics;
    }
}

