/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.AlertEntity;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.util.C8Serializer;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class InternalC8Alerts<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_ALERT = "/_api/alerts";
    private final D db;

    protected InternalC8Alerts(D db) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
    }

    public D db() {
        return this.db;
    }

    protected Request getAlertRequest(Map<String, String> queryParamMap) {
        Request request = this.request(null, null, RequestType.GET, PATH_ALERT);
        queryParamMap.forEach((key, value) -> request.putQueryParam((String)key, value));
        return request;
    }

    protected Request updateAlertRequest(String updateParam, Map<String, String> queryParamMap) {
        Request request = this.request(null, null, RequestType.PUT, PATH_ALERT, updateParam);
        queryParamMap.forEach((key, value) -> request.putQueryParam((String)key, value));
        return request;
    }

    protected Request createAlertRequest(AlertEntity entity) {
        Request request = this.request(null, null, RequestType.POST, PATH_ALERT);
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(entity, new C8Serializer.Options()));
        return request;
    }

    protected C8Executor.ResponseDeserializer<Collection<AlertEntity>> alertsListResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<AlertEntity>>(){

            @Override
            public Collection<AlertEntity> deserialize(Response response) throws VPackException {
                ArrayList<AlertEntity> alertList = new ArrayList<AlertEntity>();
                Iterator iterator = response.getBody().arrayIterator();
                while (iterator.hasNext()) {
                    alertList.add((AlertEntity)InternalC8Alerts.this.util().deserialize((VPackSlice)iterator.next(), new Type<AlertEntity>(){}.getType()));
                }
                return alertList;
            }
        };
    }

    protected C8Executor.ResponseDeserializer<AlertEntity> alertsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<AlertEntity>(){

            @Override
            public AlertEntity deserialize(Response response) throws VPackException {
                AlertEntity entity = (AlertEntity)InternalC8Alerts.this.util().deserialize(response.getBody(), new Type<AlertEntity>(){}.getType());
                return entity;
            }
        };
    }
}

