/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.ApiKeyCreateEntity;
import com.c8db.entity.ApiKeyEntity;
import com.c8db.entity.GeoFabricPermissions;
import com.c8db.entity.Permissions;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.model.ApiKeyCreateOptions;
import com.c8db.model.ApiKeyOptions;
import com.c8db.model.OptionsBuilder;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.util.Map;

public abstract class InternalC8ApiKeys<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_KEY_VALIDATE = "/_api/key/validate";
    protected static final String PATH_API_KEY = "/_api/key";
    private final D db;

    public InternalC8ApiKeys(D db) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
    }

    protected C8Executor.ResponseDeserializer<ApiKeyEntity> validateApiKeyResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<ApiKeyEntity>(){

            @Override
            public ApiKeyEntity deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (ApiKeyEntity)InternalC8ApiKeys.this.util().deserialize(result, new Type<ApiKeyEntity>(){}.getType());
            }
        };
    }

    protected Request validateApiKeyRequest(String apikey) {
        Request request = this.request(null, null, RequestType.POST, PATH_API_KEY_VALIDATE);
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(OptionsBuilder.build(new ApiKeyOptions(), apikey)));
        return request;
    }

    protected Request geoFabricsAccessLevelRequest(String keyId, boolean full) {
        Request request = this.request(null, null, RequestType.GET, PATH_API_KEY, String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), keyId), "database");
        request.putQueryParam("full", full);
        return request;
    }

    protected Request geoFabricAccessLevelRequest(String keyId) {
        Request request = this.request(null, null, RequestType.GET, PATH_API_KEY, String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), keyId), "database", String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name()));
        return request;
    }

    protected Request streamsAccessLevelRequest(String keyId, boolean full) {
        Request request = this.request(null, null, RequestType.GET, PATH_API_KEY, String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), keyId), "database", String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name()), "stream");
        if (full) {
            request.putQueryParam("full", true);
        }
        return request;
    }

    protected Request streamAccessLevelRequest(String keyId, String stream) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_KEY, String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), keyId), "database", String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name()), "stream", stream);
        return request;
    }

    protected Request createApiKeyRequest(String keyId) {
        Request request = this.request(null, null, RequestType.POST, PATH_API_KEY);
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(OptionsBuilder.build(new ApiKeyCreateOptions(), keyId)));
        return request;
    }

    protected Request deleteApiKeyRequest(String keyId) {
        return this.request(null, null, RequestType.DELETE, PATH_API_KEY, keyId);
    }

    protected C8Executor.ResponseDeserializer<Permissions> streamAccessLevelResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Permissions>(){

            @Override
            public Permissions deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Permissions)((Object)InternalC8ApiKeys.this.util().deserialize(result, new Type<Permissions>(){}.getType()));
            }
        };
    }

    protected C8Executor.ResponseDeserializer<Map<String, GeoFabricPermissions>> gatResourcesAccessResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Map<String, GeoFabricPermissions>>(){

            @Override
            public Map<String, GeoFabricPermissions> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Map)InternalC8ApiKeys.this.util().deserialize(result, new Type<Map<String, GeoFabricPermissions>>(){}.getType());
            }
        };
    }

    protected C8Executor.ResponseDeserializer<Map<String, Permissions>> listAccessesResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Map<String, Permissions>>(){

            @Override
            public Map<String, Permissions> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Map)InternalC8ApiKeys.this.util().deserialize(result, new Type<Map<String, Permissions>>(){}.getType());
            }
        };
    }

    protected C8Executor.ResponseDeserializer<ApiKeyCreateEntity> createApiKeyResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<ApiKeyCreateEntity>(){

            @Override
            public ApiKeyCreateEntity deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody();
                return (ApiKeyCreateEntity)InternalC8ApiKeys.this.util().deserialize(result, new Type<ApiKeyCreateEntity>(){}.getType());
            }
        };
    }
}

