/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.C8DBException;
import com.c8db.entity.DocumentCreateEntity;
import com.c8db.entity.DocumentDeleteEntity;
import com.c8db.entity.DocumentField;
import com.c8db.entity.DocumentUpdateEntity;
import com.c8db.entity.ErrorEntity;
import com.c8db.entity.IndexEntity;
import com.c8db.entity.MultiDocumentEntity;
import com.c8db.entity.Permissions;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.internal.util.DocumentUtil;
import com.c8db.model.CollectionCountOptions;
import com.c8db.model.CollectionPropertiesOptions;
import com.c8db.model.CollectionRenameOptions;
import com.c8db.model.CollectionTruncateOptions;
import com.c8db.model.DocumentCreateOptions;
import com.c8db.model.DocumentDeleteOptions;
import com.c8db.model.DocumentExistsOptions;
import com.c8db.model.DocumentReadOptions;
import com.c8db.model.DocumentReplaceOptions;
import com.c8db.model.DocumentUpdateOptions;
import com.c8db.model.FulltextIndexOptions;
import com.c8db.model.GeoIndexOptions;
import com.c8db.model.HashIndexOptions;
import com.c8db.model.OptionsBuilder;
import com.c8db.model.PersistentIndexOptions;
import com.c8db.model.SkiplistIndexOptions;
import com.c8db.model.TTLIndexOptions;
import com.c8db.model.UserAccessOptions;
import com.c8db.util.C8Serializer;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public abstract class InternalC8Collection<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    private static final String COLLECTION_QUERY_PARAM = "collection";
    protected static final String PATH_API_COLLECTION = "/_api/collection";
    protected static final String PATH_API_DOCUMENT = "/_api/document";
    protected static final String PATH_API_INDEX = "/_api/index";
    private static final String MERGE_OBJECTS = "mergeObjects";
    private static final String IGNORE_REVS = "ignoreRevs";
    private static final String RETURN_NEW = "returnNew";
    private static final String NEW = "new";
    private static final String RETURN_OLD = "returnOld";
    private static final String OVERWRITE = "overwrite";
    private static final String OLD = "old";
    private static final String SILENT = "silent";
    private static final String TRANSACTION_ID = "x-arango-trx-id";
    private final D db;
    protected volatile String name;

    protected InternalC8Collection(D db, String name) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected <T> Request insertDocumentRequest(T value, DocumentCreateOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_DOCUMENT, this.name);
        DocumentCreateOptions params = options != null ? options : new DocumentCreateOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(OVERWRITE, params.getOverwrite());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<DocumentCreateEntity<T>> insertDocumentResponseDeserializer(final T value, final DocumentCreateOptions options) {
        return new C8Executor.ResponseDeserializer<DocumentCreateEntity<T>>(){

            @Override
            public DocumentCreateEntity<T> deserialize(Response response) throws VPackException {
                VPackSlice oldDoc;
                VPackSlice body = response.getBody();
                DocumentCreateEntity doc = (DocumentCreateEntity)InternalC8Collection.this.util().deserialize(body, (java.lang.reflect.Type)((Object)DocumentCreateEntity.class));
                VPackSlice newDoc = body.get(InternalC8Collection.NEW);
                if (newDoc.isObject()) {
                    doc.setNew(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(newDoc, value.getClass()));
                }
                if ((oldDoc = body.get(InternalC8Collection.OLD)).isObject()) {
                    doc.setOld(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, value.getClass()));
                }
                if (options == null || Boolean.TRUE != options.getSilent()) {
                    HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                    values.put(DocumentField.Type.ID, doc.getId());
                    values.put(DocumentField.Type.KEY, doc.getKey());
                    values.put(DocumentField.Type.REV, doc.getRev());
                    InternalC8Collection.this.executor.documentCache().setValues(value, values);
                }
                return doc;
            }
        };
    }

    protected <T> Request insertDocumentsRequest(Collection<T> values, DocumentCreateOptions params) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_DOCUMENT, this.name);
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.putQueryParam(OVERWRITE, params.getOverwrite());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(values, new C8Serializer.Options().serializeNullValues(false).stringAsJson(true)));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentCreateEntity<T>>> insertDocumentsResponseDeserializer(final Collection<T> values, final DocumentCreateOptions params) {
        return new C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentCreateEntity<T>>>(){

            @Override
            public MultiDocumentEntity<DocumentCreateEntity<T>> deserialize(Response response) throws VPackException {
                Class<?> type = null;
                if (Boolean.TRUE == params.getReturnNew() && !values.isEmpty()) {
                    type = values.iterator().next().getClass();
                }
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList<DocumentCreateEntity> docs = new ArrayList<DocumentCreateEntity>();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                if (body.isArray()) {
                    Iterator iterator = body.arrayIterator();
                    while (iterator.hasNext()) {
                        VPackSlice oldDoc;
                        VPackSlice next = (VPackSlice)iterator.next();
                        if (next.get("error").isTrue()) {
                            ErrorEntity error = (ErrorEntity)InternalC8Collection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                            errors.add(error);
                            documentsAndErrors.add(error);
                            continue;
                        }
                        DocumentCreateEntity doc = (DocumentCreateEntity)InternalC8Collection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)DocumentCreateEntity.class));
                        VPackSlice newDoc = next.get(InternalC8Collection.NEW);
                        if (newDoc.isObject()) {
                            doc.setNew(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(newDoc, type));
                        }
                        if ((oldDoc = next.get(InternalC8Collection.OLD)).isObject()) {
                            doc.setOld(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                        }
                        docs.add(doc);
                        documentsAndErrors.add(doc);
                    }
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected Request getDocumentRequest(String key, DocumentReadOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentReadOptions params = options != null ? options : new DocumentReadOptions();
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        return request;
    }

    protected Request getDocumentsRequest(Collection<String> keys, DocumentReadOptions options) {
        DocumentReadOptions params = options != null ? options : new DocumentReadOptions();
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_DOCUMENT, this.name).putQueryParam("onlyget", true).putHeaderParam("If-None-Match", params.getIfNoneMatch()).putHeaderParam("If-Match", params.getIfMatch()).setBody(this.util().serialize(keys)).putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<MultiDocumentEntity<T>> getDocumentsResponseDeserializer(final Class<T> type, DocumentReadOptions options) {
        return new C8Executor.ResponseDeserializer<MultiDocumentEntity<T>>(){

            @Override
            public MultiDocumentEntity<T> deserialize(Response response) throws VPackException {
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList docs = new ArrayList();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)InternalC8Collection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    Object doc = InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(next, type);
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected <T> Request replaceDocumentRequest(String key, T value, DocumentReplaceOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentReplaceOptions params = options != null ? options : new DocumentReplaceOptions();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<DocumentUpdateEntity<T>> replaceDocumentResponseDeserializer(final T value, final DocumentReplaceOptions options) {
        return new C8Executor.ResponseDeserializer<DocumentUpdateEntity<T>>(){

            @Override
            public DocumentUpdateEntity<T> deserialize(Response response) throws VPackException {
                VPackSlice oldDoc;
                VPackSlice body = response.getBody();
                DocumentUpdateEntity doc = (DocumentUpdateEntity)InternalC8Collection.this.util().deserialize(body, (java.lang.reflect.Type)((Object)DocumentUpdateEntity.class));
                VPackSlice newDoc = body.get(InternalC8Collection.NEW);
                if (newDoc.isObject()) {
                    doc.setNew(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(newDoc, value.getClass()));
                }
                if ((oldDoc = body.get(InternalC8Collection.OLD)).isObject()) {
                    doc.setOld(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, value.getClass()));
                }
                if (options == null || Boolean.TRUE != options.getSilent()) {
                    HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                    values.put(DocumentField.Type.REV, doc.getRev());
                    InternalC8Collection.this.executor.documentCache().setValues(value, values);
                }
                return doc;
            }
        };
    }

    protected <T> Request replaceDocumentsRequest(Collection<T> values, DocumentReplaceOptions params) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_DOCUMENT, this.name);
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(values, new C8Serializer.Options().serializeNullValues(false).stringAsJson(true)));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>> replaceDocumentsResponseDeserializer(final Collection<T> values, final DocumentReplaceOptions params) {
        return new C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>>(){

            @Override
            public MultiDocumentEntity<DocumentUpdateEntity<T>> deserialize(Response response) throws VPackException {
                Class<?> type = null;
                if (!(Boolean.TRUE != params.getReturnNew() && Boolean.TRUE != params.getReturnOld() || values.isEmpty())) {
                    type = values.iterator().next().getClass();
                }
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList<DocumentUpdateEntity> docs = new ArrayList<DocumentUpdateEntity>();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                if (body.isArray()) {
                    Iterator iterator = body.arrayIterator();
                    while (iterator.hasNext()) {
                        VPackSlice oldDoc;
                        VPackSlice next = (VPackSlice)iterator.next();
                        if (next.get("error").isTrue()) {
                            ErrorEntity error = (ErrorEntity)InternalC8Collection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                            errors.add(error);
                            documentsAndErrors.add(error);
                            continue;
                        }
                        DocumentUpdateEntity doc = (DocumentUpdateEntity)InternalC8Collection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)DocumentUpdateEntity.class));
                        VPackSlice newDoc = next.get(InternalC8Collection.NEW);
                        if (newDoc.isObject()) {
                            doc.setNew(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(newDoc, type));
                        }
                        if ((oldDoc = next.get(InternalC8Collection.OLD)).isObject()) {
                            doc.setOld(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                        }
                        docs.add(doc);
                        documentsAndErrors.add(doc);
                    }
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected <T> Request updateDocumentRequest(String key, T value, DocumentUpdateOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PATCH, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentUpdateOptions params = options != null ? options : new DocumentUpdateOptions();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(MERGE_OBJECTS, params.getMergeObjects());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value, new C8Serializer.Options().serializeNullValues(params.getSerializeNull() == null || params.getSerializeNull() != false)));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<DocumentUpdateEntity<T>> updateDocumentResponseDeserializer(final T value, final DocumentUpdateOptions options) {
        return new C8Executor.ResponseDeserializer<DocumentUpdateEntity<T>>(){

            @Override
            public DocumentUpdateEntity<T> deserialize(Response response) throws VPackException {
                VPackSlice oldDoc;
                VPackSlice body = response.getBody();
                DocumentUpdateEntity doc = (DocumentUpdateEntity)InternalC8Collection.this.util().deserialize(body, (java.lang.reflect.Type)((Object)DocumentUpdateEntity.class));
                VPackSlice newDoc = body.get(InternalC8Collection.NEW);
                if (newDoc.isObject()) {
                    doc.setNew(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(newDoc, value.getClass()));
                }
                if ((oldDoc = body.get(InternalC8Collection.OLD)).isObject()) {
                    doc.setOld(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, value.getClass()));
                }
                if (options == null || Boolean.TRUE != options.getSilent()) {
                    HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                    values.put(DocumentField.Type.REV, doc.getRev());
                    InternalC8Collection.this.executor.documentCache().setValues(value, values);
                }
                return doc;
            }
        };
    }

    protected <T> Request updateDocumentsRequest(Collection<T> values, DocumentUpdateOptions params) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PATCH, PATH_API_DOCUMENT, this.name);
        Boolean keepNull = params.getKeepNull();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("keepNull", keepNull);
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(MERGE_OBJECTS, params.getMergeObjects());
        request.putQueryParam(IGNORE_REVS, params.getIgnoreRevs());
        request.putQueryParam(RETURN_NEW, params.getReturnNew());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(values, new C8Serializer.Options().serializeNullValues(params.getSerializeNull() == null || params.getSerializeNull() != false).stringAsJson(true)));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>> updateDocumentsResponseDeserializer(final Collection<T> values, final DocumentUpdateOptions params) {
        return new C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>>(){

            @Override
            public MultiDocumentEntity<DocumentUpdateEntity<T>> deserialize(Response response) throws VPackException {
                Class<?> type = null;
                if (!(Boolean.TRUE != params.getReturnNew() && Boolean.TRUE != params.getReturnOld() || values.isEmpty())) {
                    type = values.iterator().next().getClass();
                }
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList<DocumentUpdateEntity> docs = new ArrayList<DocumentUpdateEntity>();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                if (body.isArray()) {
                    Iterator iterator = body.arrayIterator();
                    while (iterator.hasNext()) {
                        VPackSlice oldDoc;
                        VPackSlice next = (VPackSlice)iterator.next();
                        if (next.get("error").isTrue()) {
                            ErrorEntity error = (ErrorEntity)InternalC8Collection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                            errors.add(error);
                            documentsAndErrors.add(error);
                            continue;
                        }
                        DocumentUpdateEntity doc = (DocumentUpdateEntity)InternalC8Collection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)DocumentUpdateEntity.class));
                        VPackSlice newDoc = next.get(InternalC8Collection.NEW);
                        if (newDoc.isObject()) {
                            doc.setNew(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(newDoc, type));
                        }
                        if ((oldDoc = next.get(InternalC8Collection.OLD)).isObject()) {
                            doc.setOld(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                        }
                        docs.add(doc);
                        documentsAndErrors.add(doc);
                    }
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected Request deleteDocumentRequest(String key, DocumentDeleteOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentDeleteOptions params = options != null ? options : new DocumentDeleteOptions();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<DocumentDeleteEntity<T>> deleteDocumentResponseDeserializer(final Class<T> type) {
        return new C8Executor.ResponseDeserializer<DocumentDeleteEntity<T>>(){

            @Override
            public DocumentDeleteEntity<T> deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody();
                DocumentDeleteEntity doc = (DocumentDeleteEntity)InternalC8Collection.this.util().deserialize(body, (java.lang.reflect.Type)((Object)DocumentDeleteEntity.class));
                VPackSlice oldDoc = body.get(InternalC8Collection.OLD);
                if (oldDoc.isObject()) {
                    doc.setOld(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                }
                return doc;
            }
        };
    }

    protected <T> Request deleteDocumentsRequest(Collection<T> keys, DocumentDeleteOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_DOCUMENT, this.name);
        DocumentDeleteOptions params = options != null ? options : new DocumentDeleteOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.setBody(this.util().serialize(keys));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentDeleteEntity<T>>> deleteDocumentsResponseDeserializer(final Class<T> type) {
        return new C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentDeleteEntity<T>>>(){

            @Override
            public MultiDocumentEntity<DocumentDeleteEntity<T>> deserialize(Response response) throws VPackException {
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList<DocumentDeleteEntity> docs = new ArrayList<DocumentDeleteEntity>();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                if (body.isArray()) {
                    Iterator iterator = body.arrayIterator();
                    while (iterator.hasNext()) {
                        VPackSlice next = (VPackSlice)iterator.next();
                        if (next.get("error").isTrue()) {
                            ErrorEntity error = (ErrorEntity)InternalC8Collection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                            errors.add(error);
                            documentsAndErrors.add(error);
                            continue;
                        }
                        DocumentDeleteEntity doc = (DocumentDeleteEntity)InternalC8Collection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)DocumentDeleteEntity.class));
                        VPackSlice oldDoc = next.get(InternalC8Collection.OLD);
                        if (oldDoc.isObject()) {
                            doc.setOld(InternalC8Collection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                        }
                        docs.add(doc);
                        documentsAndErrors.add(doc);
                    }
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected Request documentExistsRequest(String key, DocumentExistsOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.HEAD, PATH_API_DOCUMENT, DocumentUtil.createDocumentHandle(this.name, key));
        DocumentExistsOptions params = options != null ? options : new DocumentExistsOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        return request;
    }

    protected Request getIndexRequest(String id) {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_INDEX, this.createIndexId(id));
    }

    protected Request deleteIndexRequest(String id) {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_INDEX, this.createIndexId(id));
    }

    protected C8Executor.ResponseDeserializer<String> deleteIndexResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<String>(){

            @Override
            public String deserialize(Response response) throws VPackException {
                return response.getBody().get("id").getAsString();
            }
        };
    }

    private String createIndexId(String id) {
        String index;
        if (id.matches("[^/]+/[^/]+")) {
            index = id;
        } else if (id.matches("[^/]+")) {
            index = this.name + "/" + id;
        } else {
            throw new C8DBException(String.format("index id %s is not valid.", id));
        }
        return index;
    }

    protected Request createHashIndexRequest(Iterable<String> fields, HashIndexOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION_QUERY_PARAM, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new HashIndexOptions(), fields)));
        return request;
    }

    protected Request createSkiplistIndexRequest(Iterable<String> fields, SkiplistIndexOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION_QUERY_PARAM, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new SkiplistIndexOptions(), fields)));
        return request;
    }

    protected Request createPersistentIndexRequest(Iterable<String> fields, PersistentIndexOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION_QUERY_PARAM, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new PersistentIndexOptions(), fields)));
        return request;
    }

    protected Request createGeoIndexRequest(Iterable<String> fields, GeoIndexOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION_QUERY_PARAM, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new GeoIndexOptions(), fields)));
        return request;
    }

    protected Request createFulltextIndexRequest(Iterable<String> fields, FulltextIndexOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION_QUERY_PARAM, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new FulltextIndexOptions(), fields)));
        return request;
    }

    protected Request createTTLIndexRequest(Iterable<String> fields, TTLIndexOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_INDEX);
        request.putQueryParam(COLLECTION_QUERY_PARAM, this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new TTLIndexOptions(), fields)));
        return request;
    }

    protected Request getIndexesRequest() {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_INDEX);
        request.putQueryParam(COLLECTION_QUERY_PARAM, this.name);
        return request;
    }

    protected C8Executor.ResponseDeserializer<Collection<IndexEntity>> getIndexesResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<IndexEntity>>(){

            @Override
            public Collection<IndexEntity> deserialize(Response response) throws VPackException {
                return (Collection)InternalC8Collection.this.util().deserialize(response.getBody().get("indexes"), new Type<Collection<IndexEntity>>(){}.getType());
            }
        };
    }

    protected Request truncateRequest(CollectionTruncateOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_COLLECTION, this.name, "truncate");
        CollectionTruncateOptions params = options != null ? options : new CollectionTruncateOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        return request;
    }

    protected Request countRequest(CollectionCountOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_COLLECTION, this.name, "count");
        CollectionCountOptions params = options != null ? options : new CollectionCountOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        return request;
    }

    protected Request dropRequest(Boolean isSystem) {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_COLLECTION, this.name).putQueryParam("isSystem", isSystem);
    }

    protected Request getInfoRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_COLLECTION, this.name);
    }

    protected Request getPropertiesRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_COLLECTION, this.name, "properties");
    }

    protected Request changePropertiesRequest(CollectionPropertiesOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_COLLECTION, this.name, "properties");
        request.setBody(this.util().serialize(options != null ? options : new CollectionPropertiesOptions()));
        return request;
    }

    protected Request renameRequest(String newName) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_COLLECTION, this.name, "rename");
        request.setBody(this.util().serialize(OptionsBuilder.build(new CollectionRenameOptions(), newName)));
        return request;
    }

    protected <T> Request responsibleShardRequest(T value) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_COLLECTION, this.name, "responsibleShard");
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected Request getRevisionRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_COLLECTION, this.name, "revision");
    }

    protected Request grantAccessRequest(String user, Permissions permissions) {
        return this.request(null, "_system", RequestType.PUT, "/_api/user", String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), user), "database", String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name()), COLLECTION_QUERY_PARAM, this.name).setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request resetAccessRequest(String user) {
        return this.request(null, "_system", RequestType.DELETE, "/_api/user", String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), user), "database", String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name()), COLLECTION_QUERY_PARAM, this.name);
    }

    protected Request getPermissionsRequest(String user) {
        return this.request(null, "_system", RequestType.GET, "/_api/user", String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), user), "database", String.join((CharSequence)".", ((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name()), COLLECTION_QUERY_PARAM, this.name);
    }

    protected C8Executor.ResponseDeserializer<Permissions> getPermissionsResponseDeserialzer() {
        return new C8Executor.ResponseDeserializer<Permissions>(){

            @Override
            public Permissions deserialize(Response response) throws VPackException {
                VPackSlice result;
                VPackSlice body = response.getBody();
                if (body != null && !(result = body.get("result")).isNone()) {
                    return (Permissions)((Object)InternalC8Collection.this.util().deserialize(result, (java.lang.reflect.Type)((Object)Permissions.class)));
                }
                return null;
            }
        };
    }
}

