/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.FxEntity;
import com.c8db.entity.FxMetadataEntity;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.model.FxReadOptions;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.util.Collection;
import java.util.Map;

public abstract class InternalC8Compute<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_FX = "/_api/function";
    protected static final String METADATA = "metadata";
    protected static final String INVOKE = "invoke";
    private final D db;

    public InternalC8Compute(D db) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
    }

    protected Request getFunctionsRequest(FxReadOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_FX);
        FxReadOptions params = options != null ? options : new FxReadOptions();
        request.putQueryParam("type", params.getType().toString().toLowerCase());
        return request;
    }

    protected C8Executor.ResponseDeserializer<Collection<FxEntity>> getFunctionsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<FxEntity>>(){

            @Override
            public Collection<FxEntity> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody();
                return (Collection)InternalC8Compute.this.util().deserialize(result, new Type<Collection<FxEntity>>(){}.getType());
            }
        };
    }

    protected Request getInfoRequest(String name) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_FX, name);
        return request;
    }

    protected C8Executor.ResponseDeserializer<FxEntity> getInfoResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<FxEntity>(){

            @Override
            public FxEntity deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody();
                Collection entites = (Collection)InternalC8Compute.this.util().deserialize(result, new Type<Collection<FxEntity>>(){}.getType());
                return entites.isEmpty() ? null : (FxEntity)entites.iterator().next();
            }
        };
    }

    protected Request getMetadataRequest() {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_FX, METADATA);
        return request;
    }

    protected C8Executor.ResponseDeserializer<FxMetadataEntity> getMetadataResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<FxMetadataEntity>(){

            @Override
            public FxMetadataEntity deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody();
                return (FxMetadataEntity)InternalC8Compute.this.util().deserialize(result, new Type<FxMetadataEntity>(){}.getType());
            }
        };
    }

    protected Request executeFunctionRequest(String name, Map<String, Object> arguments) {
        VPackSlice body = this.util().serialize(arguments);
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, false, PATH_API_FX, INVOKE, name);
        request.putQueryParam("params", body.toString());
        return request;
    }

    protected C8Executor.ResponseDeserializer<Object> executeFunctionResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Object>(){

            @Override
            public Object deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody();
                if (result.isArray()) {
                    return InternalC8Compute.this.util().deserialize(result, new Type<Collection<Object>>(){}.getType());
                }
                Map map = (Map)InternalC8Compute.this.util().deserialize(result, new Type<Map<String, Object>>(){}.getType());
                return map;
            }
        };
    }
}

