/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.DataCenterEntity;
import com.c8db.entity.DcInfoEntity;
import com.c8db.entity.GeoFabricEntity;
import com.c8db.entity.LogLevelEntity;
import com.c8db.entity.Permissions;
import com.c8db.entity.ServerRole;
import com.c8db.entity.UserEntity;
import com.c8db.internal.C8Context;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.model.DBCreateOptions;
import com.c8db.model.DCListOptions;
import com.c8db.model.LogOptions;
import com.c8db.model.OptionsBuilder;
import com.c8db.model.UserAccessOptions;
import com.c8db.model.UserCreateOptions;
import com.c8db.model.UserUpdateOptions;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class InternalC8DB<E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_USER = "/_api/user";
    private static final String PATH_API_ADMIN_LOG = "/_admin/log";
    private static final String PATH_API_ADMIN_LOG_LEVEL = "/_admin/log/level";
    private static final String PATH_API_ROLE = "/_admin/server/role";

    protected InternalC8DB(E executor, C8SerializationFactory util, C8Context context) {
        super(executor, util, context);
    }

    protected Request getRoleRequest() {
        return this.request("demo", "_system", RequestType.GET, PATH_API_ROLE);
    }

    protected C8Executor.ResponseDeserializer<ServerRole> getRoleResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<ServerRole>(){

            @Override
            public ServerRole deserialize(Response response) throws VPackException {
                return (ServerRole)((Object)InternalC8DB.this.util().deserialize(response.getBody().get("role"), (java.lang.reflect.Type)((Object)ServerRole.class)));
            }
        };
    }

    protected Request createGeoFabricRequest(String tenant, String name, String spotDc, String dcList, String geoFabric) {
        Request request = this.request(tenant, name, RequestType.POST, "/_api/database");
        request.setBody(this.util().serialize(OptionsBuilder.build(new DBCreateOptions(), tenant, geoFabric, spotDc, dcList)));
        return request;
    }

    protected C8Executor.ResponseDeserializer<Boolean> createGeoFabricResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Boolean>(){

            @Override
            public Boolean deserialize(Response response) throws VPackException {
                return response.getBody().get("result").getAsBoolean();
            }
        };
    }

    protected Request getGeoFabricsRequest(String tenant, String database) {
        return this.request(tenant, database, RequestType.GET, "/_api/database");
    }

    protected C8Executor.ResponseDeserializer<Collection<String>> getGeoFabricsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Collection)InternalC8DB.this.util().deserialize(result, new Type<Collection<String>>(){}.getType());
            }
        };
    }

    protected Request getAccessibleGeoFabricsForRequest(String tenant, String fabric, String user, boolean full) {
        Request request = this.request(tenant, fabric, RequestType.GET, PATH_API_USER, user, "database");
        request.putQueryParam("full", full);
        return request;
    }

    protected C8Executor.ResponseDeserializer<Collection<String>> getAccessibleGeoFabricsForResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                ArrayList<String> dbs = new ArrayList<String>();
                Iterator it = result.objectIterator();
                while (it.hasNext()) {
                    Map.Entry next = (Map.Entry)it.next();
                    dbs.add((String)next.getKey());
                }
                return dbs;
            }
        };
    }

    protected Request updateDCListRequest(String tenant, String name, String dcList) {
        Request request = this.request(tenant, "_system", RequestType.POST, "/_api/database", name, "/datacenter");
        request.setBody(this.util().serialize(OptionsBuilder.build(new DCListOptions(), dcList)));
        return request;
    }

    protected C8Executor.ResponseDeserializer<Boolean> updateDCListResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Boolean>(){

            @Override
            public Boolean deserialize(Response response) throws VPackException {
                return response.getBody().get("result").getAsBoolean();
            }
        };
    }

    protected Request getGeoFabricInfoRequest(String tenant, String name) {
        return this.request(tenant, name, RequestType.GET, "/_api/database", "current");
    }

    protected C8Executor.ResponseDeserializer<GeoFabricEntity> getGeoFabricInfoResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<GeoFabricEntity>(){

            @Override
            public GeoFabricEntity deserialize(Response response) throws VPackException {
                return (GeoFabricEntity)InternalC8DB.this.util().deserialize(response.getBody().get("result"), (java.lang.reflect.Type)((Object)GeoFabricEntity.class));
            }
        };
    }

    protected Request updateSpotDcRequest(String tenant, String name, String spotDc) {
        return this.request(tenant, name, RequestType.PUT, "/_api/database", spotDc);
    }

    protected C8Executor.ResponseDeserializer<Boolean> updateSpotDcResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Boolean>(){

            @Override
            public Boolean deserialize(Response response) throws VPackException {
                return response.getBody().get("result").getAsBoolean();
            }
        };
    }

    protected Request getEdgeLocationsRequest(String tenant) {
        return this.request(null, null, RequestType.GET, "/datacenter", "/_tenant", tenant);
    }

    protected C8Executor.ResponseDeserializer<List<DataCenterEntity>> getEdgeLocationsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<List<DataCenterEntity>>(){

            @Override
            public List<DataCenterEntity> deserialize(Response response) throws VPackException {
                return (List)InternalC8DB.this.util().deserialize(response.getBody(), new Type<ArrayList<DataCenterEntity>>(){}.getType());
            }
        };
    }

    protected Request getAllEdgeLocationsRequest() {
        return this.request(null, null, RequestType.GET, "/datacenter", "all");
    }

    protected C8Executor.ResponseDeserializer<List<DcInfoEntity>> getAllEdgeLocationsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<List<DcInfoEntity>>(){

            @Override
            public List<DcInfoEntity> deserialize(Response response) throws VPackException {
                return (List)InternalC8DB.this.util().deserialize(response.getBody(), new Type<ArrayList<DcInfoEntity>>(){}.getType());
            }
        };
    }

    protected Request getLocalEdgeLocationRequest() {
        return this.request(null, null, RequestType.GET, "/datacenter", "local");
    }

    protected C8Executor.ResponseDeserializer<DcInfoEntity> getLocalEdgeLocationResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<DcInfoEntity>(){

            @Override
            public DcInfoEntity deserialize(Response response) throws VPackException {
                return (DcInfoEntity)InternalC8DB.this.util().deserialize(response.getBody(), (java.lang.reflect.Type)((Object)DcInfoEntity.class));
            }
        };
    }

    protected Request getEdgeLocationRequest(String dcName) {
        return this.request(null, null, RequestType.GET, "/datacenter", dcName);
    }

    protected C8Executor.ResponseDeserializer<DcInfoEntity> getEdgeLocationResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<DcInfoEntity>(){

            @Override
            public DcInfoEntity deserialize(Response response) throws VPackException {
                return (DcInfoEntity)InternalC8DB.this.util().deserialize(response.getBody(), (java.lang.reflect.Type)((Object)DcInfoEntity.class));
            }
        };
    }

    protected Request updateSpotStatusRequest(String dcName, boolean isSpot) {
        return this.request(null, null, RequestType.PUT, "/datacenter", dcName, String.valueOf(isSpot));
    }

    protected C8Executor.ResponseDeserializer<Boolean> BooleanResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Boolean>(){

            @Override
            public Boolean deserialize(Response response) throws VPackException {
                return response.getBody().getAsBoolean();
            }
        };
    }

    protected Request createUserRequest(String tenant, String database, String user, String passwd, String email, UserCreateOptions options) {
        Request request = this.request(tenant, database, RequestType.POST, PATH_API_USER);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new UserCreateOptions(), user, passwd, email)));
        return request;
    }

    protected Request deleteUserRequest(String tenant, String database, String user) {
        return this.request(tenant, database, RequestType.DELETE, PATH_API_USER, user);
    }

    protected Request getUsersRequest(String tenant, String database) {
        return this.request(tenant, database, RequestType.GET, PATH_API_USER);
    }

    protected Request getUserRequest(String tenant, String database, String user) {
        return this.request(tenant, database, RequestType.GET, PATH_API_USER, user);
    }

    protected C8Executor.ResponseDeserializer<Collection<UserEntity>> getUsersResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<UserEntity>>(){

            @Override
            public Collection<UserEntity> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Collection)InternalC8DB.this.util().deserialize(result, new Type<Collection<UserEntity>>(){}.getType());
            }
        };
    }

    protected Request updateUserRequest(String tenant, String database, String user, UserUpdateOptions options) {
        Request request = this.request(tenant, database, RequestType.PATCH, PATH_API_USER, user);
        request.setBody(this.util().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected Request replaceUserRequest(String tenant, String database, String user, UserUpdateOptions options) {
        Request request = this.request(tenant, database, RequestType.PUT, PATH_API_USER, user);
        request.setBody(this.util().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected Request updateUserDefaultDatabaseAccessRequest(String user, Permissions permissions) {
        return this.request("demo", "_system", RequestType.PUT, PATH_API_USER, user, "database", "*").setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request updateUserDefaultCollectionAccessRequest(String user, Permissions permissions) {
        return this.request("demo", "_system", RequestType.PUT, PATH_API_USER, user, "database", "*", "*").setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request getLogsRequest(LogOptions options) {
        LogOptions params = options != null ? options : new LogOptions();
        return this.request("demo", "_system", RequestType.GET, PATH_API_ADMIN_LOG).putQueryParam("upto", (Object)params.getUpto()).putQueryParam("level", (Object)params.getLevel()).putQueryParam("start", params.getStart()).putQueryParam("size", params.getSize()).putQueryParam("offset", params.getOffset()).putQueryParam("search", params.getSearch()).putQueryParam("sort", (Object)params.getSort());
    }

    protected Request getLogLevelRequest() {
        return this.request("demo", "_system", RequestType.GET, PATH_API_ADMIN_LOG_LEVEL);
    }

    protected Request setLogLevelRequest(LogLevelEntity entity) {
        return this.request("demo", "_system", RequestType.PUT, PATH_API_ADMIN_LOG_LEVEL).setBody(this.util().serialize(entity));
    }
}

