/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.VPack;
import com.arangodb.velocypack.VPackModule;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackParserModule;
import com.c8db.C8DB;
import com.c8db.C8DBException;
import com.c8db.Service;
import com.c8db.entity.LoadBalancingStrategy;
import com.c8db.internal.C8Defaults;
import com.c8db.internal.net.ConnectionFactory;
import com.c8db.internal.net.DirtyReadHostHandler;
import com.c8db.internal.net.ExtendedHostResolver;
import com.c8db.internal.net.FallbackHostHandler;
import com.c8db.internal.net.Host;
import com.c8db.internal.net.HostDescription;
import com.c8db.internal.net.HostHandler;
import com.c8db.internal.net.HostResolver;
import com.c8db.internal.net.RandomHostHandler;
import com.c8db.internal.net.RoundRobinHostHandler;
import com.c8db.internal.net.SimpleHostResolver;
import com.c8db.internal.util.HostUtils;
import com.c8db.internal.velocypack.VPackDriverModule;
import com.c8db.util.C8Deserializer;
import com.c8db.util.C8Serialization;
import com.c8db.util.C8Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalC8DBBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InternalC8DBBuilder.class);
    private static final String PROPERTY_KEY_HOSTS = "c8db.hosts";
    private static final String PROPERTY_KEY_C8STREAMS_HOSTS = "c8streams.hosts";
    private static final String PROPERTY_KEY_HOST = "c8db.host";
    private static final String PROPERTY_KEY_PORT = "c8db.port";
    private static final String PROPERTY_KEY_TIMEOUT = "c8db.timeout";
    private static final String PROPERTY_KEY_RESPONSE_SIZE_LIMIT = "c8db.responseSizeLimit";
    private static final String PROPERTY_KEY_USER = "c8db.user";
    private static final String PROPERTY_KEY_PASSWORD = "c8db.password";
    private static final String PROPERTY_KEY_EMAIL = "c8db.email";
    private static final String PROPERTY_KEY_JWT_AUTH = "c8db.jwt";
    private static final String PROPERTY_KEY_JWT_USER = "c8db.jwtUser";
    private static final String PROPERTY_KEY_APIKEY = "c8db.apikey";
    private static final String PROPERTY_KEY_USE_SSL = "c8db.usessl";
    private static final String PROPERTY_KEY_COOKIE_SPEC = "c8db.httpCookieSpec";
    private static final String PROPERTY_KEY_V_STREAM_CHUNK_CONTENT_SIZE = "c8db.chunksize";
    private static final String PROPERTY_KEY_MAX_CONNECTIONS = "c8db.connections.max";
    private static final String PROPERTY_KEY_CONNECTION_TTL = "c8db.connections.ttl";
    private static final String PROPERTY_KEY_ACQUIRE_HOST_LIST = "c8db.acquireHostList";
    private static final String PROPERTY_KEY_ACQUIRE_HOST_LIST_INTERVAL = "c8db.acquireHostList.interval";
    private static final String PROPERTY_KEY_LOAD_BALANCING_STRATEGY = "c8db.loadBalancingStrategy";
    private static final String DEFAULT_PROPERTY_FILE = "/c8db.properties";
    protected final Map<Service, List<HostDescription>> hosts;
    protected HostDescription host;
    protected Integer responseSizeLimit;
    protected Integer timeout;
    protected String user;
    protected String password;
    protected String email;
    protected String jwtToken;
    protected Boolean jwtAuth;
    protected Boolean useSsl;
    protected String httpCookieSpec;
    protected SSLContext sslContext;
    protected Integer chunksize;
    protected Integer maxConnections;
    protected Long connectionTtl;
    protected final VPack.Builder vpackBuilder = new VPack.Builder();
    protected final VPackParser.Builder vpackParserBuilder = new VPackParser.Builder();
    protected C8Serializer serializer;
    protected C8Deserializer deserializer;
    protected Boolean acquireHostList;
    protected Integer acquireHostListInterval;
    protected LoadBalancingStrategy loadBalancingStrategy;
    protected C8Serialization customSerializer;
    protected String apiKey;

    public InternalC8DBBuilder() {
        this.vpackBuilder.registerModule((VPackModule)new VPackDriverModule());
        this.vpackParserBuilder.registerModule((VPackParserModule)new VPackDriverModule());
        this.host = new HostDescription("127.0.0.1", C8Defaults.DEFAULT_PORT);
        this.hosts = new HashMap<Service, List<HostDescription>>();
        for (Service key : Service.values()) {
            this.hosts.put(key, new ArrayList());
        }
        this.user = "root";
        this.loadProperties(C8DB.class.getResourceAsStream(DEFAULT_PROPERTY_FILE));
    }

    public InternalC8DBBuilder loadProperties(InputStream in) throws C8DBException {
        Properties properties = new Properties();
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
                throw new C8DBException(e);
            }
        }
        this.loadProperties(properties);
        return this;
    }

    protected void loadProperties(Properties properties) {
        InternalC8DBBuilder.loadHosts(PROPERTY_KEY_HOSTS, Service.C8DB, properties, this.hosts);
        String host = InternalC8DBBuilder.loadHost(properties, this.host.getHost());
        int port = InternalC8DBBuilder.loadPort(properties, this.host.getPort());
        this.host = new HostDescription(host, port);
        this.responseSizeLimit = InternalC8DBBuilder.loadMaxResponseSize(properties, this.responseSizeLimit);
        this.timeout = InternalC8DBBuilder.loadTimeout(properties, this.timeout);
        this.user = InternalC8DBBuilder.loadUser(properties, this.user);
        this.password = InternalC8DBBuilder.loadPassword(properties, this.password);
        this.email = InternalC8DBBuilder.loadEmail(properties, this.email);
        this.jwtToken = InternalC8DBBuilder.loadJWTToken(properties, this.jwtToken);
        this.jwtAuth = InternalC8DBBuilder.loadJWTAuth(properties, this.jwtAuth);
        this.apiKey = InternalC8DBBuilder.loadApiKey(properties, this.apiKey);
        this.useSsl = InternalC8DBBuilder.loadUseSsl(properties, this.useSsl);
        this.httpCookieSpec = InternalC8DBBuilder.loadhttpCookieSpec(properties, this.httpCookieSpec);
        this.chunksize = InternalC8DBBuilder.loadChunkSize(properties, this.chunksize);
        this.maxConnections = InternalC8DBBuilder.loadMaxConnections(properties, this.maxConnections);
        this.connectionTtl = InternalC8DBBuilder.loadConnectionTtl(properties, this.connectionTtl);
        this.acquireHostList = InternalC8DBBuilder.loadAcquireHostList(properties, this.acquireHostList);
        this.acquireHostListInterval = InternalC8DBBuilder.loadAcquireHostListInterval(properties, this.acquireHostListInterval);
        this.loadBalancingStrategy = InternalC8DBBuilder.loadLoadBalancingStrategy(properties, this.loadBalancingStrategy);
    }

    protected void setHost(Service service, String host, int port) {
        this.hosts.get((Object)service).add(new HostDescription(host, port));
    }

    protected void setEmail(String email) {
        this.email = email;
    }

    protected void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    protected void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    protected void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    protected void setResponseSizeLimit(Integer responseSizeLimit) {
        this.responseSizeLimit = responseSizeLimit;
    }

    protected void setUser(String user) {
        this.user = user;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected void setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
    }

    protected void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    protected void setChunksize(Integer chunksize) {
        this.chunksize = chunksize;
    }

    protected void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected void setConnectionTtl(Long connectionTtl) {
        this.connectionTtl = connectionTtl;
    }

    protected void setAcquireHostList(Boolean acquireHostList) {
        this.acquireHostList = acquireHostList;
    }

    protected void setAcquireHostListInterval(Integer acquireHostListInterval) {
        this.acquireHostListInterval = acquireHostListInterval;
    }

    protected void setLoadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
        this.loadBalancingStrategy = loadBalancingStrategy;
    }

    protected void serializer(C8Serializer serializer) {
        this.serializer = serializer;
    }

    protected Map<Service, HostHandler> createHostHandlerMatrix(HostResolver hostResolver) {
        HashMap<Service, HostHandler> matrix = new HashMap<Service, HostHandler>();
        for (Service service : Service.values()) {
            matrix.put(service, this.createHostHandler(hostResolver, service));
        }
        return Collections.unmodifiableMap(matrix);
    }

    protected HostHandler createHostHandler(HostResolver hostResolver, Service service) {
        HostHandler hostHandler;
        if (this.loadBalancingStrategy != null) {
            switch (this.loadBalancingStrategy) {
                case ONE_RANDOM: {
                    hostHandler = new RandomHostHandler(hostResolver, new FallbackHostHandler(hostResolver, service), service);
                    break;
                }
                case ROUND_ROBIN: {
                    hostHandler = new RoundRobinHostHandler(hostResolver, service);
                    break;
                }
                default: {
                    hostHandler = new FallbackHostHandler(hostResolver, service);
                    break;
                }
            }
        } else {
            hostHandler = new FallbackHostHandler(hostResolver, service);
        }
        LOG.debug("HostHandler is " + hostHandler.getClass().getSimpleName());
        return new DirtyReadHostHandler(hostHandler, new RoundRobinHostHandler(hostResolver, service));
    }

    protected void deserializer(C8Deserializer deserializer) {
        this.deserializer = deserializer;
    }

    protected void setSerializer(C8Serialization serializer) {
        this.customSerializer = serializer;
    }

    protected HostResolver createHostResolver(Map<Service, Collection<Host>> hostsMatrix, int maxConnections, ConnectionFactory connectionFactory) {
        if (this.acquireHostList != null && this.acquireHostList.booleanValue()) {
            LOG.debug("acquireHostList -> Use ExtendedHostResolver");
            return new ExtendedHostResolver(HostUtils.cloneHostMatrix(hostsMatrix), maxConnections, connectionFactory, this.acquireHostListInterval);
        }
        LOG.debug("Use SimpleHostResolver");
        return new SimpleHostResolver(HostUtils.cloneHostMatrix(hostsMatrix));
    }

    private static void loadHosts(String propertyName, Service service, Properties properties, Map<Service, List<HostDescription>> hosts) {
        String hostsProp = properties.getProperty(propertyName);
        if (hostsProp != null) {
            String[] hostsSplit;
            for (String host : hostsSplit = hostsProp.split(",")) {
                String[] split = host.split(":");
                if (split.length != 2 || !split[1].matches("[0-9]+")) {
                    throw new C8DBException(String.format("Could not load property-value c8db.hosts=%s. Expected format ip:port,ip:port,...", hostsProp));
                }
                hosts.get((Object)service).add(new HostDescription(split[0], Integer.valueOf(split[1])));
            }
        }
    }

    private static String loadHost(Properties properties, String currentValue) {
        String host = InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_HOST, currentValue, "127.0.0.1");
        if (host.contains(":")) {
            throw new C8DBException(String.format("Could not load property-value c8db.host=%s. Expect only ip. Do you mean c8db.hosts=ip:port ?", host));
        }
        return host;
    }

    private static Integer loadPort(Properties properties, int currentValue) {
        return Integer.parseInt(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_PORT, currentValue, C8Defaults.DEFAULT_PORT));
    }

    private static Integer loadTimeout(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_TIMEOUT, currentValue, C8Defaults.DEFAULT_TIMEOUT));
    }

    private static Integer loadMaxResponseSize(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_RESPONSE_SIZE_LIMIT, currentValue, C8Defaults.DEFAULT_RESPONSE_SIZE_LIMIT));
    }

    private static String loadUser(Properties properties, String currentValue) {
        return InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_USER, currentValue, "root");
    }

    private static String loadJWTToken(Properties properties, String currentValue) {
        return InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_JWT_AUTH, currentValue, null);
    }

    private static String loadJWTUser(Properties properties, String currentValue) {
        return InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_JWT_USER, currentValue, null);
    }

    private static String loadPassword(Properties properties, String currentValue) {
        return InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_PASSWORD, currentValue, null);
    }

    private static String loadEmail(Properties properties, String currentValue) {
        return InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_EMAIL, currentValue, null);
    }

    private static Boolean loadJWTAuth(Properties properties, Boolean currentValue) {
        return Boolean.parseBoolean(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_JWT_AUTH, currentValue, C8Defaults.DEFAULT_JWT_AUTH));
    }

    private static String loadApiKey(Properties properties, String currentValue) {
        return InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_APIKEY, currentValue, null);
    }

    private static Boolean loadUseSsl(Properties properties, Boolean currentValue) {
        return Boolean.parseBoolean(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_USE_SSL, currentValue, C8Defaults.DEFAULT_USE_SSL));
    }

    private static String loadhttpCookieSpec(Properties properties, String currentValue) {
        return InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_COOKIE_SPEC, currentValue, "");
    }

    private static Integer loadChunkSize(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_V_STREAM_CHUNK_CONTENT_SIZE, currentValue, 30000));
    }

    private static Integer loadMaxConnections(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_MAX_CONNECTIONS, currentValue, 1));
    }

    private static Long loadConnectionTtl(Properties properties, Long currentValue) {
        String ttl = InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_CONNECTION_TTL, currentValue, C8Defaults.CONNECTION_TTL_VST_DEFAULT);
        return ttl != null ? Long.valueOf(Long.parseLong(ttl)) : null;
    }

    private static Boolean loadAcquireHostList(Properties properties, Boolean currentValue) {
        return Boolean.parseBoolean(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_ACQUIRE_HOST_LIST, currentValue, false));
    }

    private static int loadAcquireHostListInterval(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_ACQUIRE_HOST_LIST_INTERVAL, currentValue, 3600000));
    }

    private static LoadBalancingStrategy loadLoadBalancingStrategy(Properties properties, LoadBalancingStrategy currentValue) {
        return LoadBalancingStrategy.valueOf(InternalC8DBBuilder.getProperty(properties, PROPERTY_KEY_LOAD_BALANCING_STRATEGY, currentValue, C8Defaults.DEFAULT_LOAD_BALANCING_STRATEGY).toUpperCase());
    }

    protected static <T> String getProperty(Properties properties, String key, T currentValue, T defaultValue) {
        String overrideDefaultValue = null;
        if (currentValue != null) {
            overrideDefaultValue = currentValue.toString();
        } else if (defaultValue != null) {
            overrideDefaultValue = defaultValue.toString();
        }
        return properties.getProperty(key, overrideDefaultValue);
    }

    protected Map<Service, Collection<Host>> createHostMatrix(int maxConnections, ConnectionFactory connectionFactory) {
        HashMap<Service, Collection<Host>> matrix = new HashMap<Service, Collection<Host>>();
        for (Service service : Service.values()) {
            ArrayList<Host> hostList = new ArrayList<Host>();
            for (HostDescription host : this.hosts.get((Object)service)) {
                hostList.add(HostUtils.createHost(host, maxConnections, connectionFactory, service));
            }
            matrix.put(service, hostList);
        }
        return matrix;
    }
}

