/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.C8StreamEntity;
import com.c8db.entity.CollectionEntity;
import com.c8db.entity.DatabaseEntity;
import com.c8db.entity.EdgeDefinition;
import com.c8db.entity.GeoFabricPermissions;
import com.c8db.entity.GraphEntity;
import com.c8db.entity.PathEntity;
import com.c8db.entity.Permissions;
import com.c8db.entity.QueryTrackingPropertiesEntity;
import com.c8db.entity.StreamTransactionEntity;
import com.c8db.entity.TransactionEntity;
import com.c8db.entity.TraversalEntity;
import com.c8db.entity.UserQuery;
import com.c8db.entity.UserQueryEntity;
import com.c8db.entity.UserQueryOptions;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.model.C8StreamCreateOptions;
import com.c8db.model.C8TransactionOptions;
import com.c8db.model.C8qlQueryExplainOptions;
import com.c8db.model.C8qlQueryOptions;
import com.c8db.model.C8qlQueryParseOptions;
import com.c8db.model.CollectionCreateOptions;
import com.c8db.model.CollectionsReadOptions;
import com.c8db.model.GraphCreateOptions;
import com.c8db.model.OptionsBuilder;
import com.c8db.model.StreamTransactionOptions;
import com.c8db.model.TraversalOptions;
import com.c8db.model.UserAccessOptions;
import com.c8db.util.C8Serializer;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class InternalC8Database<A extends InternalC8DB<E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_DATABASE = "/_api/database";
    protected static final String PATH_API_DCLIST = "/datacenter";
    protected static final String PATH_API_TENANT = "/_tenant";
    protected static final String PATH_API_USER = "/_api/user";
    protected static final String PATH_API_VERSION = "/_admin/version";
    protected static final String PATH_API_STREAMS = "/_api/streams";
    protected static final String PATH_API_TRANSACTION = "/transaction";
    protected static final String PATH_API_CURSOR = "/_api/cursor";
    protected static final String PATH_API_QUERY = "/_api/query";
    protected static final String PATH_API_QUERY_CURRENT = "/query/current";
    protected static final String PATH_API_EXPLAIN = "explain";
    protected static final String PATH_API_QUERY_SLOW = "/query/slow";
    protected static final String PATH_API_QUERY_PROPERTIES = "/query/properties";
    protected static final String PATH_API_USER_QUERIES = "/_api/restql";
    protected static final String QUERY_PARAM_GLOBAL = "global";
    protected static final String QUERY_PARAM_FULL = "full";
    private static final String PATH_API_BEGIN_STREAM_TRANSACTION = "/_api/transaction/begin";
    private static final String PATH_API_TRAVERSAL = "/_api/traversal";
    private final String tenant;
    private final String name;
    private final String spotDc;
    private final String dcList;
    private final A c8db;

    protected InternalC8Database(A c8db, String tenant, String name, String spotDc, String dcList) {
        super(((InternalC8DB)c8db).executor, ((InternalC8DB)c8db).util, ((InternalC8DB)c8db).context);
        this.c8db = c8db;
        this.tenant = tenant;
        this.name = name;
        this.spotDc = spotDc;
        this.dcList = dcList;
    }

    public A c8db() {
        return this.c8db;
    }

    public String tenant() {
        return this.tenant;
    }

    public String name() {
        return this.name;
    }

    public String spotDc() {
        return this.spotDc;
    }

    public String dcList() {
        return this.dcList;
    }

    protected C8Executor.ResponseDeserializer<Collection<String>> getDatabaseResponseDeserializer() {
        return ((InternalC8DB)this.c8db).getGeoFabricsResponseDeserializer();
    }

    protected C8Executor.ResponseDeserializer<Collection<String>> getAccessibleDatabasesForResponseDeserializer() {
        return ((InternalC8DB)this.c8db).getAccessibleGeoFabricsForResponseDeserializer();
    }

    protected Request getAccessibleDatabasesRequest() {
        return this.request(this.tenant, this.name, RequestType.GET, PATH_API_DATABASE, "user");
    }

    protected Request getVersionRequest() {
        return this.request(this.tenant, this.name, RequestType.GET, PATH_API_VERSION);
    }

    protected Request createCollectionRequest(String name, CollectionCreateOptions options) {
        VPackSlice body = this.util().serialize(OptionsBuilder.build(options != null ? options : new CollectionCreateOptions(), name));
        return this.request(this.tenant(), this.name(), RequestType.POST, "/_api/collection").setBody(body);
    }

    protected Request getCollectionsRequest(CollectionsReadOptions options) {
        Request request = this.request(this.tenant(), this.name(), RequestType.GET, "/_api/collection");
        CollectionsReadOptions params = options != null ? options : new CollectionsReadOptions();
        request.putQueryParam("excludeSystem", params.getExcludeSystem());
        return request;
    }

    protected C8Executor.ResponseDeserializer<Collection<CollectionEntity>> getCollectionsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<CollectionEntity>>(){

            @Override
            public Collection<CollectionEntity> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Collection)InternalC8Database.this.util().deserialize(result, new Type<Collection<CollectionEntity>>(){}.getType());
            }
        };
    }

    protected Request dropRequest() {
        return this.request("demo", "_system", RequestType.DELETE, PATH_API_DATABASE, this.name);
    }

    protected C8Executor.ResponseDeserializer<Boolean> createDropResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Boolean>(){

            @Override
            public Boolean deserialize(Response response) throws VPackException {
                return response.getBody().get("result").getAsBoolean();
            }
        };
    }

    protected Request grantAccessRequest(String user, Permissions permissions) {
        return this.request(null, "_system", RequestType.PUT, PATH_API_USER, String.join((CharSequence)".", this.tenant, user), "database", String.join((CharSequence)".", this.tenant, this.name)).setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request resetAccessRequest(String user) {
        return this.request(null, "_system", RequestType.DELETE, PATH_API_USER, String.join((CharSequence)".", this.tenant, user), "database", String.join((CharSequence)".", this.tenant, this.name));
    }

    protected Request getPermissionsRequest(String user) {
        return this.request(null, "_system", RequestType.GET, PATH_API_USER, String.join((CharSequence)".", this.tenant, user), "database", String.join((CharSequence)".", this.tenant, this.name));
    }

    protected C8Executor.ResponseDeserializer<Permissions> getPermissionsResponseDeserialzer() {
        return new C8Executor.ResponseDeserializer<Permissions>(){

            @Override
            public Permissions deserialize(Response response) throws VPackException {
                VPackSlice result;
                VPackSlice body = response.getBody();
                if (body != null && !(result = body.get("result")).isNone()) {
                    return (Permissions)((Object)InternalC8Database.this.util().deserialize(result, (java.lang.reflect.Type)((Object)Permissions.class)));
                }
                return null;
            }
        };
    }

    protected Request getResourcesRequest(String user, boolean full) {
        Request request = this.request(null, "_system", RequestType.GET, PATH_API_USER, String.join((CharSequence)".", this.tenant, user), "database");
        request.putQueryParam(QUERY_PARAM_FULL, full);
        return request;
    }

    protected Request getUserStreamPermissionsRequest(String user, String database, String stream) {
        return this.request(null, "_system", RequestType.GET, PATH_API_USER, String.join((CharSequence)".", this.tenant, user), "database", String.join((CharSequence)".", this.tenant, database), "stream", stream);
    }

    protected Request getUserStreamsAccessRequest(String user, String database, boolean full) {
        Request request = this.request(null, "_system", RequestType.GET, PATH_API_USER, String.join((CharSequence)".", this.tenant, user), "database", String.join((CharSequence)".", this.tenant, database), "stream");
        if (full) {
            request.putQueryParam(QUERY_PARAM_FULL, true);
        }
        return request;
    }

    protected C8Executor.ResponseDeserializer<Map<String, Permissions>> listPermissionsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Map<String, Permissions>>(){

            @Override
            public Map<String, Permissions> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Map)InternalC8Database.this.util().deserialize(result, new Type<Map<String, Permissions>>(){}.getType());
            }
        };
    }

    protected Request getUserPermissionsRequest(String user, String database) {
        return this.request(null, "_system", RequestType.GET, PATH_API_USER, String.join((CharSequence)".", this.tenant, user), "database", String.join((CharSequence)".", this.tenant, database));
    }

    protected C8Executor.ResponseDeserializer<Permissions> permissionsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Permissions>(){

            @Override
            public Permissions deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                String level = (String)InternalC8Database.this.util().deserialize(result, new Type<String>(){}.getType());
                return Permissions.valueOf(level.toUpperCase());
            }
        };
    }

    protected C8Executor.ResponseDeserializer<Map<String, GeoFabricPermissions>> resourcesPermissionsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Map<String, GeoFabricPermissions>>(){

            @Override
            public Map<String, GeoFabricPermissions> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Map)InternalC8Database.this.util().deserialize(result, new Type<Map<String, GeoFabricPermissions>>(){}.getType());
            }
        };
    }

    protected Request queryRequest(String query, Map<String, Object> bindVars, C8qlQueryOptions options) {
        C8qlQueryOptions opt = options != null ? options : new C8qlQueryOptions();
        Request request = this.request(this.tenant, this.name, RequestType.POST, PATH_API_CURSOR).setBody(this.util().serialize(OptionsBuilder.build(opt, query, bindVars != null ? this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(bindVars, new C8Serializer.Options().serializeNullValues(true)) : null)));
        return request;
    }

    protected Request queryNextRequest(String id, Map<String, String> meta) {
        Request request = this.request(this.tenant, this.name, RequestType.PUT, PATH_API_CURSOR, id);
        return request;
    }

    protected Request queryCloseRequest(String id, Map<String, String> meta) {
        Request request = this.request(this.tenant, this.name, RequestType.DELETE, PATH_API_CURSOR, id);
        if (meta != null) {
            request.getHeaderParam().putAll(meta);
        }
        return request;
    }

    protected Request parseQueryRequest(String query) {
        return this.request(this.tenant, this.name, RequestType.POST, PATH_API_QUERY).setBody(this.util().serialize(OptionsBuilder.build(new C8qlQueryParseOptions(), query)));
    }

    protected Request getCurrentlyRunningQueriesRequest() {
        return this.request(this.tenant, this.name, RequestType.GET, PATH_API_QUERY_CURRENT);
    }

    protected Request explainQueryRequest(String query, Map<String, Object> bindVars, C8qlQueryExplainOptions options) {
        C8qlQueryExplainOptions opt = options != null ? options : new C8qlQueryExplainOptions();
        return this.request(this.tenant, this.name, RequestType.POST, PATH_API_QUERY, PATH_API_EXPLAIN).setBody(this.util().serialize(OptionsBuilder.build(opt, query, bindVars != null ? this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(bindVars, new C8Serializer.Options().serializeNullValues(true)) : null)));
    }

    protected Request getQueryTrackingPropertiesRequest() {
        return this.request(this.tenant, this.name, RequestType.GET, PATH_API_QUERY_PROPERTIES);
    }

    protected Request setQueryTrackingPropertiesRequest(QueryTrackingPropertiesEntity properties) {
        return this.request(this.tenant, this.name, RequestType.PUT, PATH_API_QUERY_PROPERTIES).setBody(this.util().serialize(properties));
    }

    protected Request clearSlowQueriesRequest() {
        return this.request(this.tenant, this.name, RequestType.DELETE, PATH_API_QUERY_SLOW);
    }

    protected Request getSlowQueriesRequest() {
        return this.request(this.tenant, this.name, RequestType.GET, PATH_API_QUERY_SLOW);
    }

    protected Request killQueryRequest(String id) {
        return this.request(this.tenant, this.name, RequestType.DELETE, PATH_API_QUERY, id);
    }

    protected Request createGraphRequest(String name, Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return this.request(this.tenant(), this.name(), RequestType.POST, "/_api/graph").setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new GraphCreateOptions(), name, edgeDefinitions)));
    }

    protected C8Executor.ResponseDeserializer<GraphEntity> createGraphResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalC8Database.this.util().deserialize(response.getBody().get("graph"), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }

    protected Request getGraphsRequest() {
        return this.request(this.tenant, this.name, RequestType.GET, "/_api/graph");
    }

    protected C8Executor.ResponseDeserializer<Collection<GraphEntity>> getGraphsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<GraphEntity>>(){

            @Override
            public Collection<GraphEntity> deserialize(Response response) throws VPackException {
                return (Collection)InternalC8Database.this.util().deserialize(response.getBody().get("graphs"), new Type<Collection<GraphEntity>>(){}.getType());
            }
        };
    }

    protected Request transactionRequest(String action, C8TransactionOptions options) {
        return this.request(this.tenant, this.name, RequestType.POST, PATH_API_TRANSACTION).setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new C8TransactionOptions(), action)));
    }

    protected <T> C8Executor.ResponseDeserializer<T> transactionResponseDeserializer(final Class<T> type) {
        return new C8Executor.ResponseDeserializer<T>(){

            @Override
            public T deserialize(Response response) throws VPackException {
                VPackSlice result;
                VPackSlice body = response.getBody();
                if (body != null && !(result = body.get("result")).isNone() && !result.isNull()) {
                    return InternalC8Database.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(result, type);
                }
                return null;
            }
        };
    }

    protected Request beginStreamTransactionRequest(StreamTransactionOptions options) {
        return this.request(this.tenant, this.name, RequestType.POST, PATH_API_BEGIN_STREAM_TRANSACTION).setBody(this.util().serialize(options != null ? options : new StreamTransactionOptions()));
    }

    protected Request abortStreamTransactionRequest(String id) {
        return this.request(this.tenant, this.name, RequestType.DELETE, PATH_API_TRANSACTION, id);
    }

    protected Request getStreamTransactionsRequest() {
        return this.request(this.tenant, this.name, RequestType.GET, PATH_API_TRANSACTION);
    }

    protected Request getStreamTransactionRequest(String id) {
        return this.request(this.tenant, this.name, RequestType.GET, PATH_API_TRANSACTION, id);
    }

    protected C8Executor.ResponseDeserializer<Collection<TransactionEntity>> transactionsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<TransactionEntity>>(){

            @Override
            public Collection<TransactionEntity> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("transactions");
                return (Collection)InternalC8Database.this.util().deserialize(result, new Type<Collection<TransactionEntity>>(){}.getType());
            }
        };
    }

    protected Request commitStreamTransactionRequest(String id) {
        return this.request(this.tenant, this.name, RequestType.PUT, PATH_API_TRANSACTION, id);
    }

    protected C8Executor.ResponseDeserializer<StreamTransactionEntity> streamTransactionResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<StreamTransactionEntity>(){

            @Override
            public StreamTransactionEntity deserialize(Response response) throws VPackException {
                return (StreamTransactionEntity)InternalC8Database.this.util().deserialize(response.getBody().get("result"), (java.lang.reflect.Type)((Object)StreamTransactionEntity.class));
            }
        };
    }

    protected Request getInfoRequest() {
        return this.request(this.tenant, this.name, RequestType.GET, PATH_API_DATABASE, "current");
    }

    protected C8Executor.ResponseDeserializer<DatabaseEntity> getInfoResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<DatabaseEntity>(){

            @Override
            public DatabaseEntity deserialize(Response response) throws VPackException {
                return (DatabaseEntity)InternalC8Database.this.util().deserialize(response.getBody().get("result"), (java.lang.reflect.Type)((Object)DatabaseEntity.class));
            }
        };
    }

    protected Request executeTraversalRequest(TraversalOptions options) {
        return this.request(this.tenant, this.name, RequestType.POST, PATH_API_TRAVERSAL).setBody(this.util().serialize(options != null ? options : new C8TransactionOptions()));
    }

    protected <E, V> C8Executor.ResponseDeserializer<TraversalEntity<V, E>> executeTraversalResponseDeserializer(final Class<V> vertexClass, final Class<E> edgeClass) {
        return new C8Executor.ResponseDeserializer<TraversalEntity<V, E>>(){

            @Override
            public TraversalEntity<V, E> deserialize(Response response) throws VPackException {
                TraversalEntity result = new TraversalEntity();
                VPackSlice visited = response.getBody().get("result").get("visited");
                result.setVertices(InternalC8Database.this.deserializeVertices(vertexClass, visited));
                ArrayList paths = new ArrayList();
                Iterator iterator = visited.get("paths").arrayIterator();
                while (iterator.hasNext()) {
                    PathEntity path = new PathEntity();
                    VPackSlice next = (VPackSlice)iterator.next();
                    path.setEdges(InternalC8Database.this.deserializeEdges(edgeClass, next));
                    path.setVertices(InternalC8Database.this.deserializeVertices(vertexClass, next));
                    paths.add(path);
                }
                result.setPaths(paths);
                return result;
            }
        };
    }

    protected <V> Collection<V> deserializeVertices(Class<V> vertexClass, VPackSlice vpack) throws VPackException {
        ArrayList vertices = new ArrayList();
        Iterator iterator = vpack.get("vertices").arrayIterator();
        while (iterator.hasNext()) {
            vertices.add(this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize((VPackSlice)iterator.next(), vertexClass));
        }
        return vertices;
    }

    protected <E> Collection<E> deserializeEdges(Class<E> edgeClass, VPackSlice next) throws VPackException {
        ArrayList edges = new ArrayList();
        Iterator iteratorEdge = next.get("edges").arrayIterator();
        while (iteratorEdge.hasNext()) {
            edges.add(this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize((VPackSlice)iteratorEdge.next(), edgeClass));
        }
        return edges;
    }

    protected Request createC8PersistentStreamRequest(String name, C8StreamCreateOptions options) {
        Request request = this.request(this.tenant(), this.name(), RequestType.POST, PATH_API_STREAMS, name);
        request.putQueryParam(QUERY_PARAM_GLOBAL, options == null || options.getIsLocal() == false);
        return request;
    }

    protected Request getC8PersistentStreamsRequest(C8StreamCreateOptions options) {
        Request request = this.request(this.tenant(), this.name(), RequestType.GET, PATH_API_STREAMS);
        request.putQueryParam(QUERY_PARAM_GLOBAL, options == null || options.getIsLocal() == false);
        return request;
    }

    protected C8Executor.ResponseDeserializer<Collection<C8StreamEntity>> getC8StreamsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<C8StreamEntity>>(){

            @Override
            public Collection<C8StreamEntity> deserialize(Response response) throws VPackException {
                return (Collection)InternalC8Database.this.util().deserialize(response.getBody().get("result"), new Type<Collection<C8StreamEntity>>(){}.getType());
            }
        };
    }

    protected C8Executor.ResponseDeserializer<String> getC8StreamResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<String>(){

            @Override
            public String deserialize(Response response) throws VPackException {
                return (String)InternalC8Database.this.util().deserialize(response.getBody().get("result").get("stream-id"), new Type<String>(){}.getType());
            }
        };
    }

    protected Request getC8StreamsRequest() {
        return this.request(this.tenant(), this.name(), RequestType.GET, PATH_API_STREAMS);
    }

    protected Request clearC8StreamBacklogRequest(boolean isLocal) {
        Request request = this.request(this.tenant(), this.name(), RequestType.POST, PATH_API_STREAMS, "clearbacklog");
        if (isLocal) {
            request.putQueryParam(QUERY_PARAM_GLOBAL, !isLocal);
        }
        return request;
    }

    protected Request getC8StreamTtlRequest(boolean isLocal) {
        Request request = this.request(this.tenant(), this.name(), RequestType.GET, PATH_API_STREAMS, "ttl");
        if (isLocal) {
            request.putQueryParam(QUERY_PARAM_GLOBAL, !isLocal);
        }
        return request;
    }

    protected C8Executor.ResponseDeserializer<Integer> getC8StreamTtlResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Integer>(){

            @Override
            public Integer deserialize(Response response) throws VPackException {
                return (Integer)InternalC8Database.this.util().deserialize(response.getBody().get("result"), new Type<Integer>(){}.getType());
            }
        };
    }

    protected Request c8StreamTtlRequest(int ttl, boolean isLocal) {
        Request request = this.request(this.tenant(), this.name(), RequestType.POST, PATH_API_STREAMS, "ttl", Integer.toString(ttl));
        if (isLocal) {
            request.putQueryParam(QUERY_PARAM_GLOBAL, !isLocal);
        }
        return request;
    }

    protected Request clearC8StreamBacklogRequest(String subscriptionName, boolean isLocal) {
        Request request = this.request(this.tenant(), this.name(), RequestType.POST, PATH_API_STREAMS, "clearbacklog", subscriptionName);
        if (isLocal) {
            request.putQueryParam(QUERY_PARAM_GLOBAL, !isLocal);
        }
        return request;
    }

    protected Request unsubscribeRequest(String subscriptionName, boolean isLocal) {
        Request request = this.request(this.tenant(), this.name(), RequestType.DELETE, PATH_API_STREAMS, "subscription", subscriptionName);
        if (isLocal) {
            request.putQueryParam(QUERY_PARAM_GLOBAL, !isLocal);
        }
        return request;
    }

    protected Request createUserQueryRequest(UserQueryOptions options, String user) {
        Request request = this.request(this.tenant(), this.name(), RequestType.POST, PATH_API_USER_QUERIES);
        request.setBody(this.util().serialize(new UserQuery(options != null ? options : new UserQueryOptions(), user), new C8Serializer.Options().serializeNullValues(true)));
        return request;
    }

    protected C8Executor.ResponseDeserializer<UserQueryEntity> createUserQueryResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<UserQueryEntity>(){

            @Override
            public UserQueryEntity deserialize(Response response) throws VPackException {
                return (UserQueryEntity)InternalC8Database.this.util().deserialize(response.getBody().get("result"), (java.lang.reflect.Type)((Object)UserQueryEntity.class));
            }
        };
    }

    protected Request userQueryRequest(String userName, String restqlName, Map<String, Object> bindVars) {
        Request request = userName == null ? this.request(this.tenant, this.name, RequestType.POST, PATH_API_USER_QUERIES, "execute", "root", restqlName) : this.request(this.tenant, this.name, RequestType.POST, PATH_API_USER_QUERIES, "execute", userName, restqlName);
        request.setBody(this.util().serialize(bindVars == null ? new HashMap() : bindVars));
        return request;
    }
}

