/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.DocumentField;
import com.c8db.entity.EdgeEntity;
import com.c8db.entity.EdgeUpdateEntity;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.InternalC8Graph;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.internal.util.DocumentUtil;
import com.c8db.model.EdgeCreateOptions;
import com.c8db.model.EdgeDeleteOptions;
import com.c8db.model.EdgeReplaceOptions;
import com.c8db.model.EdgeUpdateOptions;
import com.c8db.model.GraphDocumentReadOptions;
import com.c8db.util.C8Serializer;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.lang.reflect.Type;
import java.util.HashMap;

public abstract class InternalC8EdgeCollection<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, G extends InternalC8Graph<A, D, E>, E extends C8Executor>
extends C8Executeable<E> {
    private final G graph;
    private final String name;

    protected InternalC8EdgeCollection(G graph, String name) {
        super(((InternalC8Graph)graph).executor, ((InternalC8Graph)graph).util, ((InternalC8Graph)graph).context);
        this.graph = graph;
        this.name = name;
    }

    public G graph() {
        return this.graph;
    }

    public String name() {
        return this.name;
    }

    protected <T> Request insertEdgeRequest(T value, EdgeCreateOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.POST, "/_api/graph", ((InternalC8Graph)this.graph).name(), "edge", this.name);
        EdgeCreateOptions params = options != null ? options : new EdgeCreateOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<EdgeEntity> insertEdgeResponseDeserializer(final T value) {
        return new C8Executor.ResponseDeserializer<EdgeEntity>(){

            @Override
            public EdgeEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get("edge");
                EdgeEntity doc = (EdgeEntity)InternalC8EdgeCollection.this.util().deserialize(body, (Type)((Object)EdgeEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.ID, doc.getId());
                values.put(DocumentField.Type.KEY, doc.getKey());
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalC8EdgeCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected Request getEdgeRequest(String key, GraphDocumentReadOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.GET, "/_api/graph", ((InternalC8Graph)this.graph).name(), "edge", DocumentUtil.createDocumentHandle(this.name, key));
        GraphDocumentReadOptions params = options != null ? options : new GraphDocumentReadOptions();
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<T> getEdgeResponseDeserializer(final Class<T> type) {
        return new C8Executor.ResponseDeserializer<T>(){

            @Override
            public T deserialize(Response response) throws VPackException {
                return InternalC8EdgeCollection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(response.getBody().get("edge"), type);
            }
        };
    }

    protected <T> Request replaceEdgeRequest(String key, T value, EdgeReplaceOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.PUT, "/_api/graph", ((InternalC8Graph)this.graph).name(), "edge", DocumentUtil.createDocumentHandle(this.name, key));
        EdgeReplaceOptions params = options != null ? options : new EdgeReplaceOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<EdgeUpdateEntity> replaceEdgeResponseDeserializer(final T value) {
        return new C8Executor.ResponseDeserializer<EdgeUpdateEntity>(){

            @Override
            public EdgeUpdateEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get("edge");
                EdgeUpdateEntity doc = (EdgeUpdateEntity)InternalC8EdgeCollection.this.util().deserialize(body, (Type)((Object)EdgeUpdateEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalC8EdgeCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected <T> Request updateEdgeRequest(String key, T value, EdgeUpdateOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.PATCH, "/_api/graph", ((InternalC8Graph)this.graph).name(), "edge", DocumentUtil.createDocumentHandle(this.name, key));
        EdgeUpdateOptions params = options != null ? options : new EdgeUpdateOptions();
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value, new C8Serializer.Options().serializeNullValues(true)));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<EdgeUpdateEntity> updateEdgeResponseDeserializer(final T value) {
        return new C8Executor.ResponseDeserializer<EdgeUpdateEntity>(){

            @Override
            public EdgeUpdateEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get("edge");
                EdgeUpdateEntity doc = (EdgeUpdateEntity)InternalC8EdgeCollection.this.util().deserialize(body, (Type)((Object)EdgeUpdateEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalC8EdgeCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected Request deleteEdgeRequest(String key, EdgeDeleteOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.DELETE, "/_api/graph", ((InternalC8Graph)this.graph).name(), "edge", DocumentUtil.createDocumentHandle(this.name, key));
        EdgeDeleteOptions params = options != null ? options : new EdgeDeleteOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }
}

