/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.C8EventEntity;
import com.c8db.entity.C8EventIDEntity;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.model.C8EventCreate;
import com.c8db.model.DocumentDeleteOptions;
import com.c8db.model.DocumentReadOptions;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.util.Collection;
import java.util.Collections;

public abstract class InternalC8Event<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_EVENT = "/_api/events";
    private static final String RETURN_OLD = "returnOld";
    private static final String SILENT = "silent";
    private final D db;

    protected InternalC8Event(D db) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
    }

    public D db() {
        return this.db;
    }

    protected Request insertEventRequest(C8EventCreate value) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_EVENT);
        request.setBody(this.util().serialize(value));
        return request;
    }

    protected C8Executor.ResponseDeserializer<C8EventIDEntity> insertEventResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<C8EventIDEntity>(){

            @Override
            public C8EventIDEntity deserialize(Response response) throws VPackException {
                return (C8EventIDEntity)InternalC8Event.this.util().deserialize(response.getBody(), (java.lang.reflect.Type)((Object)C8EventIDEntity.class));
            }
        };
    }

    protected C8Executor.ResponseDeserializer<Collection<C8EventIDEntity>> deleteEventsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<C8EventIDEntity>>(){

            @Override
            public Collection<C8EventIDEntity> deserialize(Response response) throws VPackException {
                return (Collection)InternalC8Event.this.util().deserialize(response.getBody(), new Type<Collection<C8EventIDEntity>>(){}.getType());
            }
        };
    }

    protected C8Executor.ResponseDeserializer<C8EventIDEntity> deleteEventResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<C8EventIDEntity>(){

            @Override
            public C8EventIDEntity deserialize(Response response) throws VPackException {
                Collection coll = (Collection)InternalC8Event.this.util().deserialize(response.getBody(), new Type<Collection<C8EventIDEntity>>(){}.getType());
                return coll != null && coll.size() > 0 ? (C8EventIDEntity)coll.iterator().next() : null;
            }
        };
    }

    protected Request getEventRequest(String key, DocumentReadOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_EVENT, key);
        DocumentReadOptions params = options != null ? options : new DocumentReadOptions();
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }

    protected Request getEventsRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_EVENT);
    }

    protected C8Executor.ResponseDeserializer<Collection<C8EventEntity>> getEventsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<C8EventEntity>>(){

            @Override
            public Collection<C8EventEntity> deserialize(Response response) throws VPackException {
                return (Collection)InternalC8Event.this.util().deserialize(response.getBody(), new Type<Collection<C8EventEntity>>(){}.getType());
            }
        };
    }

    protected Request deleteEventRequest(String key, DocumentDeleteOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_EVENT);
        DocumentDeleteOptions params = options != null ? options : new DocumentDeleteOptions();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.setBody(this.util().serialize(Collections.singletonList(key)));
        return request;
    }

    protected <T> Request deleteEventsRequest(Collection<T> keys, DocumentDeleteOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_EVENT);
        DocumentDeleteOptions params = options != null ? options : new DocumentDeleteOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam(RETURN_OLD, params.getReturnOld());
        request.putQueryParam(SILENT, params.getSilent());
        request.setBody(this.util().serialize(keys));
        return request;
    }
}

