/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.EdgeDefinition;
import com.c8db.entity.GraphEntity;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.model.OptionsBuilder;
import com.c8db.model.VertexCollectionCreateOptions;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.util.Collection;

public abstract class InternalC8Graph<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_GHARIAL = "/_api/graph";
    protected static final String VERTEX = "vertex";
    protected static final String EDGE = "edge";
    private static final String GRAPH = "graph";
    private final D db;
    private final String name;

    protected InternalC8Graph(D db, String name) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected Request dropRequest() {
        return this.dropRequest(false);
    }

    protected Request dropRequest(boolean dropCollections) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_GHARIAL, this.name);
        if (dropCollections) {
            request.putQueryParam("dropCollections", dropCollections);
        }
        return request;
    }

    protected Request getInfoRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_GHARIAL, this.name);
    }

    protected C8Executor.ResponseDeserializer<GraphEntity> getInfoResponseDeserializer() {
        return this.addVertexCollectionResponseDeserializer();
    }

    protected Request getVertexCollectionsRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_GHARIAL, this.name, VERTEX);
    }

    protected C8Executor.ResponseDeserializer<Collection<String>> getVertexCollectionsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                return (Collection)InternalC8Graph.this.util().deserialize(response.getBody().get("collections"), new Type<Collection<String>>(){}.getType());
            }
        };
    }

    protected Request addVertexCollectionRequest(String name) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_GHARIAL, this.name(), VERTEX);
        request.setBody(this.util().serialize(OptionsBuilder.build(new VertexCollectionCreateOptions(), name)));
        return request;
    }

    protected C8Executor.ResponseDeserializer<GraphEntity> addVertexCollectionResponseDeserializer() {
        return this.addEdgeDefinitionResponseDeserializer();
    }

    protected Request getEdgeDefinitionsRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_GHARIAL, this.name, EDGE);
    }

    protected C8Executor.ResponseDeserializer<Collection<String>> getEdgeDefinitionsDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                return (Collection)InternalC8Graph.this.util().deserialize(response.getBody().get("collections"), new Type<Collection<String>>(){}.getType());
            }
        };
    }

    protected Request addEdgeDefinitionRequest(EdgeDefinition definition) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_GHARIAL, this.name, EDGE);
        request.setBody(this.util().serialize(definition));
        return request;
    }

    protected C8Executor.ResponseDeserializer<GraphEntity> addEdgeDefinitionResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalC8Graph.this.util().deserialize(response.getBody().get(InternalC8Graph.GRAPH), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }

    protected Request replaceEdgeDefinitionRequest(EdgeDefinition definition) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_GHARIAL, this.name, EDGE, definition.getCollection());
        request.setBody(this.util().serialize(definition));
        return request;
    }

    protected C8Executor.ResponseDeserializer<GraphEntity> replaceEdgeDefinitionResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalC8Graph.this.util().deserialize(response.getBody().get(InternalC8Graph.GRAPH), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }

    protected Request removeEdgeDefinitionRequest(String definitionName) {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_GHARIAL, this.name, EDGE, definitionName);
    }

    protected C8Executor.ResponseDeserializer<GraphEntity> removeEdgeDefinitionResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalC8Graph.this.util().deserialize(response.getBody().get(InternalC8Graph.GRAPH), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }
}

