/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.VPackSlice;
import com.c8db.entity.BaseKeyValue;
import com.c8db.entity.DocumentCreateEntity;
import com.c8db.entity.DocumentDeleteEntity;
import com.c8db.entity.ErrorEntity;
import com.c8db.entity.MultiDocumentEntity;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.model.C8KVPairReadOptions;
import com.c8db.model.CollectionCreateOptions;
import com.c8db.model.DocumentCreateOptions;
import com.c8db.model.DocumentDeleteOptions;
import com.c8db.model.OptionsBuilder;
import com.c8db.util.C8Serializer;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class InternalC8KeyValue<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_KV = "/kv";
    protected static final String PATH_API_KV_PAIR = "/value";
    protected static final String PATH_API_KV_PAIRS = "/values";
    private static final String OFFSET = "offset";
    private static final String LIMIT = "limit";
    private static final String EXPIRATION = "expiration";
    private static final String NEW = "new";
    private static final String OLD = "old";
    private final D db;
    protected volatile String name;

    protected InternalC8KeyValue(D db, String name) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected <T> Request insertKVPairsRequest(Collection<T> values, DocumentCreateOptions params) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_KV, this.name, "value");
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(values, new C8Serializer.Options().serializeNullValues(false).stringAsJson(true)));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentCreateEntity<T>>> insertKVPairsResponseDeserializer(Collection<T> values, DocumentCreateOptions params) {
        return response -> {
            Class<?> type = null;
            if (Boolean.TRUE == params.getReturnNew() && !values.isEmpty()) {
                type = values.iterator().next().getClass();
            }
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentCreateEntity> docs = new ArrayList<DocumentCreateEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            VPackSlice body = response.getBody();
            if (body.isArray()) {
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice oldDoc;
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)this.util().deserialize(next, (Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentCreateEntity doc = (DocumentCreateEntity)this.util().deserialize(next, (Type)((Object)DocumentCreateEntity.class));
                    VPackSlice newDoc = next.get(NEW);
                    if (newDoc.isObject()) {
                        doc.setNew(this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(newDoc, type));
                    }
                    if ((oldDoc = next.get(OLD)).isObject()) {
                        doc.setOld(this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected Request getKVPairRequest(String key) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_KV, this.name, "value", key);
        return request;
    }

    protected Request getKVPairsRequest(Collection<String> keys, C8KVPairReadOptions options) {
        C8KVPairReadOptions params = options != null ? options : new C8KVPairReadOptions();
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_KV, this.name, "values").putQueryParam(OFFSET, params.getOffset()).putQueryParam(LIMIT, params.getLimit()).setBody(this.util().serialize(keys));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<MultiDocumentEntity<T>> getKVPairsResponseDeserializer() {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList docs = new ArrayList();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            VPackSlice kvs = response.getBody().get("result");
            Iterator iterator = kvs.arrayIterator();
            while (iterator.hasNext()) {
                VPackSlice next = (VPackSlice)iterator.next();
                if (next.get("error").isTrue()) {
                    ErrorEntity error = (ErrorEntity)this.util().deserialize(next, (Type)((Object)ErrorEntity.class));
                    errors.add(error);
                    documentsAndErrors.add(error);
                    continue;
                }
                Object doc = this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(next, (Type)((Object)BaseKeyValue.class));
                docs.add(doc);
                documentsAndErrors.add(doc);
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected Request deleteKVPairRequest(String key, DocumentDeleteOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_KV, this.name, "value", key);
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<DocumentDeleteEntity<T>> deleteKVPairResponseDeserializer(Class<T> type) {
        return response -> {
            VPackSlice body = response.getBody();
            DocumentDeleteEntity doc = (DocumentDeleteEntity)this.util().deserialize(body, (Type)((Object)DocumentDeleteEntity.class));
            VPackSlice oldDoc = body.get(OLD);
            if (oldDoc.isObject()) {
                doc.setOld(this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
            }
            return doc;
        };
    }

    protected <T> Request deleteKVPairsRequest(Collection<T> keys, DocumentDeleteOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_KV, this.name, "values");
        request.setBody(this.util().serialize(keys));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<MultiDocumentEntity<DocumentDeleteEntity<T>>> deleteKVPairsResponseDeserializer(Class<T> type) {
        return response -> {
            MultiDocumentEntity multiDocument = new MultiDocumentEntity();
            ArrayList<DocumentDeleteEntity> docs = new ArrayList<DocumentDeleteEntity>();
            ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
            ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
            VPackSlice body = response.getBody();
            if (body.isArray()) {
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)this.util().deserialize(next, (Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentDeleteEntity doc = (DocumentDeleteEntity)this.util().deserialize(next, (Type)((Object)DocumentDeleteEntity.class));
                    VPackSlice oldDoc = next.get(OLD);
                    if (oldDoc.isObject()) {
                        doc.setOld(this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(oldDoc, type));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
            }
            multiDocument.setDocuments(docs);
            multiDocument.setErrors(errors);
            multiDocument.setDocumentsAndErrors(documentsAndErrors);
            return multiDocument;
        };
    }

    protected Request createRequest(String name, Boolean expiration, CollectionCreateOptions options) {
        VPackSlice body = this.util().serialize(OptionsBuilder.build(options != null ? options : new CollectionCreateOptions(), name));
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_KV, name);
        request.putQueryParam(EXPIRATION, expiration);
        request.setBody(body);
        return request;
    }

    protected Request truncateRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.PUT, PATH_API_KV, this.name, "truncate");
    }

    protected Request dropRequest() {
        return this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_KV, this.name);
    }
}

