/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.arangodb.velocypack.VPackSlice;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.model.C8RedisCreateOptions;
import com.c8db.util.C8Serializer;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import java.util.HashMap;

public abstract class InternalC8Redis<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_REDIS = "/_api/collection";
    private final D db;
    protected volatile String tableName;
    protected SdkJsonProtocolFactory protocolFactory;

    public D db() {
        return this.db;
    }

    protected InternalC8Redis(D db, String tableName) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
        this.tableName = tableName;
        this.protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata());
    }

    protected Request createTableRequest(String tableName, C8RedisCreateOptions options) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_REDIS);
        HashMap<String, Object> internalOptions = new HashMap<String, Object>();
        internalOptions.put("name", tableName);
        internalOptions.put("collectionModel", 3);
        internalOptions.put("stream", options.getStream());
        VPackSlice slice = this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(internalOptions, new C8Serializer.Options().serializeNullValues(false).stringAsJson(true));
        request.setBody(slice);
        return request;
    }
}

