/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.C8StreamBacklogEntity;
import com.c8db.entity.C8StreamStatisticsEntity;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.util.Collection;

public abstract class InternalC8Stream<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, E extends C8Executor>
extends C8Executeable<E> {
    protected static final String PATH_API_STREAMS = "/_api/streams";
    private final D db;
    private final String name;

    protected InternalC8Stream(D db, String name) {
        super(((InternalC8Database)db).executor, ((InternalC8Database)db).util, ((InternalC8Database)db).context);
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected Request getC8StreamBacklogRequest() {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_STREAMS, this.name, "backlog");
        return request;
    }

    protected C8Executor.ResponseDeserializer<C8StreamBacklogEntity> getC8StreamBacklogResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<C8StreamBacklogEntity>(){

            @Override
            public C8StreamBacklogEntity deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (C8StreamBacklogEntity)InternalC8Stream.this.util().deserialize(result, new Type<C8StreamBacklogEntity>(){}.getType());
            }
        };
    }

    protected Request getC8StreamStatisticsRequest() {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_STREAMS, this.name, "stats");
        return request;
    }

    protected C8Executor.ResponseDeserializer<C8StreamStatisticsEntity> getC8StreamStatisticsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<C8StreamStatisticsEntity>(){

            @Override
            public C8StreamStatisticsEntity deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (C8StreamStatisticsEntity)InternalC8Stream.this.util().deserialize(result, new Type<C8StreamStatisticsEntity>(){}.getType());
            }
        };
    }

    protected Request deleteC8StreamRequest() {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_STREAMS, this.name);
        return request;
    }

    protected Request getC8StreamSubscriptionsRequest() {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.GET, PATH_API_STREAMS, this.name, "subscriptions");
        return request;
    }

    protected C8Executor.ResponseDeserializer<Collection<String>> getC8StreamSubscriptionsResponseDeserializer() {
        return new C8Executor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Collection)InternalC8Stream.this.util().deserialize(result, new Type<Collection<String>>(){}.getType());
            }
        };
    }

    protected Request expireMessagesRequest(int expireTimeInSeconds) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.POST, PATH_API_STREAMS, this.name, "expiry", Integer.toString(expireTimeInSeconds));
        return request;
    }

    protected Request deleteSubscriptionRequest(String subscriptionName) {
        Request request = this.request(((InternalC8Database)this.db).tenant(), ((InternalC8Database)this.db).name(), RequestType.DELETE, PATH_API_STREAMS, this.name, "subscriptions", subscriptionName);
        return request;
    }
}

