/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.c8db.entity.DocumentField;
import com.c8db.entity.VertexEntity;
import com.c8db.entity.VertexUpdateEntity;
import com.c8db.internal.C8Executeable;
import com.c8db.internal.C8Executor;
import com.c8db.internal.InternalC8DB;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.InternalC8Graph;
import com.c8db.internal.util.C8SerializationFactory;
import com.c8db.internal.util.DocumentUtil;
import com.c8db.model.GraphDocumentReadOptions;
import com.c8db.model.VertexCreateOptions;
import com.c8db.model.VertexDeleteOptions;
import com.c8db.model.VertexReplaceOptions;
import com.c8db.model.VertexUpdateOptions;
import com.c8db.util.C8Serializer;
import com.c8db.velocystream.Request;
import com.c8db.velocystream.RequestType;
import com.c8db.velocystream.Response;
import java.lang.reflect.Type;
import java.util.HashMap;

public abstract class InternalC8VertexCollection<A extends InternalC8DB<E>, D extends InternalC8Database<A, E>, G extends InternalC8Graph<A, D, E>, E extends C8Executor>
extends C8Executeable<E> {
    private final G graph;
    private final String name;

    protected InternalC8VertexCollection(G graph, String name) {
        super(((InternalC8Graph)graph).executor, ((InternalC8Graph)graph).util, ((InternalC8Graph)graph).context);
        this.graph = graph;
        this.name = name;
    }

    public G graph() {
        return this.graph;
    }

    public String name() {
        return this.name;
    }

    protected Request dropRequest() {
        return this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.DELETE, "/_api/graph", ((InternalC8Graph)this.graph).name(), "vertex", this.name);
    }

    protected <T> Request insertVertexRequest(T value, VertexCreateOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.POST, "/_api/graph", ((InternalC8Graph)this.graph).name(), "vertex", this.name);
        VertexCreateOptions params = options != null ? options : new VertexCreateOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<VertexEntity> insertVertexResponseDeserializer(final T value) {
        return new C8Executor.ResponseDeserializer<VertexEntity>(){

            @Override
            public VertexEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get("vertex");
                VertexEntity doc = (VertexEntity)InternalC8VertexCollection.this.util().deserialize(body, (Type)((Object)VertexEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.ID, doc.getId());
                values.put(DocumentField.Type.KEY, doc.getKey());
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalC8VertexCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected Request getVertexRequest(String key, GraphDocumentReadOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.GET, "/_api/graph", ((InternalC8Graph)this.graph).name(), "vertex", DocumentUtil.createDocumentHandle(this.name, key));
        GraphDocumentReadOptions params = options != null ? options : new GraphDocumentReadOptions();
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<T> getVertexResponseDeserializer(final Class<T> type) {
        return new C8Executor.ResponseDeserializer<T>(){

            @Override
            public T deserialize(Response response) throws VPackException {
                return InternalC8VertexCollection.this.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(response.getBody().get("vertex"), type);
            }
        };
    }

    protected <T> Request replaceVertexRequest(String key, T value, VertexReplaceOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.PUT, "/_api/graph", ((InternalC8Graph)this.graph).name(), "vertex", DocumentUtil.createDocumentHandle(this.name, key));
        VertexReplaceOptions params = options != null ? options : new VertexReplaceOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<VertexUpdateEntity> replaceVertexResponseDeserializer(final T value) {
        return new C8Executor.ResponseDeserializer<VertexUpdateEntity>(){

            @Override
            public VertexUpdateEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get("vertex");
                VertexUpdateEntity doc = (VertexUpdateEntity)InternalC8VertexCollection.this.util().deserialize(body, (Type)((Object)VertexUpdateEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalC8VertexCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected <T> Request updateVertexRequest(String key, T value, VertexUpdateOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.PATCH, "/_api/graph", ((InternalC8Graph)this.graph).name(), "vertex", DocumentUtil.createDocumentHandle(this.name, key));
        VertexUpdateOptions params = options != null ? options : new VertexUpdateOptions();
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util(C8SerializationFactory.Serializer.CUSTOM).serialize(value, new C8Serializer.Options().serializeNullValues(true)));
        return request;
    }

    protected <T> C8Executor.ResponseDeserializer<VertexUpdateEntity> updateVertexResponseDeserializer(final T value) {
        return new C8Executor.ResponseDeserializer<VertexUpdateEntity>(){

            @Override
            public VertexUpdateEntity deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody().get("vertex");
                VertexUpdateEntity doc = (VertexUpdateEntity)InternalC8VertexCollection.this.util().deserialize(body, (Type)((Object)VertexUpdateEntity.class));
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalC8VertexCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected Request deleteVertexRequest(String key, VertexDeleteOptions options) {
        Request request = this.request(((InternalC8Database)((InternalC8Graph)this.graph).db()).tenant(), ((InternalC8Database)((InternalC8Graph)this.graph).db()).name(), RequestType.DELETE, "/_api/graph", ((InternalC8Graph)this.graph).name(), "vertex", DocumentUtil.createDocumentHandle(this.name, key));
        VertexDeleteOptions params = options != null ? options : new VertexDeleteOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }
}

