/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.cursor;

import com.c8db.C8Iterable;
import com.c8db.Function;
import com.c8db.Predicate;
import com.c8db.internal.cursor.C8FilterIterable;
import com.c8db.internal.cursor.C8MappingIterable;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractC8Iterable<T>
implements C8Iterable<T> {
    @Override
    public <R> C8Iterable<R> map(Function<? super T, ? extends R> mapper) {
        return new C8MappingIterable<T, R>(this, mapper);
    }

    @Override
    public C8Iterable<T> filter(Predicate<? super T> predicate) {
        return new C8FilterIterable<T>(this, predicate);
    }

    @Override
    public T first() {
        Iterator iterator = this.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    @Override
    public long count() {
        long count = 0L;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        boolean match = false;
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            match = true;
            break;
        }
        return match;
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        Object t;
        boolean match = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && (match = predicate.test(t = iterator.next()))) {
        }
        return match;
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        Object t;
        boolean match = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && (match = !predicate.test(t = iterator.next()))) {
        }
        return match;
    }

    @Override
    public <R extends Collection<? super T>> R collectInto(R target) {
        for (Object t : this) {
            target.add(t);
        }
        return target;
    }
}

