/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.cursor;

import com.c8db.C8Cursor;
import com.c8db.C8Iterator;
import com.c8db.Consumer;
import com.c8db.entity.CursorEntity;
import com.c8db.internal.C8CursorExecute;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.cursor.AbstractC8Iterable;
import com.c8db.internal.cursor.C8CursorIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class C8CursorImpl<T>
extends AbstractC8Iterable<T>
implements C8Cursor<T> {
    private final Class<T> type;
    protected final C8CursorIterator<T> iterator;
    private final String id;
    private final C8CursorExecute execute;

    public C8CursorImpl(InternalC8Database<?, ?> db, C8CursorExecute execute, Class<T> type, CursorEntity result) {
        this.execute = execute;
        this.type = type;
        this.iterator = this.createIterator(this, db, execute, result);
        this.id = result.getId();
    }

    protected C8CursorIterator<T> createIterator(C8Cursor<T> cursor, InternalC8Database<?, ?> db, C8CursorExecute execute, CursorEntity result) {
        return new C8CursorIterator<T>(cursor, execute, db, result);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Integer getCount() {
        return this.iterator.getResult().getCount();
    }

    @Override
    public CursorEntity.Stats getStats() {
        CursorEntity.Extras extra = this.iterator.getResult().getExtra();
        return extra != null ? extra.getStats() : null;
    }

    @Override
    public Collection<CursorEntity.Warning> getWarnings() {
        CursorEntity.Extras extra = this.iterator.getResult().getExtra();
        return extra != null ? extra.getWarnings() : null;
    }

    @Override
    public boolean isCached() {
        Boolean cached = this.iterator.getResult().getCached();
        return Boolean.TRUE == cached;
    }

    @Override
    public void close() {
        if (this.id != null && this.hasNext()) {
            this.execute.close(this.id, this.iterator.getResult().getMeta());
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public List<T> asListRemaining() {
        ArrayList<T> remaining = new ArrayList<T>();
        while (this.hasNext()) {
            remaining.add(this.next());
        }
        return remaining;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public C8Iterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public void foreach(Consumer<? super T> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }
}

