/*
 * Decompiled with CFR 0.152.
 */
package com.c8db.internal.cursor;

import com.arangodb.velocypack.VPackSlice;
import com.c8db.C8Cursor;
import com.c8db.C8Iterator;
import com.c8db.entity.CursorEntity;
import com.c8db.internal.C8CursorExecute;
import com.c8db.internal.InternalC8Database;
import com.c8db.internal.util.C8SerializationFactory;
import java.util.NoSuchElementException;

public class C8CursorIterator<T>
implements C8Iterator<T> {
    private CursorEntity result;
    private int pos;
    private final C8Cursor<T> cursor;
    private final InternalC8Database<?, ?> db;
    private final C8CursorExecute execute;

    protected C8CursorIterator(C8Cursor<T> cursor, C8CursorExecute execute, InternalC8Database<?, ?> db, CursorEntity result) {
        this.cursor = cursor;
        this.execute = execute;
        this.db = db;
        this.result = result;
        this.pos = 0;
    }

    public CursorEntity getResult() {
        return this.result;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.result.getResult().size() || this.result.getHasMore() != null && this.result.getHasMore() != false;
    }

    @Override
    public T next() {
        if (this.pos >= this.result.getResult().size() && this.result.getHasMore().booleanValue()) {
            this.result = this.execute.next(this.cursor.getId(), this.result.getMeta());
            this.pos = 0;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.deserialize(this.result.getResult().get(this.pos++), this.cursor.getType());
    }

    protected <R> R deserialize(VPackSlice result, Class<R> type) {
        return (R)this.db.util(C8SerializationFactory.Serializer.CUSTOM).deserialize(result, type);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

